/*
 * Decompiled with CFR 0.152.
 */
package JniorProtocol.Devices;

import JniorProtocol.Devices.Device;
import JniorProtocol.Devices.Jr310InternalInput;
import JniorProtocol.Devices.Jr310InternalOutput;
import JniorProtocol.Exceptions.CommandTimeoutException;
import JniorProtocol.Exceptions.NotLoggedInException;
import JniorProtocol.Exceptions.NotYetConnectedException;
import JniorProtocol.Helpers.Version;
import JniorProtocol.JniorSession;
import JniorProtocol.Listeners.StateListener;
import JniorProtocol.Registry.Registry;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.EventObject;

public abstract class Jr310Internals
extends Device {
    public static final int RECV_MONITOR = 1;
    public static final int RECV_EXTERNAL_MONITOR = 2;
    public static final int COMMAND = 10;
    public static final int COMMAND_CLOSE = 1;
    public static final int COMMAND_OPEN = 2;
    public static final int COMMAND_TOGGLE = 3;
    public static final int COMMAND_RESET_INPUT_LATCH = 4;
    public static final int COMMAND_CLEAR_INPUT_COUNTER = 5;
    public static final int COMMAND_PULSE = 6;
    public static final int COMMAND_BLOCK_PULSE = 7;
    public static final int COMMAND_CLEAR_INPUT_USAGE_METER = 8;
    public static final int COMMAND_CLEAR_OUTPUT_USAGE_METER = 9;
    public static final int COMMAND_BLOCK_SET = 10;
    public static final int MONITOR_PACKET = 1;
    public static final int INPUT = 0;
    public static final int OUTPUT = 1;
    protected boolean m_monitorPacketsEnabled = true;
    protected boolean m_monitorPacketReceived = false;
    private String m_softwareVersion;
    public String m_model;
    public Version m_osVersion;
    private Jr310InternalInput[] m_inputs = null;
    private Jr310InternalOutput[] m_outputs = null;
    public long m_currentTime;
    public byte m_currentState = 0;
    public long m_usageMeter = 0L;
    public byte m_usageAlarm = 0;
    public int INPUTS = 8;
    public int m_inputStates;
    public int OUTPUTS = 8;
    public int m_outputStates;

    public Jr310Internals(JniorSession jniorSession) {
        super(jniorSession);
        this.init();
    }

    public void init() {
        String string = this.getClass().getName().toString();
        if (this.getClass().getName().equals("JniorProtocol.JniorSession$AbstractInternals")) {
            int n;
            if (this.m_inputs == null) {
                this.m_inputs = new Jr310InternalInput[16];
                for (n = 0; n < 16; ++n) {
                    this.m_inputs[n] = new AbstractInput(this.m_session, n);
                }
            }
            if (this.m_outputs == null) {
                this.m_outputs = new Jr310InternalOutput[16];
                for (n = 0; n < 16; ++n) {
                    this.m_outputs[n] = new AbstractOutput(this.m_session, n);
                }
            }
        }
    }

    public int getChannel() {
        return this.m_channel;
    }

    public int getState() throws CommandTimeoutException, NotYetConnectedException {
        if (!this.m_monitorPacketsEnabled) {
            this.m_monitorPacketReceived = false;
            this.requestMonitorPacket();
            long l = System.currentTimeMillis();
            while (this.m_session.isConnected() && this.m_session.isConnected() && !this.m_monitorPacketReceived && !this.isCommandTimeout(l)) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return this.m_currentState;
    }

    public Device[] enumerate() throws CommandTimeoutException, NotYetConnectedException, NotLoggedInException {
        return this.m_session.enumerate(1);
    }

    public void setEnableMonitorPackets(boolean bl) throws NotYetConnectedException {
        this.m_monitorPacketsEnabled = bl;
        if (bl) {
            this.m_session.getRequestInstance().buildRequestPacket(5);
        } else {
            this.m_session.getRequestInstance().buildRequestPacket(4);
        }
    }

    public void blockPulseRelay(int n, int n2, int n3) throws NotYetConnectedException, NotLoggedInException {
        this.m_session.isLoggedIn();
        byte[] byArray = new byte[10];
        int n4 = 0;
        byArray[n4++] = 10;
        byArray[n4++] = 7;
        byArray = Jr310Internals.setShort(byArray, n4, (short)n);
        byArray = Jr310Internals.setShort(byArray, n4 += 2, (short)n2);
        byArray = Jr310Internals.setInt(byArray, n4 += 2, n3);
        n4 += 4;
        try {
            this.send(byArray, 0, n4);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void blockSetRelay(int n, int n2) throws NotYetConnectedException, NotLoggedInException {
        this.m_session.isLoggedIn();
        byte[] byArray = new byte[10];
        int n3 = 0;
        byArray[n3++] = 10;
        byArray[n3++] = 10;
        byArray = Jr310Internals.setShort(byArray, n3, (short)n);
        byArray = Jr310Internals.setShort(byArray, n3 += 2, (short)n2);
        n3 += 2;
        try {
            this.send(byArray, 0, n3);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    protected void buildCommandPacket(int n) throws NotYetConnectedException {
        this.buildCommandPacket(n, 0);
    }

    protected void buildCommandPacket(int n, int n2) throws NotYetConnectedException {
        byte[] byArray = new byte[8];
        int n3 = 0;
        byArray[n3++] = 10;
        byArray[n3++] = (byte)n;
        byArray = Jr310Internals.setShort(byArray, n3, (short)this.m_channel);
        n3 += 2;
        if (n == 6) {
            byArray = Jr310Internals.setInt(byArray, n3, n2);
            n3 += 4;
        }
        try {
            this.send(byArray, 0, n3);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    protected void buildCommandPacket(int n, int n2, int n3, int n4) throws NotYetConnectedException {
        byte[] byArray = new byte[8];
        int n5 = 0;
        byArray[n5++] = 10;
        byArray[n5++] = (byte)n;
        byArray[n5++] = (byte)n2;
        byArray[n5++] = (byte)n3;
        if (n == 7) {
            byArray = Jr310Internals.setInt(byArray, n5, n4);
            n5 += 4;
        }
        try {
            this.send(byArray, 0, n5);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public boolean requestMonitorPacket() throws NotYetConnectedException {
        return this.requestMonitorPacket(false);
    }

    public boolean requestMonitorPacket(boolean bl) throws NotYetConnectedException {
        if (!this.m_monitorPacketsEnabled || bl) {
            this.m_session.getRequestInstance().buildRequestPacket(1);
        } else {
            this.fireMonitorReceived();
        }
        return !this.m_monitorPacketsEnabled;
    }

    public Jr310InternalInput getInput(int n) throws IllegalArgumentException {
        if (n < 1 || n > this.INPUTS) {
            throw new IllegalArgumentException("Channel Out of Range.");
        }
        return this.m_inputs[n - 1];
    }

    public Jr310InternalOutput getOutput(int n) throws IllegalArgumentException {
        if (n < 1 || n > this.OUTPUTS) {
            throw new IllegalArgumentException("Channel Out of Range.");
        }
        return this.m_outputs[n - 1];
    }

    public void receive(ByteArrayInputStream byteArrayInputStream, int n) {
        try {
            switch (n) {
                case 1: {
                    int n2;
                    this.m_softwareVersion = Jr310Internals.getString(byteArrayInputStream);
                    String[] stringArray = this.m_softwareVersion.split(" v");
                    this.m_model = stringArray[0];
                    this.m_osVersion = new Version(stringArray[1]);
                    Registry registry = this.m_session.getRegistryInstance();
                    registry.getRegKey("$Model").setValue(stringArray[0]);
                    registry.getRegKey("$Version").setValue(stringArray[1]);
                    for (n2 = 0; n2 < 8; ++n2) {
                        this.m_inputs[n2].receive(byteArrayInputStream, true);
                    }
                    for (n2 = 0; n2 < 8; ++n2) {
                        this.m_outputs[n2].receive(byteArrayInputStream, true);
                    }
                    this.m_session.m_lastKnownJniorTime = this.m_currentTime = Jr310Internals.getLong(byteArrayInputStream);
                    if (this.m_stateListeners == null) break;
                    this.fireMonitorReceived();
                    break;
                }
                case 2: {
                    int n3;
                    int n4 = Jr310Internals.get(byteArrayInputStream);
                    for (n3 = 0; n3 < n4; ++n3) {
                        this.m_inputs[n3 + 8].receive(byteArrayInputStream, true);
                    }
                    n4 = Jr310Internals.get(byteArrayInputStream);
                    for (n3 = 0; n3 < n4; ++n3) {
                        this.m_outputs[n3 + 8].receive(byteArrayInputStream, true);
                    }
                    this.m_session.m_lastKnownJniorTime = this.m_currentTime = Jr310Internals.getLong(byteArrayInputStream);
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void fireMonitorReceived() {
        for (int i = 0; i < this.m_stateListeners.size(); ++i) {
            ((StateListener)this.m_stateListeners.elementAt(i)).onMonitorPacketReceived(new EventObject(this.m_session), this);
        }
    }

    class AbstractOutput
    extends Jr310InternalOutput {
        public AbstractOutput(JniorSession jniorSession, int n) {
            super(jniorSession, n);
        }
    }

    class AbstractInput
    extends Jr310InternalInput {
        public AbstractInput(JniorSession jniorSession, int n) {
            super(jniorSession, n);
        }
    }
}

