/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.system;

import com.integpg.system.JANOS;

public class RegistryHelper {
    private static final String EMPTY_STRING = "";

    public static String getRegistryKey(String keyName, String defaultValue) {
        String value = JANOS.getRegistryString((String)keyName, (String)EMPTY_STRING);
        if (value.equals(EMPTY_STRING)) {
            value = defaultValue;
            JANOS.setSystemKey((String)keyName, (String)value);
        }
        return value;
    }

    public static String[] getRegistryKeys(String keyName, String defaultValue) {
        String[] value = null;
        try {
            value = JANOS.getRegistryKey((String)keyName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (value == null || value.length == 0) {
            if (defaultValue != null && !defaultValue.equals(EMPTY_STRING)) {
                JANOS.setSystemKey((String)keyName, (String)defaultValue);
            }
            try {
                value = JANOS.getRegistryKey((String)keyName);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return value;
    }

    public static boolean getRegistryKey(String keyName, boolean defaultValue) {
        boolean value = JANOS.getRegistryBoolean((String)keyName, (boolean)defaultValue);
        if (value == defaultValue) {
            JANOS.setSystemKey((String)keyName, (String)String.valueOf(value));
        }
        return value;
    }

    public static double getRegistryKey(String keyName, double defaultValue) {
        double value = JANOS.getRegistryDouble((String)keyName, (double)Double.MIN_VALUE);
        if (value == Double.MIN_VALUE) {
            value = defaultValue;
            JANOS.setSystemKey((String)keyName, (String)Double.toString(value));
        }
        return value;
    }

    public static int getRegistryKey(String keyName, int defaultValue) {
        int value = JANOS.getRegistryInt((String)keyName, (int)Integer.MIN_VALUE);
        if (value == Integer.MIN_VALUE) {
            value = defaultValue;
            JANOS.setSystemKey((String)keyName, (String)Integer.toString(value));
        }
        return value;
    }
}

