/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.datastructures;

import java.io.IOException;

public class CircularQueue<T> {
    private Object[] _items;
    private int _head = 0;
    private int _tail = 0;
    private int _capacity;

    public CircularQueue(int capacity) {
        this._capacity = capacity;
        this._items = new Object[capacity];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFull() {
        CircularQueue circularQueue = this;
        synchronized (circularQueue) {
            if (this._head > this._tail) {
                return this._head - this._tail == this._capacity - 1;
            }
            return this._tail == this._head + 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        CircularQueue circularQueue = this;
        synchronized (circularQueue) {
            return this._head == this._tail;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        CircularQueue circularQueue = this;
        synchronized (circularQueue) {
            if (this._head >= this._tail) {
                return this._head - this._tail;
            }
            return this._capacity - this._tail + this._head;
        }
    }

    public int capacity() {
        return this._capacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(T object) throws IOException {
        if (!this.isFull()) {
            CircularQueue circularQueue = this;
            synchronized (circularQueue) {
                this._items[this._head++] = object;
                if (this._head >= this._capacity) {
                    this._head = 0;
                }
            }
        } else {
            throw new IOException("Queue is full");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T dequeue() throws IOException {
        if (!this.isEmpty()) {
            CircularQueue circularQueue = this;
            synchronized (circularQueue) {
                Object o = this._items[this._tail++];
                if (this._tail >= this._capacity) {
                    this._tail = 0;
                }
                return (T)o;
            }
        }
        throw new IOException("Queue is empty");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object peek() throws IOException {
        if (!this.isEmpty()) {
            CircularQueue circularQueue = this;
            synchronized (circularQueue) {
                return this._items[this._tail];
            }
        }
        throw new IOException("Queue is empty");
    }
}

