/* global bootbox, Tasker */

TaskerApp.controller('SignalController', function ($scope, $compile, SignalService, DevicesService) {
    var _this = this;



    _this.getDevicesInfo = function () {
        return DevicesService.DevicesInfo;
    };



    _this.getDeviceInfoByType = function (type) {
        return DevicesService.getDeviceInfoByType(type);
    };



    _this.areSignalsLoaded = function () {
        return SignalService.SignalsLoaded;
    };



    _this.getSignals = function () {
        return SignalService.SignalsList;
    };



    _this.addSignalProfile = function () {
        bootbox.prompt({
            className: 'bb-success',
            title: "What is the name of the new Signal?",
            buttons: {
                cancel: {
                    label: 'Cancel',
                    className: 'btn-default'
                },
                confirm: {
                    label: 'Add',
                    className: 'btn-success btn-submit'
                }
            },
            callback: function (result) {
                if (result) {
                    if (undefined == SignalService.SignalsList) SignalService.SignalsList = [];

                    // make sure there isnt already one with the same name
                    if (SignalService.SignalsList) {
                        for (var i = 0; i < SignalService.SignalsList.length; i++) {
                            if (SignalService.SignalsList[i].Name === result) {
                                bootbox.alert({
                                    className: 'bb-danger',
                                    title: "Duplicate Signal Name",
                                    message: "Signal already exists with the name: <b>" + result + '</b>'
                                });
                                return false;
                            }
                        }
                    }

                    SignalService.SignalsList.push({ Name: result, Params: { Enabled: true }, GUID: guid() });
                    $scope.$apply();
                }
            }
        }).init(function () {
            validate_alphanumeric($(".bootbox-input"));
            submit_on_enter($(".bootbox-input"));
        });
    };



    _this.editSignalName = function (signal) {
        bootbox.prompt({
            className: 'bb-success',
            title: "Edit the name of the Signal?",
            message: '<p class="alert alert-warning"><b>Careful!</b>  Changing the name of the' +
                ' Signal can have negative consequences if it it referenced elsewhere in Tasker. ' +
                ' Please make sure to change the name used in the references.</p>',
            buttons: {
                cancel: {
                    label: 'Cancel',
                    className: 'btn-default'
                },
                confirm: {
                    label: 'Update',
                    className: 'btn-success'
                }
            },
            value: signal.Name,
            callback: function (result) {
                if (result) {
                    signal.Name = result;
                    $scope.$apply();
                }
            }
        }).init(function () {
            validate_alphanumeric($(".bootbox-input"));
            submit_on_enter($(".bootbox-input"));
        });
    };



    _this.removeSignalProfile = function (signalProfile) {
        _this.SaveDialog = bootbox.confirm({
            className: 'bb-warning',
            title: "Are you sure you want to remove the " + signalProfile.Name + " signal profile?",
            message: "Are you sure you want to remove the <b>" + signalProfile.Name + "</b> signal profile?",
            buttons: {
                cancel: {
                    label: 'Cancel',
                    className: 'btn-default'
                },
                confirm: {
                    label: 'Remove',
                    className: 'btn-warning'
                }
            },
            callback: function (result) {
                if (result) {
                    for (var i = SignalService.SignalsList.length - 1; i >= 0; i--) {
                        if (SignalService.SignalsList[i] === signalProfile) {
                            SignalService.SignalsList.splice(i, 1);
                            $scope.$apply();
                            return;
                        }
                    }
                }
            }
        });
        _this.SaveDialog.init(function () {
            $("#bootbox-confirm-btn").prop('disabled', false);
            $("#bootbox-cancel-btn").prop('disabled', false);
        });
    };

});



/*
   SERVICE
*/
TaskerApp.service('SignalService', function ($rootScope) {
    var _this = this;
    _this.SignalsList = [];
    _this.SelectedSignal = null;
    _this.SignalsLoaded = false;




    _this.load = function (deviceListJson) {
        if (undefined == deviceListJson) deviceListJson = [];

        try {
            parseSignalList(deviceListJson);
        } catch (err) {
            console.error(err);
        }

        _this.SelectedSignal = null;
        _this.SignalsLoaded = true;

        return _this.SignalsList;
    };



    function parseSignalList(signalArray) {
        _this.SignalsList = signalArray;
    }



    _this.validate = function () {
        var form = $("#signals-form");
        form.validate({ errorPlacement: function (error, element) { } });
        return form.valid();
    };
});