/*
 * Decompiled with CFR 0.152.
 */
package com.integ.scripting;

import com.integ.scripting.exceptions.ScriptParserException;
import com.integ.scripting.exceptions.UnexpectedTokenException;
import com.integ.scripting.nodes.AbstractNode;
import com.integ.scripting.nodes.BinaryNode;
import com.integ.scripting.nodes.LogicalNode;
import com.integ.scripting.nodes.UnaryNode;
import com.integ.scripting.nodes.ValueNode;
import com.integ.scripting.objects.AbstractObject;
import com.integ.scripting.objects.ArrayUtilsObject;
import com.integ.scripting.objects.AssignmentObject;
import com.integ.scripting.objects.BlockObject;
import com.integ.scripting.objects.DateObject;
import com.integ.scripting.objects.DigitalInputObject;
import com.integ.scripting.objects.EnvironObject;
import com.integ.scripting.objects.FourTwentyInputObject;
import com.integ.scripting.objects.FourTwentyOutputObject;
import com.integ.scripting.objects.IntObject;
import com.integ.scripting.objects.MathObject;
import com.integ.scripting.objects.PrintObject;
import com.integ.scripting.objects.ReferenceObject;
import com.integ.scripting.objects.RegistryObject;
import com.integ.scripting.objects.RelayOutputObject;
import com.integ.scripting.objects.StringObject;
import com.integ.scripting.objects.TempProbeObject;
import com.integ.scripting.objects.TenVoltInputObject;
import com.integ.scripting.objects.TenVoltOutputObject;
import com.integ.scripting.objects.TimeObject;
import com.integ.tasker.tasks.Scope;
import com.integpg.janoslib.datastructures.Queue;
import com.integpg.janoslib.lexer.Lexer;
import com.integpg.janoslib.lexer.Token;
import com.integpg.janoslib.lexer.TokenStream;
import java.io.ByteArrayOutputStream;

public class ExpressionEngine {
    private boolean Debug = false;
    private final Queue _tokenQueue = new Queue();
    private final TokenStream _tokens = new TokenStream(this._tokenQueue);
    private final BlockObject _root = new BlockObject();
    private String _script;

    public boolean shouldDebug() {
        return this.Debug;
    }

    public void setDebug(boolean shouldDebug) {
        this.Debug = shouldDebug;
        this._tokens.printDebug(shouldDebug);
    }

    public void parse(String script) throws Exception {
        this._script = script;
        this._tokens.clear();
        Lexer.parse(this._tokenQueue, script);
        this._root.parse(this);
    }

    public Token currentToken() {
        return this._tokens.currentToken();
    }

    public Token nextToken() {
        Token nextToken = this._tokens.nextToken();
        if (this.Debug) {
            System.out.println(String.format("   next token: %s", nextToken.toString()));
        }
        return nextToken;
    }

    public Token peekToken() {
        Token peekToken = this._tokens.peekToken();
        if (this.Debug) {
            if (null != peekToken) {
                System.out.println(String.format("   peek token: %s", peekToken.toString()));
            } else {
                System.out.println("   peek token: null");
            }
        }
        return peekToken;
    }

    public boolean isEmpty() {
        return this._tokens.isEmpty();
    }

    public AbstractNode parseStatement() throws ScriptParserException {
        Token currentToken = this._tokens.getCurrent();
        if (this.Debug) {
            System.out.println(String.format("getStatement(%s)", currentToken.toString()));
        }
        AbstractObject abstractObject = null;
        if (currentToken.checkContent("print")) {
            abstractObject = new PrintObject();
            abstractObject.parse(this);
        } else if (currentToken.checkContent("set")) {
            this.nextToken();
            abstractObject = new AssignmentObject();
            abstractObject.parse(this);
        } else if (!this._tokens.isEmpty() && this.peekToken().checkType(61)) {
            abstractObject = new AssignmentObject();
            abstractObject.parse(this);
        } else {
            return this.getObject();
        }
        if (!this.isEmpty() && !this.nextToken().checkType(59)) {
            throw new UnexpectedTokenException(";", this.currentToken());
        }
        if (!this.isEmpty()) {
            this.nextToken();
        }
        return abstractObject;
    }

    public AbstractNode getObject() throws ScriptParserException {
        if (this.Debug) {
            System.out.println("getObject current token: " + this.currentToken().toString());
        }
        return this.getLogical();
    }

    public AbstractNode getLogical() throws ScriptParserException {
        if (this.Debug) {
            System.out.println("getLogical current token: " + this.currentToken().toString());
        }
        AbstractNode cNode = this.getComparison();
        Token peekToken = this.peekToken();
        if (null != peekToken && (peekToken.checkType(59) || peekToken.checkType(44) || peekToken.checkType(41) || peekToken.checkType(93))) {
            return cNode;
        }
        if (!this._tokens.isEmpty()) {
            Token token = this.nextToken();
            if (this.Debug) {
                System.out.println("getLogical operator token: " + token.toString());
            }
            switch (token.type) {
                default: 
            }
        }
        return cNode;
    }

    public AbstractNode getComparison() throws ScriptParserException {
        if (this.Debug) {
            System.out.println("getComparison current token: " + this.currentToken().toString());
        }
        AbstractNode eNode = this.getExpression();
        Token peekToken = this.peekToken();
        if (null != peekToken && (peekToken.checkType(59) || peekToken.checkType(44) || peekToken.checkType(41) || peekToken.checkType(93))) {
            return eNode;
        }
        if (!this._tokens.isEmpty()) {
            Token token = this.nextToken();
            if (this.Debug) {
                System.out.println("getComparison operator token: " + token.toString());
            }
            this.nextToken();
            AbstractNode cNode = this.getComparison();
            return this.createLogicalNode(token, eNode, cNode);
        }
        return eNode;
    }

    private AbstractNode getExpression() throws ScriptParserException {
        if (this.Debug) {
            System.out.println(String.format("getExpression(): %s", this.currentToken().toString()));
        }
        AbstractNode t1node = this.getTerm();
        Token peekToken = this.peekToken();
        while (null != peekToken && (peekToken.checkType(43) || peekToken.checkType(45))) {
            this.nextToken();
            Token token = this.currentToken();
            this.nextToken();
            AbstractNode t2node = this.getTerm();
            t1node = this.createBinaryNode(token, t1node, t2node);
            peekToken = this.peekToken();
        }
        return t1node;
    }

    private AbstractNode getTerm() throws ScriptParserException {
        if (this.Debug) {
            System.out.println(String.format("getTerm(): %s", this.currentToken().toString()));
        }
        AbstractNode f1node = this.getFactor();
        Token peekToken = this.peekToken();
        while (null != peekToken && (peekToken.checkType(42) || peekToken.checkType(47))) {
            this.nextToken();
            Token token = this.currentToken();
            this.nextToken();
            AbstractNode f2node = this.getFactor();
            f1node = this.createBinaryNode(token, f1node, f2node);
            peekToken = this.peekToken();
        }
        return f1node;
    }

    public AbstractNode getFactor() throws ScriptParserException {
        if (this.Debug) {
            System.out.println(String.format("getFactor(): %s", this.currentToken().toString()));
        }
        Token currentToken = this.currentToken();
        switch (currentToken.type) {
            case 40: {
                this.nextToken();
                AbstractNode node = this.getExpression();
                if (!this.peekToken().checkType(41)) {
                    throw new UnexpectedTokenException(")", currentToken);
                }
                this.nextToken();
                return node;
            }
            case 45: {
                this.nextToken();
                AbstractNode node = this.getFactor();
                return this.createUnaryNode(node);
            }
            case 4: {
                return new ValueNode(currentToken.content);
            }
            case 16: {
                return new ValueNode(currentToken.content);
            }
            case 3: {
                if (-1 == currentToken.content.indexOf(".")) {
                    return new ValueNode(Integer.valueOf(currentToken.content));
                }
                return new ValueNode(Double.valueOf(currentToken.content));
            }
            case 15: {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                baos.write(Integer.parseInt(this.currentToken().content, 16));
                while (this.peekToken().checkType(15)) {
                    this.nextToken();
                    baos.write(Integer.parseInt(this.currentToken().content, 16));
                }
                return new ValueNode(baos.toByteArray());
            }
            case 0: {
                AbstractObject abstractObject = this.getIdentifier();
                return abstractObject.parse(this);
            }
        }
        return null;
    }

    private AbstractObject getIdentifier() throws ScriptParserException {
        Token currentToken = this.currentToken();
        if (this.Debug) {
            System.out.println(String.format("getIdentifier(): %s", this.currentToken().toString()));
        }
        AbstractObject abstractObject = null;
        abstractObject = currentToken.checkContent("din") ? new DigitalInputObject() : (currentToken.checkContent("rout") ? new RelayOutputObject() : (currentToken.checkContent("iin") ? new FourTwentyInputObject() : (currentToken.checkContent("iout") ? new FourTwentyOutputObject() : (currentToken.checkContent("vin") ? new TenVoltInputObject() : (currentToken.checkContent("vout") ? new TenVoltOutputObject() : (currentToken.checkContent("arrayutils") ? new ArrayUtilsObject() : (currentToken.checkContent("date") ? new DateObject() : (currentToken.checkContent("time") ? new TimeObject() : (currentToken.checkContent("string") ? new StringObject() : (currentToken.checkContent("temp") ? new TempProbeObject() : (currentToken.checkContent("env") ? new EnvironObject() : (currentToken.checkContent("reg") || currentToken.checkContent("registry") ? new RegistryObject() : (currentToken.checkContent("math") ? new MathObject() : (currentToken.checkContent("int") ? new IntObject() : new ReferenceObject()))))))))))))));
        return abstractObject;
    }

    private AbstractNode createBinaryNode(Token operator, AbstractNode left, AbstractNode right) {
        BinaryNode node = new BinaryNode(operator, left, right);
        if (this.Debug) {
            System.out.println(String.format("createBinarylNode(%s, %s, %s) = %s", operator.toString(), left.toString(), right.toString(), node.toString()));
        }
        return node;
    }

    private AbstractNode createLogicalNode(Token operator, AbstractNode left, AbstractNode right) {
        LogicalNode node = new LogicalNode(operator, left, right);
        if (this.Debug) {
            System.out.println(String.format("createLogicalNode(%s, %s, %s) = %s", operator.toString(), left.toString(), right.toString(), node.toString()));
        }
        return node;
    }

    private AbstractNode createUnaryNode(AbstractNode left) {
        UnaryNode node = new UnaryNode(new Token(45, "0", 0, 0), left);
        if (this.Debug) {
            System.out.println("createUnaryNode(" + left + ") = " + node);
        }
        return node;
    }

    private AbstractNode createValueNode(Number value) {
        ValueNode node = new ValueNode(value);
        if (this.Debug) {
            System.out.println("createValueNode(" + value + ") = " + node);
        }
        return node;
    }

    public Object execute(Scope scope) {
        return this._root.execute(scope);
    }
}

