/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.snmp;

import com.integ.common.debug.DEBUG;
import com.integ.common.utils.HexUtils;
import com.integpg.snmp.objects.SNMPCodec;
import com.integpg.snmp.objects.SNMPInteger;
import com.integpg.snmp.objects.SNMPMessage;
import com.integpg.snmp.objects.SNMPOctetString;
import com.integpg.snmp.objects.SNMPPDU;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;

class PDUSender {
    private final int _remotePort;

    public PDUSender(int remotePort) {
        this._remotePort = remotePort;
    }

    protected void send(InetAddress hostAddress, int port, String community, SNMPPDU pdu) throws IOException {
        this.send(0, hostAddress, port, community, pdu);
    }

    protected void send(int version, InetAddress hostAddress, int port, String community, SNMPPDU pdu) throws IOException {
        SNMPMessage message = new SNMPMessage(new SNMPInteger(version), new SNMPOctetString(community), pdu);
        this.send(hostAddress, port, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void send(InetAddress hostAddress, int port, SNMPMessage snmpMessage) throws IOException {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        SNMPCodec outCodec = new SNMPCodec(baout);
        snmpMessage.encodeBER(outCodec);
        byte[] outBytes = baout.toByteArray();
        if (DEBUG.ON) {
            System.out.println(HexUtils.hexDump(outBytes, 0, outBytes.length));
        }
        try (DatagramSocket datagramSocket = new DatagramSocket();){
            System.out.println(String.format("sending %s to %s:%d", snmpMessage.toString(), hostAddress.getHostAddress(), port));
            DatagramPacket outPacket = new DatagramPacket(outBytes, outBytes.length, hostAddress, port);
            datagramSocket.send(outPacket);
        }
    }
}

