 /*
  JNIOR Monitor/Configuration Page
  INTEG Process Group, Inc., 2919 E Hardies Rd, Gibsonia PA 
  724.933.9350
  
  File: panel.js
  
  The user is hereby granted license to use, modify, and redistribute the contents of this
  file for any purpose, commercial or otherwise. No prior authorization by INTEG Process 
  Group, Inc. is required.
*/ 

// Function returns HMTL for the Control Panel
function device_FA(key) {
	var id = module_keyToId[key];

	var modkey = "externals/" + id.toLowerCase() + "/";
	var desc_key = modkey + "desc";
	var desc = getkey(desc_key, "Control Panel");
	
	var inner = "<td name='panel'>";
	inner += "<p class='modname'><span name='" + keystd(desc_key) + "'>" + desc + "</span></p>";
	inner += "<p class='modaddr'>" + id + "</p>";
	inner += "<div class='modio'>";
	
	inner += "<table class='leds'><tr>";
	for (var n = 0; n < 12; n++) {
		var ch = 2 * n + 1;
		if (n >= 6)
			ch = 2 * (n - 5);
		
		if (n == 6) {
			inner += "</tr><tr>";
			for (var k = 0; k < 12; k++) {
				var led = 2 * k + 1;
				if (k >=6)
					led = 2 * (k - 5);
				
				if (k == 6)
					inner += "</tr><tr>";
					
				inner += "<td><img class='led' id='led:" + led + ":" + id + "' src='ledoff.png' width='13' height='13' /></td>"
			}
			inner += "</tr><tr>";
		}
		
		var chkey = modkey + "l" + ch + "desc";
		inner += "<td name='" + keystd(chkey) + "'>" + getkey(chkey, "L" + ch) + "</td>";
	}
	inner += "</tr></table>";


	inner += "</div>";
	inner += "</td>";
	return inner;
}

// Function updates Control Panel block content
function update_FA(key) {
	var id = module_keyToId[key];
	
	var raw = parseInt(module_idToStatus[id].substr(4, 4), 16);
	
	for (k = 0; k < 12; k++) {
		var led = 2 * k + 1;
		if (k >=6)
			led = 2 * (k - 5);

		var elem = document.getElementById("led:" + led + ":" + id);
		if (elem) {
			if ((raw & (1 << (led - 1))) != 0)
				elem.src = "ledon.png";
			else
				elem.src = "ledoff.png";
		}
	}
	
	return false;
}


