/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.debug;

import com.integpg.system.ArrayUtils;
import java.text.DecimalFormat;

public final class Stopwatch {
    private final String _name;
    private int _splitCount = 0;
    private long[] _splitTimes = null;
    private long[] _totalTimes = null;
    private String[] _comments = null;
    private long _startTime;
    private long _lastSplit;
    private long _totalDuration;

    public Stopwatch(String name) {
        this(name, 16);
    }

    public Stopwatch(String name, int capacity) {
        this._name = name;
        System.out.println("initializing " + name + " stopwatch with capacity of " + capacity);
        this._splitTimes = new long[capacity];
        this._totalTimes = new long[capacity];
        this._comments = new String[capacity];
        this.start();
    }

    public void start() {
        this._totalDuration = 0L;
        this._splitCount = 0;
        this._lastSplit = this._startTime = System.currentTimeMillis();
    }

    public void updateSplit() {
        this._lastSplit = System.currentTimeMillis();
    }

    public long split() {
        return this.split("");
    }

    public long split(String comment) {
        long now = System.currentTimeMillis();
        long splitElapsed = now - this._lastSplit;
        long totalElapsed = now - this._startTime;
        if (this._splitTimes.length == this._splitCount) {
            System.out.println("grow stopwatch split times");
            long[] splitTimes = new long[this._splitTimes.length * 2];
            ArrayUtils.arraycopy((Object)this._splitTimes, (int)0, (Object)splitTimes, (int)0, (int)this._splitTimes.length);
            this._splitTimes = splitTimes;
        }
        this._splitTimes[this._splitCount] = splitElapsed;
        this._lastSplit = now;
        if (this._totalTimes.length == this._splitCount) {
            System.out.println("grow stopwatch total times");
            long[] totalTimes = new long[this._totalTimes.length * 2];
            ArrayUtils.arraycopy((Object)this._totalTimes, (int)0, (Object)totalTimes, (int)0, (int)this._totalTimes.length);
            this._totalTimes = totalTimes;
        }
        this._totalTimes[this._splitCount] = totalElapsed;
        if (this._comments.length == this._splitCount) {
            System.out.println("grow stopwatch comments");
            String[] comments = new String[this._comments.length * 2];
            ArrayUtils.arraycopy((Object)this._comments, (int)0, (Object)comments, (int)0, (int)this._comments.length);
            this._comments = comments;
        }
        this._comments[this._splitCount++] = comment;
        return splitElapsed;
    }

    public void stop() {
        this._totalDuration = System.currentTimeMillis() - this._startTime;
    }

    public long getTotalDuration() {
        return this._totalDuration;
    }

    public String toString() {
        if (0L == this._totalDuration) {
            this.stop();
        }
        DecimalFormat df = new DecimalFormat("0.000");
        StringBuilder sb = new StringBuilder("stopwatch: " + this._name);
        for (int splitIndex = 0; splitIndex < this._splitCount; ++splitIndex) {
            long splitTime = this._splitTimes[splitIndex];
            long totalTime = this._totalTimes[splitIndex];
            String comment = this._comments[splitIndex];
            sb.append("\r\n  split ");
            sb.append(splitIndex + 1);
            sb.append(": ");
            sb.append(df.format((double)splitTime / 1000.0));
            sb.append("   ");
            sb.append(df.format((double)totalTime / 1000.0));
            sb.append("   ");
            sb.append(comment);
        }
        sb.append("\r\n total duration: " + df.format((double)this._totalDuration / 1000.0));
        return sb.toString();
    }
}

