/*
 * Decompiled with CFR 0.152.
 */
package JniorProtocol;

import JniorProtocol.Encoding.Base64;
import JniorProtocol.Exceptions.CommandTimeoutException;
import JniorProtocol.Exceptions.NotYetConnectedException;
import JniorProtocol.Helpers.Boolean2;
import JniorProtocol.JniorSession;
import JniorProtocol.Listeners.LoginListener;
import JniorProtocol.Properties.LoginProperties;
import JniorProtocol.ProtocolMessage;
import JniorProtocol.Registry.Registry;
import JniorProtocol.Registry.RegistryKey;
import JniorProtocol.Registry.RegistryRequest;
import JniorProtocol.Version;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.EventObject;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class Login
extends ProtocolMessage {
    public static final int ADMIN = 128;
    public static final int USER = 64;
    public static final int GUEST = 0;
    public static final int NOT_LOGGED_IN = -1;
    public static final int SEND_LOGIN = 126;
    public static final int RECV_LOGIN = 125;
    private LoginProperties m_loginProperties = null;
    protected Vector m_listeners = new Vector();

    public Login(JniorSession jniorSession) {
        super(jniorSession);
    }

    public void addLoginListener(LoginListener loginListener) {
        if (loginListener == null) {
            return;
        }
        for (int i = 0; i < this.m_listeners.size(); ++i) {
            if (!((LoginListener)this.m_listeners.elementAt(i)).equals(loginListener)) continue;
            return;
        }
        this.m_listeners.add(loginListener);
    }

    public void setLoginProperties(LoginProperties loginProperties) {
        this.m_loginProperties = loginProperties;
    }

    public LoginProperties getLoginProperties() {
        return this.m_loginProperties;
    }

    public void login(LoginProperties loginProperties) throws NotYetConnectedException {
        Object object;
        this.m_loginProperties = loginProperties;
        String string = loginProperties.getUsername();
        String string2 = loginProperties.getPassword();
        try {
            object = this.m_session.getRegistryInstance().getRegKey("$Model");
            this.m_session.getRegistryInstance().readRegistry((RegistryKey)object);
            if (((RegistryKey)object).getValue().contains("410")) {
                RegistryKey registryKey = this.m_session.getRegistryInstance().getRegKey("$Version");
                if (this.m_session.getInternalsInstance().m_osVersion != null) {
                    registryKey.setValue(this.m_session.getInternalsInstance().m_osVersion.toString());
                }
                if (this.m_session.getInternalsInstance().m_osVersion == null) {
                    this.m_session.getRegistryInstance().readRegistry(registryKey);
                }
                Version version = new Version(registryKey.getValue());
                System.out.println("version " + version);
                if (version.compareTo(new Version("0.9.3")) < 0) {
                    loginProperties.setUseEncoding(false);
                }
            }
        }
        catch (CommandTimeoutException commandTimeoutException) {
            Logger.getLogger(Login.class.getName()).log(Level.SEVERE, null, commandTimeoutException);
        }
        if (loginProperties.getUseEncoding()) {
            string2 = Base64.base64Encode(string + ":" + string2);
            string = "";
        }
        object = new byte[string.length() + string2.length() + 3];
        int n = 0;
        object[n++] = 126;
        object = Login.setString((byte[])object, n, string);
        object = Login.setString((byte[])object, n += string.length() + 1, string2);
        n += string2.length() + 1;
        try {
            this.send((byte[])object);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (this.m_listeners != null) {
            int n2 = 0;
            while (n2 < this.m_listeners.size()) {
                final int n3 = n2++;
                new Thread(new Runnable(){

                    public void run() {
                        ((LoginListener)Login.this.m_listeners.get(n3)).onLoginSent(new EventObject(Login.this.m_session), Login.this.m_loginProperties);
                    }
                }).start();
            }
        }
    }

    public int getAnonymousStatus() throws CommandTimeoutException, NotYetConnectedException {
        Registry registry = this.m_session.getRegistryInstance();
        int n = -1;
        try {
            RegistryRequest registryRequest = new RegistryRequest();
            RegistryKey registryKey = registry.getRegKey("JniorServer/Login");
            registryRequest.addKey(registryKey);
            RegistryKey registryKey2 = registry.getRegKey("JniorServer/Anonymous");
            registryRequest.addKey(registryKey2);
            registry.readRegistry(registryRequest, false, true);
            if (!Boolean2.getBoolean(registryKey.getValue())) {
                return 128;
            }
            if (!registryKey2.getValue().equals("")) {
                n = Integer.parseInt(registryKey2.getValue());
            }
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
        }
        return n;
    }

    public void receive(ByteArrayInputStream byteArrayInputStream, int n) {
        try {
            switch (n) {
                case 125: {
                    int n2 = Login.get(byteArrayInputStream);
                    if (n2 != -1) {
                        n2 = Math.abs(n2);
                    }
                    this.m_loginProperties.setLoginLevel(n2);
                    if (this.m_listeners == null) break;
                    int n3 = 0;
                    while (n3 < this.m_listeners.size()) {
                        final int n4 = n3++;
                        new Thread(new Runnable(){

                            public void run() {
                                if (Login.this.m_loginProperties.getLoginLevel() != -1) {
                                    ((LoginListener)Login.this.m_listeners.elementAt(n4)).onLoginSuccess(new EventObject(Login.this.m_session), Login.this.m_loginProperties);
                                } else {
                                    ((LoginListener)Login.this.m_listeners.elementAt(n4)).onLoginFailed(new EventObject(Login.this.m_session), Login.this.m_loginProperties);
                                }
                            }
                        }).start();
                    }
                    break;
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

