/*
 * Decompiled with CFR 0.152.
 */
package JniorProtocol.Devices.Externals;

import JniorProtocol.Devices.Externals.ExternalAnalog;
import JniorProtocol.JniorSession;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class ExternalTypeFE
extends ExternalAnalog {
    public static final int RAW = 0;
    public static final int MILLIAMPS = 1;
    public static final int PERCENTAGE = 2;

    public ExternalTypeFE(JniorSession jniorSession, long l) {
        super(jniorSession, l);
        this.m_description = "4-20ma Analog Module";
        this.m_in = new double[4];
        this.m_out = new double[2];
        this.m_newOut = new double[2];
        this.m_unit = new String[]{"", "", "", "", "", ""};
        this.m_min = new int[]{0, 0, 0, 0, 0, 0};
        this.m_max = new int[]{65520, 65520, 65520, 65520, 65520, 65520};
    }

    public void setScale(int n, int n2) {
        if (n < 0 || n > 4) {
            throw new IllegalArgumentException("Channel Out of Range.");
        }
        switch (n2) {
            case 0: {
                this.m_min[n - 1] = 0;
                this.m_max[n - 1] = 65520;
                break;
            }
            case 1: {
                this.m_min[n - 1] = 4;
                this.m_max[n - 1] = 20;
            }
            case 2: {
                this.m_min[n - 1] = 0;
                this.m_max[n - 1] = 100;
                break;
            }
            default: {
                throw new IllegalArgumentException("Scale Not Known");
            }
        }
    }

    public double getIn(int n) {
        if (n < 1 || n > 4) {
            throw new IllegalArgumentException("Channel Out of Range.");
        }
        double d = this.m_in[--n];
        double d2 = this.m_in[n] / 65520.0;
        d = (double)(this.m_max[n] - this.m_min[n]) * d2 + (double)this.m_min[n];
        return d;
    }

    public double getOut(int n) {
        if (n < 1 || n > 2) {
            throw new IllegalArgumentException("Channel Out of Range.");
        }
        double d = this.m_out[--n];
        double d2 = this.m_out[n] / 65520.0;
        d = (double)(this.m_max[n + 4] - this.m_min[n + 4]) * d2 + (double)this.m_min[n + 4];
        return d;
    }

    public void setOut(int n, int n2) {
        this.setOut(n, (double)n2);
    }

    public void setOut(int n, double d) {
        if (n < 1 || n > 2) {
            throw new IllegalArgumentException("Channel Out of Range.");
        }
        if (d < 0.0 || d > 100.0) {
            throw new IllegalArgumentException("Value Out of Range.");
        }
        this.m_newOut[--n] = 65520.0 * d / 100.0;
    }

    public byte[] getWriteBytes() {
        byte[] byArray = new byte[4];
        ExternalTypeFE.setShort(byArray, 0, (short)this.m_newOut[0]);
        ExternalTypeFE.setShort(byArray, 2, (short)this.m_newOut[1]);
        return byArray;
    }

    public void receive(ByteArrayInputStream byteArrayInputStream) {
        try {
            this.m_in[0] = ExternalTypeFE.getShort(byteArrayInputStream);
            this.m_in[1] = ExternalTypeFE.getShort(byteArrayInputStream);
            this.m_in[2] = ExternalTypeFE.getShort(byteArrayInputStream);
            this.m_in[3] = ExternalTypeFE.getShort(byteArrayInputStream);
            this.m_newOut[0] = this.m_out[0] = (double)ExternalTypeFE.getShort(byteArrayInputStream);
            this.m_newOut[1] = this.m_out[1] = (double)ExternalTypeFE.getShort(byteArrayInputStream);
            this.fireStateChange();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public String toString() {
        int n;
        String string = this.m_hexAddress + " : " + this.m_description + " : ";
        for (n = 0; n < 4; ++n) {
            if (n > 0) {
                string = string + ", ";
            }
            string = string + this.getIn(n + 1) + this.m_unit[n];
        }
        for (n = 0; n < 2; ++n) {
            string = string + ", ";
            string = string + this.getOut(n + 1) + this.m_unit[n + 4];
        }
        return string;
    }
}

