/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.snmp.objects;

import com.integpg.snmp.objects.SNMPCodec;
import com.integpg.snmp.objects.SNMPObject;
import com.integpg.snmp.objects.exceptions.SNMPBadValueException;
import com.integpg.system.ArrayUtils;
import java.io.IOException;

public class SNMPObjectIdentifier
extends SNMPObject
implements Comparable {
    private long[] _digits;
    private byte[] _bytes;
    private String _cache;

    public SNMPObjectIdentifier() {
    }

    public SNMPObjectIdentifier(String value) {
        this._bytes = value.getBytes();
        try {
            this.convertDigitString(value);
        }
        catch (SNMPBadValueException ex) {
            ex.printStackTrace();
        }
        this._length = 1;
        for (int i = 2; i < this._digits.length; ++i) {
            int length = SNMPCodec.bytesNeededForValue(this._digits[i]);
            this._length += length;
        }
    }

    private void convertDigitString(String digitString) throws SNMPBadValueException {
        try {
            long[] returnDigits = new long[128];
            int arrayPos = 0;
            int lastPos = 0;
            int stringLength = digitString.length();
            while (-1 != lastPos && stringLength > lastPos) {
                Long l;
                int nextPos = digitString.indexOf(".", lastPos);
                if (-1 == nextPos) {
                    nextPos = stringLength;
                }
                if ((l = Long.valueOf(Long.parseLong(digitString.substring(lastPos, nextPos)))) < 0L) {
                    throw new SNMPBadValueException(" Object Identifier: bad string supplied to set value ");
                }
                returnDigits[arrayPos++] = l;
                lastPos = nextPos + 1;
            }
            this._digits = new long[arrayPos];
            ArrayUtils.arraycopy((Object)returnDigits, (int)0, (Object)this._digits, (int)0, (int)arrayPos);
        }
        catch (NumberFormatException e) {
            throw new SNMPBadValueException(" Object Identifier: bad string supplied for object identifier value ");
        }
    }

    @Override
    public int getTag() {
        return 6;
    }

    @Override
    public Object getValue() {
        return this._digits;
    }

    public long[] getDigits() {
        return this._digits;
    }

    @Override
    public void decodeBER(SNMPCodec codec) throws IOException {
        super.decodeBER(codec);
        this.getValue(codec);
    }

    private void getValue(SNMPCodec codec) throws IOException {
        this._bytes = new byte[this._length];
        codec.read(this._bytes);
        this.bytesToDigits();
    }

    private void bytesToDigits() {
        int bitTest = 128;
        int highBitMask = 127;
        int numInts = 0;
        for (int i = 0; i < this._bytes.length; ++i) {
            if ((this._bytes[i] & bitTest) != 0) continue;
            ++numInts;
        }
        if (numInts > 0) {
            this._digits = new long[numInts + 1];
            int currentByte = -1;
            long value = 0L;
            do {
                value = value * 128L + (long)(this._bytes[++currentByte] & highBitMask);
            } while ((this._bytes[currentByte] & bitTest) > 0);
            this._digits[0] = (long)Math.floor(value / 40L);
            this._digits[1] = value % 40L;
            for (int i = 2; i < numInts + 1; ++i) {
                value = 0L;
                do {
                    value = value * 128L + (long)(this._bytes[++currentByte] & highBitMask);
                } while ((this._bytes[currentByte] & bitTest) > 0);
                this._digits[i] = value;
            }
        } else {
            this._digits = new long[0];
        }
    }

    @Override
    public void encodeBER(SNMPCodec codec) throws IOException {
        super.encodeBER(codec);
        int numElements = this._digits.length;
        if (numElements >= 2) {
            codec.write((byte)(40L * this._digits[0] + this._digits[1]));
        } else if (numElements == 1) {
            codec.write((byte)(40L * this._digits[0]));
        }
        for (int i = 2; i < numElements; ++i) {
            this.encodeValue(codec, this._digits[i]);
        }
    }

    private void encodeValue(SNMPCodec codec, long v) throws IOException {
        int numBytes = 0;
        long temp = v;
        do {
            ++numBytes;
        } while ((temp = (long)Math.floor(temp / 128L)) > 0L);
        byte[] enc = new byte[numBytes];
        enc[numBytes - 1] = (byte)(v % 128L);
        v = (long)Math.floor(v / 128L);
        for (int i = numBytes - 2; i >= 0; --i) {
            enc[i] = (byte)(v % 128L + 128L);
            v = (long)Math.floor(v / 128L);
        }
        codec.write(enc);
    }

    public int compareTo(Object obj) {
        SNMPObjectIdentifier otherOid = (SNMPObjectIdentifier)obj;
        long[] compareToDigits = otherOid.getDigits();
        for (int i = 0; i < this._digits.length && i < compareToDigits.length; ++i) {
            if (this._digits[i] < compareToDigits[i]) {
                return -1;
            }
            if (this._digits[i] <= compareToDigits[i]) continue;
            return 1;
        }
        if (this._digits.length < compareToDigits.length) {
            return -1;
        }
        if (this._digits.length > compareToDigits.length) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        SNMPObjectIdentifier otherOid = (SNMPObjectIdentifier)obj;
        long[] compareToDigits = otherOid.getDigits();
        boolean areEqual = true;
        if (this._digits.length != compareToDigits.length) {
            areEqual = false;
        } else {
            for (int i = 0; i < this._digits.length; ++i) {
                if (this._digits[i] == compareToDigits[i]) continue;
                areEqual = false;
                break;
            }
        }
        return areEqual;
    }

    @Override
    public String toString() {
        if (this._cache == null) {
            StringBuffer valueStringBuffer = new StringBuffer();
            if (this._digits.length > 0) {
                valueStringBuffer.append(this._digits[0]);
                for (int i = 1; i < this._digits.length; ++i) {
                    valueStringBuffer.append(".");
                    valueStringBuffer.append(this._digits[i]);
                }
            }
            this._cache = valueStringBuffer.toString();
        }
        return this._cache;
    }
}

