/*
 * Decompiled with CFR 0.152.
 */
package com.integ.janoslib.externalmodules;

import com.integ.janoslib.externalmodules.DeviceInfo;
import com.integ.janoslib.externalmodules.EnvironSensor;
import com.integ.janoslib.externalmodules.FourTwentyModule;
import com.integ.janoslib.externalmodules.TempProbe;
import com.integ.janoslib.externalmodules.TenVoltModule;
import com.integ.janoslib.externalmodules.UnknownDevice;
import com.integpg.system.JANOS;
import java.util.Enumeration;
import java.util.Hashtable;

public class ExternalDeviceMap {
    private static final Hashtable<String, DeviceInfo> DEVICE_MAP_BY_ADDRESS = new Hashtable();
    private static Thread THREAD = null;
    private static boolean Initialized = false;
    private static boolean Initializing = false;

    private ExternalDeviceMap() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Enumeration<DeviceInfo> elements() {
        Hashtable<String, DeviceInfo> hashtable = DEVICE_MAP_BY_ADDRESS;
        synchronized (hashtable) {
            return DEVICE_MAP_BY_ADDRESS.elements();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DeviceInfo getByType(String deviceTypeString) {
        if (!Initialized) {
            Hashtable<String, DeviceInfo> hashtable = DEVICE_MAP_BY_ADDRESS;
            synchronized (hashtable) {
                if (!Initializing) {
                    ExternalDeviceMap.update();
                } else {
                    try {
                        if (!Initialized) {
                            DEVICE_MAP_BY_ADDRESS.wait(1000L);
                        }
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                }
            }
        }
        String deviceTypeAddressKey = String.format("externals/deviceorder/%s", deviceTypeString);
        String deviceAddressString = JANOS.getRegistryString((String)deviceTypeAddressKey, (String)"").toUpperCase();
        Hashtable<String, DeviceInfo> hashtable = DEVICE_MAP_BY_ADDRESS;
        synchronized (hashtable) {
            return DEVICE_MAP_BY_ADDRESS.get(deviceAddressString);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update() {
        String[] deviceTypes;
        Initializing = true;
        String presentDevicesString = JANOS.getRegistryString((String)"externals/$present", (String)"");
        for (String deviceType : deviceTypes = JANOS.getRegistryList((String)"externals/deviceorder")) {
            String deviceTypeAddressKey = String.format("externals/deviceorder/%s", deviceType);
            String deviceAddressString = JANOS.getRegistryString((String)deviceTypeAddressKey, (String)"").toUpperCase();
            boolean devicePresent = -1 != presentDevicesString.indexOf(deviceAddressString);
            System.out.printf("%s = %s %s\n", new Object[]{deviceType, deviceAddressString, devicePresent ? "present" : "not present"});
            int len = deviceAddressString.length();
            long deviceAddress = Long.parseLong(deviceAddressString.substring(0, len - 8), 16);
            deviceAddress <<= 32;
            deviceAddress += Long.parseLong(deviceAddressString.substring(len - 8), 16);
            DeviceInfo device = null;
            Hashtable<String, DeviceInfo> hashtable = DEVICE_MAP_BY_ADDRESS;
            synchronized (hashtable) {
                if (devicePresent) {
                    if (!DEVICE_MAP_BY_ADDRESS.containsKey(deviceAddressString)) {
                        int typeIndex = Integer.parseInt(deviceType.substring(deviceType.indexOf("_") + 1));
                        int type = (int)(deviceAddress & 0xFFL);
                        device = 16 == type | 40 == type ? new TempProbe(deviceAddress, typeIndex) : (126 == type ? new EnvironSensor(deviceAddress, typeIndex) : (253 == type ? new TenVoltModule(deviceAddress, typeIndex) : (254 == type ? new FourTwentyModule(deviceAddress, typeIndex) : new UnknownDevice(deviceAddress, typeIndex))));
                        device.setSignificantDecimalPlaces(2);
                        System.out.println(String.format("add %s as %s", device.DeviceAddressString, device.getClass().getName()));
                    } else {
                        device = DEVICE_MAP_BY_ADDRESS.get(deviceAddressString);
                        if (!device.isPresent()) {
                            System.out.println(String.format("reactivate %s", device.DeviceAddressString));
                            device.setPresent(true);
                        }
                    }
                    DEVICE_MAP_BY_ADDRESS.put(deviceAddressString, device);
                }
            }
        }
        if (!Initialized) {
            Hashtable<String, DeviceInfo> hashtable = DEVICE_MAP_BY_ADDRESS;
            synchronized (hashtable) {
                DEVICE_MAP_BY_ADDRESS.notifyAll();
            }
            Initialized = true;
        }
    }

    public static void start() {
        if (null == THREAD) {
            THREAD = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                ExternalDeviceMap.update();
                                Thread.sleep(10000L);
                            }
                        }
                        catch (InterruptedException ex) {
                            ex.printStackTrace(System.err);
                            continue;
                        }
                        break;
                    }
                }
            });
            THREAD.setName(ExternalDeviceMap.class.getName());
            THREAD.setDaemon(true);
            THREAD.start();
        }
    }
}

