/*
 * Decompiled with CFR 0.152.
 */
package JniorProtocol;

import JniorProtocol.Encoding.CRC16;
import JniorProtocol.Exceptions.CommandTimeoutException;
import JniorProtocol.Exceptions.NotYetConnectedException;
import JniorProtocol.Helpers.Debug.Debug;
import JniorProtocol.Helpers.Packet;
import JniorProtocol.JniorSession;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.EventObject;

public abstract class ProtocolMessage {
    public static final int COMMAND_TIMEOUT = 2000;
    private ByteBuffer m_buf = ByteBuffer.allocateDirect(65535);
    protected long m_commandSentTime;
    protected JniorSession m_session;

    public ProtocolMessage(JniorSession jniorSession) {
        this.m_session = jniorSession;
    }

    protected static String getString(InputStream inputStream) throws IOException {
        byte[] byArray = null;
        int n = inputStream.read();
        if (n == -1) {
            return null;
        }
        byArray = new byte[n];
        inputStream.read(byArray);
        return new String(byArray);
    }

    public static final int get(InputStream inputStream) throws IOException {
        int n = inputStream.read() & 0xFF;
        if (n < 0) {
            throw new EOFException();
        }
        return n;
    }

    public static final int getShort(InputStream inputStream) throws IOException {
        int n;
        int n2 = inputStream.read() & 0xFF;
        if ((n2 | (n = inputStream.read() & 0xFF)) < 0) {
            throw new EOFException();
        }
        return (n2 << 8) + (n << 0);
    }

    public static final long getInt(InputStream inputStream) throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = inputStream.read();
        if ((n4 | (n3 = inputStream.read()) | (n2 = inputStream.read()) | (n = inputStream.read())) < 0) {
            throw new EOFException();
        }
        return ((long)n4 << 24) + (long)(n3 << 16) + (long)(n2 << 8) + (long)(n << 0);
    }

    public static final long getLong(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        int n2 = inputStream.read();
        int n3 = inputStream.read();
        int n4 = inputStream.read();
        int n5 = inputStream.read();
        int n6 = inputStream.read();
        int n7 = inputStream.read();
        int n8 = inputStream.read();
        return ((long)n << 56) + ((long)n2 << 48) + ((long)n3 << 40) + ((long)n4 << 32) + ((long)n5 << 24) + (long)(n6 << 16) + (long)(n7 << 8) + (long)(n8 << 0);
    }

    public static final double getDouble(InputStream inputStream) throws IOException {
        return Double.longBitsToDouble(ProtocolMessage.getLong(inputStream));
    }

    protected static byte[] setShort(byte[] byArray, int n, short s) {
        byArray[n++] = (byte)(s >> 8 & 0xFF);
        byArray[n] = (byte)(s & 0xFF);
        return byArray;
    }

    protected static byte[] setInt(byte[] byArray, int n, int n2) {
        byArray[n++] = (byte)(n2 >> 24 & 0xFF);
        byArray[n++] = (byte)(n2 >> 16 & 0xFF);
        byArray[n++] = (byte)(n2 >> 8 & 0xFF);
        byArray[n] = (byte)(n2 & 0xFF);
        return byArray;
    }

    protected static byte[] setLong(byte[] byArray, int n, long l) {
        byArray[n++] = (byte)(l >> 56 & 0xFFL);
        byArray[n++] = (byte)(l >> 48 & 0xFFL);
        byArray[n++] = (byte)(l >> 40 & 0xFFL);
        byArray[n++] = (byte)(l >> 32 & 0xFFL);
        byArray[n++] = (byte)(l >> 24 & 0xFFL);
        byArray[n++] = (byte)(l >> 16 & 0xFFL);
        byArray[n++] = (byte)(l >> 8 & 0xFFL);
        byArray[n] = (byte)(l & 0xFFL);
        return byArray;
    }

    protected static byte[] setString(byte[] byArray, int n, String string) {
        if (string == null) {
            string = "";
        }
        byArray[n++] = (byte)string.length();
        try {
            System.arraycopy(string.getBytes(), 0, byArray, n, string.length());
            return byArray;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static byte[] sendString(String string) {
        int n = string.length();
        byte[] byArray = new byte[n + 1];
        byArray[0] = (byte)n;
        System.arraycopy(string.getBytes(), 0, byArray, 1, n);
        return byArray;
    }

    protected void send(byte[] byArray) throws IOException, NotYetConnectedException {
        this.send(byArray, 0, byArray.length);
    }

    protected void send(byte[] byArray, boolean bl) throws IOException, NotYetConnectedException {
        this.send(byArray, 0, byArray.length, bl);
    }

    protected void send(byte[] byArray, int n, int n2) throws IOException, NotYetConnectedException {
        this.send(byArray, n, n2, true);
    }

    protected void send(byte[] byArray, int n, int n2, boolean bl) throws IOException, NotYetConnectedException {
        byte[] byArray2;
        if (!this.m_session.isConnected()) {
            throw new NotYetConnectedException();
        }
        if (bl) {
            byArray2 = new byte[n2 + 5];
            byArray2[0] = 1;
            byArray2 = ProtocolMessage.setShort(byArray2, 1, (short)n2);
            byArray2 = ProtocolMessage.setShort(byArray2, 3, (short)CRC16.crc16(byArray, 0, n2));
            System.arraycopy(byArray, n, byArray2, 5, n2);
        } else {
            byArray2 = new byte[n2];
            System.arraycopy(byArray, 0, byArray2, 0, n2);
        }
        Packet packet = new Packet(">");
        packet.time = System.currentTimeMillis();
        packet.bytes = byArray2;
        if (this.m_session.m_displayPackets) {
            this.m_session.messages.add(packet);
            Debug.log(packet);
        }
        if (this.m_session.packetListener != null) {
            this.m_session.packetListener.OnPacket(new EventObject(this), packet);
        }
        this.m_buf.clear();
        this.m_buf.put(byArray2);
        try {
            this.m_buf.flip();
            int n3 = this.m_session.m_socketChannel.write(this.m_buf);
            ++this.m_session.m_writes;
            this.m_session.m_totalBytesSent += (long)n3;
            this.m_session.fireProtocolWriteEvent();
            this.m_session.m_lastSent = this.m_commandSentTime = System.currentTimeMillis();
        }
        catch (Exception exception) {
            Debug.log("Exception when trying to send bytes.");
        }
    }

    protected boolean isCommandTimeout(long l) throws CommandTimeoutException {
        return this.isCommandTimeout(l, 2000);
    }

    protected boolean isCommandTimeout(long l, int n) throws CommandTimeoutException {
        if (System.currentTimeMillis() - l > (long)n) {
            throw new CommandTimeoutException();
        }
        return false;
    }

    public void receive(ByteArrayInputStream byteArrayInputStream) {
    }

    public void receive(ByteArrayInputStream byteArrayInputStream, int n) {
    }
}

