/*
 * Decompiled with CFR 0.152.
 */
package integpg.EmbeddedHelpers.Base;

import com.integpg.system.ArrayUtils;
import com.integpg.system.JANOS;
import integpg.EmbeddedHelpers.Base.ConfigBase;
import integpg.EmbeddedHelpers.Logging.LogEngine;
import integpg.EmbeddedHelpers.Time.QuickDateStamp;
import integpg.EmbeddedHelpers.Time.QuickTime;
import java.io.IOException;
import java.util.Date;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public abstract class EmbeddedBase {
    public static final byte[] CRLF = "\r\n".getBytes();
    protected static final byte[] INFO = new byte[60];
    protected static byte[] infoBytes = new byte[INFO.length];
    public static EmbeddedBase BASE;
    private static final long GC_RATE = 60000L;
    private static final String zones = "AST,PST,MST,CST,EST,CNT";
    private long m_nextGC;
    public ConfigBase m_config;
    public String fileName;
    public String name;
    public String version;
    public long appStartTime = QuickTime.getTimeMillis();
    private String appName;
    public boolean m_quitApp = false;
    public LogEngine m_appLog = null;
    public static final int JUSTIFY_LEFT = 0;
    public static final int JUSTIFY_CENTER = 1;
    public static final int JUSTIFY_RIGHT = 2;
    private static StringBuffer sb;
    private static StringBuffer chars;

    private EmbeddedBase() {
        this.checkTimeZones();
        QuickDateStamp.invalidate();
        BASE = this;
        this.m_appLog = new LogEngine();
        EmbeddedBase.INFO[0] = 91;
        EmbeddedBase.INFO[EmbeddedBase.INFO.length - 1] = 93;
        ArrayUtils.arrayFill((byte[])INFO, (int)1, (int)(INFO.length - 1), (byte)32);
    }

    public EmbeddedBase(String string, String string2) {
        this(string, string2, null);
    }

    public EmbeddedBase(String string, String string2, String string3) {
        this.checkTimeZones();
        QuickDateStamp.invalidate();
        BASE = this;
        this.name = string;
        this.fileName = string.toLowerCase().replace(' ', '_') + ".log";
        if (string3 != null && !string3.equals("")) {
            this.name = this.name + "_" + string3;
        }
        this.version = string2;
        this.m_appLog = new LogEngine();
        this.m_appLog.start();
        EmbeddedBase.INFO[0] = 91;
        EmbeddedBase.INFO[EmbeddedBase.INFO.length - 1] = 93;
        ArrayUtils.arrayFill((byte[])INFO, (int)1, (int)(INFO.length - 1), (byte)32);
        this.printInfo();
        this.printInfo();
        this.checkTimeZones();
        String string4 = string + " - v." + string2;
        this.printInfo(string4);
        this.printInfo(new Date(QuickTime.getTimeMillis()).toString());
        this.printInfo();
        string4 = string + " - v." + string2;
        JANOS.syslog((String)string4);
        this.appName = string.replace(' ', '_');
        JANOS.setRegistryString((String)("AppData/" + this.appName + "/Name"), (String)string);
        JANOS.setRegistryString((String)("AppData/" + this.appName + "/Version"), (String)string2);
        JANOS.setRegistryString((String)("AppData/" + this.appName + "/$Started"), (String)new Date(this.appStartTime).toString());
        JANOS.setRegistryString((String)("AppData/" + this.appName + "/$Quit"), (String)"false");
        JANOS.setRegistryString((String)("AppData/" + this.appName + "/$AppDone"), (String)"");
    }

    public void log(String string) {
        this.m_appLog.logEntry(this.fileName, string);
    }

    protected boolean isDuplicateInstance(String string) {
        String[] stringArray = JANOS.getTaskTable();
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].toLowerCase().indexOf(string) >= 0) {
                ++n;
            }
            if (n <= 1) continue;
            return true;
        }
        return false;
    }

    public void checkTimeZones() {
        if (zones.indexOf(JANOS.getTimeZone()) != -1) {
            TimeZone timeZone = TimeZone.getDefault();
            SimpleTimeZone simpleTimeZone = new SimpleTimeZone(timeZone.getRawOffset(), timeZone.getID(), 2, 8, -1, 0x6DDD00, 10, 1, -1, 0x6DDD00);
            TimeZone.setDefault(simpleTimeZone);
        }
    }

    public void stopApp() {
        try {
            this.printInfo("Stopping Application");
            this.m_quitApp = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            if (this.m_appLog != null) {
                this.printInfo("Stopping Application Log");
                this.m_appLog.stop();
                this.m_appLog = null;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.gc();
    }

    public void waitForUserInput() {
        System.out.println("Press 'q' to exit.");
        this.gc();
        long l = JANOS.uptimeMillis();
        Thread.currentThread().setName("Wait for user input");
        this.log("Wait for user input");
        do {
            try {
                if (System.in != null && System.in.available() > 0) {
                    int n = System.in.read();
                    if (n == 120) {
                        System.exit(0);
                    } else if (n == 113) {
                        this.stopApp();
                    } else if (n == 35) {
                        this.printActiveThreads();
                    } else {
                        this.onUserInput(n);
                    }
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.out);
                this.log("Stop waiting for user input.");
                System.out.println("Stop waiting for user input.");
                System.setIn(null);
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace(System.out);
            }
            if (JANOS.uptimeMillis() - l <= 10000L) continue;
            if (JANOS.getRegistryBoolean((String)("AppData/" + this.appName + "/$Quit"), (boolean)false)) {
                this.stopApp();
            }
            l = JANOS.uptimeMillis();
            EmbeddedBase.gc();
        } while (!this.m_quitApp);
        this.gc();
        JANOS.setRegistryString((String)("AppData/" + this.appName + "/$AppDone"), (String)"true");
    }

    public abstract void onUserInput(int var1);

    protected void printActiveThreads() {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        int n = threadGroup.activeCount();
        System.out.println("   Active Threads : " + n);
        Thread[] threadArray = new Thread[n * 2];
        n = threadGroup.enumerate(threadArray, false);
        for (int i = 0; i < n; ++i) {
            Thread thread = threadArray[i];
            System.out.println("   " + thread.toString() + ", " + threadArray[i].getClass().toString() + (thread.isDaemon() ? " - DAEMON" : ""));
        }
    }

    public String printInfo() {
        return this.printInfo("", 1);
    }

    public String printInfo(String string) {
        return this.printInfo(string, 1);
    }

    public synchronized String printInfo(String string, int n) {
        int n2 = INFO.length;
        int n3 = Math.min(string.length(), n2 - 2);
        int n4 = (int)((double)(n2 - n3) / 2.0);
        int n5 = n4 + n3;
        switch (n) {
            case 0: {
                n4 = 2;
                n5 = n4 + n3;
                break;
            }
            case 2: {
                n5 = n2 - 2;
                n4 = n5 - n3;
            }
        }
        try {
            ArrayUtils.arraycopy((Object)INFO, (int)0, (Object)infoBytes, (int)0, (int)n4);
            ArrayUtils.arraycopy((Object)string.getBytes(), (int)0, (Object)infoBytes, (int)n4, (int)(n5 - n4));
            ArrayUtils.arraycopy((Object)INFO, (int)n5, (Object)infoBytes, (int)n5, (int)(n2 - n5));
            System.out.write(infoBytes, 0, infoBytes.length);
            System.out.write(CRLF);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            if (this.m_appLog != null) {
                this.m_appLog.logEntry(this.fileName, new String(infoBytes), QuickTime.getTimeMillis());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return new String(infoBytes);
    }

    private String replace(String string, String string2, String string3) {
        if (string2.equals(string3)) {
            return string;
        }
        int n = string.indexOf(string2);
        if (n >= 0) {
            int n2 = n + string2.length();
            return string.substring(0, n) + string3 + string.substring(n2);
        }
        return string;
    }

    public static void gc() {
        if (JANOS.uptimeMillis() >= EmbeddedBase.BASE.m_nextGC) {
            System.gc();
            EmbeddedBase.BASE.m_nextGC = JANOS.uptimeMillis() + 60000L;
        }
    }

    public static boolean sleep(long l) {
        try {
            if (l < 0L) {
                l = 1L;
            }
            Thread.sleep(l);
            return true;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
    }

    public static void ExitException(String string) {
        System.err.println(EmbeddedBase.BASE.name + ": " + string);
        if (EmbeddedBase.BASE.m_appLog != null) {
            EmbeddedBase.BASE.m_appLog.logEntry(EmbeddedBase.BASE.fileName, string);
        }
        JANOS.syslog((String)(EmbeddedBase.BASE.name.toLowerCase().replace(' ', '_') + ": " + string));
        EmbeddedBase.BASE.m_quitApp = true;
        EmbeddedBase.gc();
        System.exit(-1);
    }

    public static String hexDump(byte[] byArray) {
        return EmbeddedBase.hexDump(byArray, 0, byArray.length);
    }

    public static synchronized String hexDump(byte[] byArray, int n, int n2) {
        int n3;
        int n4;
        sb.setLength(0);
        chars.setLength(0);
        for (n4 = 0; n4 < n2; ++n4) {
            if (n4 % 16 == 0) {
                if (chars.length() > 0) {
                    sb.append("  ");
                    sb.append(chars.toString());
                    chars = new StringBuffer();
                    sb.append("\r\n");
                }
            } else if (n4 % 16 == 8) {
                chars.append(" ");
                sb.append("  ");
            }
            if ((n3 = byArray[n4 + n]) >= 32) {
                chars.append((char)n3);
            } else {
                chars.append('.');
            }
            int n5 = sb.length();
            sb.append(Integer.toHexString((n3 & 0xFF) / 16));
            sb.append(Integer.toHexString((n3 & 0xFF) % 16));
            sb.append(" ");
        }
        n3 = n4 % 16;
        if (n3 != 0) {
            if (n3 <= 8) {
                sb.append("  ");
            }
            for (n4 = 16 - n3; n4 > 0; --n4) {
                sb.append("   ");
            }
            sb.append("  ");
            sb.append(chars.toString());
        }
        return sb.toString();
    }

    static {
        sb = new StringBuffer();
        chars = new StringBuffer();
    }
}

