/*
 * Decompiled with CFR 0.152.
 */
package com.integ.slaveservice;

import com.integ.slaveservice.LocalSlaveService;
import com.integpg.janoslib.io.AppLog;
import com.integpg.janoslib.logger.Logger;
import java.util.ArrayList;

public abstract class SlaveService
implements Runnable {
    protected Logger _log;
    protected Thread _monitorThread = null;
    protected int _followedInputMask = 0;
    protected int[] _inputs = new int[12];
    protected int _followedOutputMask = 0;
    protected int[] _outputs = new int[16];
    protected int _failedOutputMask = 0;
    protected String[] _failedOutputStrings = new String[16];
    protected int _usedOutputMask = 0;
    protected boolean _running = false;
    protected ArrayList<Rule> _rules = new ArrayList();

    public void addRule(int localIoType, int localIoChannel, int remoteIoType, int remoteIoChannel) {
        String localOrRemote = this instanceof LocalSlaveService ? "LOCAL" : "REMOTE";
        Rule rule = new Rule();
        rule.LocalIoType = localIoType;
        rule.LocalIoChannel = localIoChannel;
        rule.RemoteIoType = remoteIoType;
        rule.RemoteIoChannel = remoteIoChannel;
        this._rules.add(rule);
        String infoString = String.format("local %s %d follows %s %s %d", 0 == localIoType ? "INPUT" : "OUTPUT", localIoChannel, localOrRemote, 0 == remoteIoType ? "INPUT" : "OUTPUT", remoteIoChannel);
        AppLog.info(infoString);
        this._log.info(infoString);
        if (!this.isRunning()) {
            this.monitor();
        }
    }

    public void setFailedCommOutputState(int channel, String failedCommString) {
        System.out.println("set failed comm state for " + channel + " to " + failedCommString);
        if (!"hold-last-state".equals(failedCommString)) {
            this._failedOutputMask |= 1 << channel - 1;
            this._failedOutputStrings[channel - 1] = failedCommString;
        } else {
            this._failedOutputMask &= 0xFFFF ^ 1 << channel - 1;
        }
        System.out.println("_failedOutputMask: 0x" + Long.toHexString(this._failedOutputMask));
    }

    public boolean isRunning() {
        return this._running;
    }

    private void stop() {
        this._running = false;
    }

    protected void monitor() {
    }

    protected class Rule {
        static final int INPUT = 0;
        static final int OUTPUT = 1;
        int LocalIoType;
        int LocalIoChannel;
        int RemoteIoType;
        int RemoteIoChannel;

        protected Rule() {
        }
    }
}

