/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.TaskManager.externals;

import com.dalsemi.system.ArrayUtils;
import com.integpg.EmbeddedHelpers.Base.EmbeddedBase;
import java.io.IOException;
import java.util.Vector;

public abstract class ExternalModuleInfo {
    protected final String _addressString;
    protected final long _address;
    protected byte[] _deviceBlock;
    private byte[] _prevDeviceBlock = null;
    private boolean _hasDeviceChanged;
    public final Vector Listeners = new Vector();

    public ExternalModuleInfo(String addressString) {
        this._addressString = addressString;
        this._address = this.parseHex(addressString);
    }

    public void refreshDevice() throws IOException {
        this._deviceBlock = EmbeddedBase.BASE.m_jnioros.readDeviceBlock(this._address);
        this._hasDeviceChanged = false;
        if (null != this._prevDeviceBlock) {
            this._hasDeviceChanged = !ArrayUtils.arrayComp(this._deviceBlock, 0, this._prevDeviceBlock, 0, this._deviceBlock.length);
        }
        this._prevDeviceBlock = this._deviceBlock;
    }

    protected long parseHex(String s) {
        if (s == null || s.length() != 16) {
            return 0L;
        }
        long l = Long.parseLong(s.substring(0, 8), 16);
        l <<= 32;
        return l += Long.parseLong(s.substring(8), 16);
    }

    public String getAddressString() {
        return this._addressString;
    }

    public long getAddress() {
        return this._address;
    }

    public abstract double getValue(int var1, int var2);

    public boolean hasDeviceChanged() {
        return this._hasDeviceChanged;
    }
}

