/*
 * Decompiled with CFR 0.152.
 */
package JniorProtocol.Devices.Externals;

import JniorProtocol.Devices.Externals.ExternalAnalog;
import JniorProtocol.JniorSession;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class ExternalTypeFC
extends ExternalAnalog {
    public static final int CELSIUS = 0;
    public static final int FAHRENHEIT = 1;
    private int m_type = 0;

    public ExternalTypeFC(JniorSession jniorSession, long l) {
        super(jniorSession, l);
        this.m_description = "RTD Temperature Module";
        this.m_in = new double[4];
        this.m_unit = new String[]{"", "", "", "", "", ""};
    }

    public double getCelsius(int n) {
        return this.getIn(n);
    }

    public double getFahrenheit(int n) {
        return this.getIn(n) * 9.0 / 5.0 + 32.0;
    }

    public double getIn(int n, int n2) {
        double d = this.getIn(n);
        if (n2 == 1) {
            d = this.getFahrenheit(n);
        }
        return d;
    }

    public double getIn(int n) {
        if (n < 1 || n > 4) {
            throw new IllegalArgumentException("Channel Out of Range.");
        }
        return this.m_in[--n];
    }

    public void setGlobalType(int n) {
        this.m_type = n;
    }

    public void receive(ByteArrayInputStream byteArrayInputStream) {
        try {
            this.m_in[0] = (short)ExternalTypeFC.getShort(byteArrayInputStream);
            this.m_in[0] = this.m_in[0] != 32767.0 ? this.m_in[0] / 10.0 : 65535.0;
            this.m_in[1] = (short)ExternalTypeFC.getShort(byteArrayInputStream);
            this.m_in[1] = this.m_in[1] != 32767.0 ? this.m_in[1] / 10.0 : 65535.0;
            this.m_in[2] = (short)ExternalTypeFC.getShort(byteArrayInputStream);
            this.m_in[2] = this.m_in[2] != 32767.0 ? this.m_in[2] / 10.0 : 65535.0;
            this.m_in[3] = (short)ExternalTypeFC.getShort(byteArrayInputStream);
            this.m_in[3] = this.m_in[3] != 32767.0 ? this.m_in[3] / 10.0 : 65535.0;
            this.fireStateChange();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public String toString() {
        String string = this.m_hexAddress + " : " + this.m_description + " : ";
        for (int i = 0; i < 4; ++i) {
            if (i > 0) {
                string = string + ", ";
            }
            string = string + this.getIn(i + 1, this.m_type) + this.m_unit[i];
            if (this.m_type == 0) {
                string = string + " C";
                continue;
            }
            if (this.m_type != 1) continue;
            string = string + " F";
        }
        return string;
    }
}

