/*
 * Decompiled with CFR 0.152.
 */
package JniorProtocol;

import JniorProtocol.Devices.Device;
import JniorProtocol.Devices.Jr310InternalInput;
import JniorProtocol.Devices.Jr310InternalOutput;
import JniorProtocol.Devices.Jr310Internals;
import JniorProtocol.Encoding.CRC16;
import JniorProtocol.Exceptions.CommandTimeoutException;
import JniorProtocol.Exceptions.NotLoggedInException;
import JniorProtocol.Exceptions.NotYetConnectedException;
import JniorProtocol.Helpers.Debug.Debug;
import JniorProtocol.Helpers.Packet;
import JniorProtocol.Helpers.Version;
import JniorProtocol.JniorConnection;
import JniorProtocol.Listeners.ConnectionListener;
import JniorProtocol.Listeners.EnumerationListener;
import JniorProtocol.Listeners.LoginListener;
import JniorProtocol.Listeners.PacketListener;
import JniorProtocol.Listeners.ProtocolListener;
import JniorProtocol.Login;
import JniorProtocol.Properties.LoginProperties;
import JniorProtocol.ProtocolMessage;
import JniorProtocol.Registry.Registry;
import JniorProtocol.Registry.RegistryKey;
import JniorProtocol.Registry.RegistryRequest;
import JniorProtocol.Request;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Date;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JniorSession
extends JniorConnection
implements Runnable,
ConnectionListener,
LoginListener {
    private static final String VERSION = "4.8.811.935";
    private static boolean DEBUG = false;
    public Vector messages = new Vector();
    private String m_name = null;
    private Hashtable m_messageHashtable = new Hashtable();
    private Heartbeat heartbeat = null;
    private Login m_login = null;
    private int m_loginLevel = -1;
    private Device m_device = null;
    private Jr310Internals m_internals = null;
    private Registry m_registry = null;
    private Hashtable m_devices = new Hashtable();
    private Request m_request = null;
    private Vector m_protocolListeners = new Vector();
    public PacketListener packetListener = null;
    public long m_lastKnownJniorTime;
    public int m_reads = 0;
    public long m_totalBytesRead = 0L;
    public long m_lastSent = 0L;
    public int m_writes = 0;
    public long m_totalBytesSent = 0L;
    public boolean m_displayPackets = false;
    int _bytesRead = 0;
    private Thread _packetThread = null;

    public JniorSession() {
        this.initSession("");
    }

    public void setDisplayPackets(boolean bl) {
        this.m_displayPackets = bl;
    }

    public void setSocketChannel(SocketChannel socketChannel) {
        super.setSocketChannel(socketChannel);
        this.initSession("");
        this.m_loginLevel = 128;
    }

    private void initSession(String string) {
        this.m_name = string;
        this.heartbeat = new Heartbeat(this);
        this.m_login = new AbstractLogin(this);
        this.m_device = new AbstractDevice(this);
        this.m_internals = new AbstractInternals(this);
        this.m_registry = new Registry(this);
        this.m_request = new Request(this);
        this.m_messageHashtable.put(new Integer(1), this.m_internals);
        this.m_messageHashtable.put(new Integer(2), this.m_internals);
        this.m_messageHashtable.put(new Integer(6), this.m_request);
        this.m_messageHashtable.put(new Integer(12), this.m_registry);
        this.m_messageHashtable.put(new Integer(14), this.m_registry);
        this.m_messageHashtable.put(new Integer(17), this.m_registry);
        this.m_messageHashtable.put(new Integer(22), this.m_device);
        this.m_messageHashtable.put(new Integer(24), this.m_device);
        this.m_messageHashtable.put(new Integer(27), this.m_device);
        this.m_messageHashtable.put(new Integer(125), this.m_login);
        this.addConnectionListener(this);
    }

    public void attachMessageHandler(int n, ProtocolMessage protocolMessage) {
        if (!this.m_messageHashtable.containsKey(new Integer(n))) {
            this.m_messageHashtable.put(new Integer(n), protocolMessage);
        }
    }

    public static String getVersion() {
        return VERSION;
    }

    public void setDebugging(boolean bl) {
        DEBUG = bl;
    }

    public void addProtocolListener(ProtocolListener protocolListener) {
        if (protocolListener == null) {
            return;
        }
        for (int i = 0; i < this.m_protocolListeners.size(); ++i) {
            if (!((ProtocolListener)this.m_protocolListeners.elementAt(i)).equals(protocolListener)) continue;
            return;
        }
        this.m_protocolListeners.add(protocolListener);
    }

    public void setPacketListener(PacketListener packetListener) {
        this.packetListener = packetListener;
    }

    public Version getOsVersion() {
        Version version = this.getInternalsInstance().m_osVersion;
        if (version == null) {
            RegistryKey registryKey = this.getRegistryInstance().getRegKey("$Version", "");
            if (registryKey.getValue().equals("")) {
                try {
                    version = new Version(this.m_registry.readRegistry(registryKey));
                }
                catch (CommandTimeoutException commandTimeoutException) {
                    commandTimeoutException.printStackTrace();
                }
                catch (NotYetConnectedException notYetConnectedException) {
                    notYetConnectedException.printStackTrace();
                }
            } else {
                version = new Version(registryKey.getValue());
            }
        }
        return version;
    }

    public String getSerialNumber() {
        String string = null;
        RegistryKey registryKey = this.getRegistryInstance().getRegKey("$SerialNumber", "");
        if (registryKey.getValue().equals("")) {
            try {
                string = this.m_registry.readRegistry(registryKey);
            }
            catch (CommandTimeoutException commandTimeoutException) {
                commandTimeoutException.printStackTrace();
            }
            catch (NotYetConnectedException notYetConnectedException) {
                notYetConnectedException.printStackTrace();
            }
        } else {
            string = registryKey.getValue();
        }
        return string;
    }

    public String getName() {
        if (this.m_name == null) {
            return this.getSerialNumber();
        }
        return this.m_name;
    }

    public Jr310Internals getInternalsInstance() {
        return this.m_internals;
    }

    public Device getExternalsInstance() {
        return this.m_device;
    }

    public void addEnumerationListener(EnumerationListener enumerationListener) {
        this.m_device.addEnumerationListener(enumerationListener);
    }

    public Device[] enumerate() throws CommandTimeoutException, NotYetConnectedException, NotLoggedInException {
        return this.enumerate(3);
    }

    public Device[] enumerate(int n) throws CommandTimeoutException, NotYetConnectedException, NotLoggedInException {
        return this.m_device.enumerate(n);
    }

    public Registry getRegistryInstance() {
        return this.m_registry;
    }

    public boolean isLoggedIn() throws NotYetConnectedException, NotLoggedInException {
        if (!this.isConnected()) {
            throw new NotYetConnectedException();
        }
        return this.m_loginLevel != -1 && this.m_loginLevel != Integer.MIN_VALUE;
    }

    public int getAnonymousStatus() throws CommandTimeoutException, NotYetConnectedException {
        return this.m_login.getAnonymousStatus();
    }

    public int login(LoginProperties loginProperties) throws NotYetConnectedException {
        return this.login(loginProperties, null);
    }

    public int login(LoginProperties loginProperties, LoginListener loginListener) throws NotYetConnectedException {
        this.m_loginLevel = Integer.MIN_VALUE;
        try {
            this.m_login.addLoginListener(this);
            this.m_login.addLoginListener(loginListener);
            this.m_login.login(loginProperties);
            if (loginListener == null || loginListener == this) {
                while (this.m_loginLevel == Integer.MIN_VALUE) {
                    Thread.sleep(250L);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        return this.m_loginLevel;
    }

    public void setLoginProperties(LoginProperties loginProperties) {
        this.m_login.setLoginProperties(loginProperties);
    }

    public LoginProperties getLoginProperties() {
        return this.m_login.getLoginProperties();
    }

    public void setUnsolicitedMessages(boolean bl) throws NotYetConnectedException, NotLoggedInException {
        this.isLoggedIn();
        this.m_internals.setEnableMonitorPackets(bl);
    }

    public void reboot() throws NotYetConnectedException, NotLoggedInException {
        this.isLoggedIn();
        this.m_request.buildRequestPacket(3);
    }

    public Jr310InternalInput getInput(int n) {
        return this.m_internals.getInput(n);
    }

    public Jr310InternalOutput getOutput(int n) {
        return this.m_internals.getOutput(n);
    }

    public Hashtable getDevices() {
        return this.m_devices;
    }

    public Request getRequestInstance() {
        return this.m_request;
    }

    public void fireProtocolReadEvent() {
        if (DEBUG) {
            Debug.log("Reads: " + this.m_reads + " Total Bytes Read: " + this.m_totalBytesRead);
        }
        int n = 0;
        while (n < this.m_protocolListeners.size()) {
            final int n2 = n++;
            new Thread(new Runnable(){

                public void run() {
                    ((ProtocolListener)JniorSession.this.m_protocolListeners.elementAt(n2)).onBytesRead(new EventObject(JniorSession.this), JniorSession.this.m_reads, JniorSession.this.m_totalBytesRead);
                }
            }).start();
        }
    }

    public void fireProtocolWriteEvent() {
        if (DEBUG) {
            Debug.log("Write: " + this.m_writes + " Total Bytes Written: " + this.m_totalBytesSent);
        }
        int n = 0;
        while (n < this.m_protocolListeners.size()) {
            final int n2 = n++;
            new Thread(new Runnable(){

                public void run() {
                    ((ProtocolListener)JniorSession.this.m_protocolListeners.elementAt(n2)).onBytesSent(new EventObject(JniorSession.this), JniorSession.this.m_writes, JniorSession.this.m_totalBytesSent);
                }
            }).start();
        }
    }

    private boolean readPacket(ByteBuffer byteBuffer, int n, int n2) {
        boolean bl = true;
        int n3 = n2 - n;
        Packet packet = null;
        if (n3 > 5) {
            byteBuffer.position(n);
            byteBuffer.mark();
            byte by = byteBuffer.get();
            packet = null;
            if (by == 1) {
                short s = byteBuffer.getShort();
                short s2 = byteBuffer.getShort();
                int n4 = n2 - byteBuffer.position();
                if (n4 < s) {
                    Debug.log("Packet payload not fully read");
                    byteBuffer.reset();
                    return true;
                }
                final byte[] byArray = new byte[s];
                try {
                    byteBuffer.get(byArray);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                short s3 = (short)CRC16.crc16(byArray, 0, s);
                if (s2 == s3) {
                    packet = new Packet("<");
                    packet.time = System.currentTimeMillis();
                    packet.bytes = new byte[s + 5];
                    packet.bytes[0] = 1;
                    packet.bytes[1] = (byte)(s / 255);
                    packet.bytes[2] = (byte)(s % 255);
                    packet.bytes[3] = (byte)(s2 / 255);
                    packet.bytes[4] = (byte)(s2 % 255);
                    System.arraycopy(byArray, 0, packet.bytes, 5, s);
                    if (this.m_displayPackets) {
                        this.messages.add(packet);
                        Debug.log(packet);
                    }
                    if (this.packetListener != null) {
                        this.packetListener.OnPacket(new EventObject(this), packet);
                    }
                    if (this._packetThread != null) {
                        try {
                            this._packetThread.join();
                        }
                        catch (InterruptedException interruptedException) {
                            Logger.getLogger(JniorSession.class.getName()).log(Level.SEVERE, null, interruptedException);
                        }
                    }
                    this._packetThread = new Thread(new Runnable(){

                        public void run() {
                            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                            int n = byteArrayInputStream.read();
                            if (DEBUG) {
                                Debug.log("Message Read: " + n);
                            }
                            if (JniorSession.this.m_messageHashtable.containsKey(new Integer(n))) {
                                Object v = JniorSession.this.m_messageHashtable.get(new Integer(n));
                                ((ProtocolMessage)v).receive(byteArrayInputStream, n);
                            }
                        }
                    });
                    this._packetThread.start();
                }
            } else {
                Debug.log("Not correct header byte " + Integer.toHexString(by) + " " + (char)by);
                if (packet != null) {
                    Debug.log(packet);
                }
                bl = false;
            }
        }
        if (n2 - byteBuffer.position() > 5) {
            this.readPacket(byteBuffer, byteBuffer.position(), n2);
        } else if (n2 == byteBuffer.position()) {
            byteBuffer.position(0);
            n = 0;
        } else {
            byteBuffer.position(n2);
        }
        return bl;
    }

    public void listen() {
        new Thread(new Runnable(){

            public void run() {
            }
        }).start();
    }

    public void run() {
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(65535);
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        while (this.isConnected()) {
            Object object;
            try {
                Thread.sleep(50L);
                this.heartbeat.sendHeartbeat();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            try {
                byte by;
                this.m_selector.select(30000L);
                Set<SelectionKey> set = this.m_selector.selectedKeys();
                if (set.size() == 0) continue;
                object = (SelectionKey)set.toArray()[0];
                if (!((SelectionKey)object).isValid()) {
                    Debug.log("Socket shutdown");
                }
                if (!((SelectionKey)object).isReadable()) continue;
                int n3 = this.m_socketChannel.read(byteBuffer);
                this._bytesRead += n3;
                n2 = byteBuffer.position();
                ++this.m_reads;
                this.m_totalBytesRead += (long)n3;
                this.fireProtocolReadEvent();
                if (n3 == -1) {
                    Debug.log("JNIOR Closed the remote connection.");
                    try {
                        this.disconnect(true);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                if (n3 == 0 && byteBuffer.position() == 0) continue;
                byteBuffer.position(n);
                if (!bl && (by = byteBuffer.get()) != 1) {
                    ++n;
                    byteBuffer.position(n2);
                    continue;
                }
                bl = true;
                short s = byteBuffer.getShort();
                int n4 = n2 - (byteBuffer.position() + 2);
                if (n4 < s) {
                    byteBuffer.position(n2);
                    continue;
                }
                if (!this.readPacket(byteBuffer, n, n2)) {
                    if (n >= n2) continue;
                    ++n;
                    continue;
                }
                bl = false;
            }
            catch (EOFException eOFException) {
                eOFException.printStackTrace();
                try {
                    this.disconnect(true);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                try {
                    this.disconnect(true);
                }
                catch (IOException iOException2) {
                    iOException2.printStackTrace();
                }
                try {
                    if (System.currentTimeMillis() - this.m_lastSent <= 30000L) continue;
                    if (DEBUG) {
                        Debug.log("Sent heartbeat @ " + new Date().toString());
                    }
                    object = ByteBuffer.allocateDirect(1);
                    ((ByteBuffer)object).put((byte)6);
                    this.m_socketChannel.write((ByteBuffer)object);
                    this.m_lastSent = System.currentTimeMillis();
                }
                catch (IOException iOException3) {
                    iOException3.printStackTrace();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                byteBuffer.reset();
                byteBuffer.flip();
            }
        }
        Debug.log("Socket Listener Closed.");
    }

    public void onLoginSent(EventObject eventObject, LoginProperties loginProperties) {
    }

    public void onLoginSuccess(EventObject eventObject, LoginProperties loginProperties) {
        this.m_loginLevel = loginProperties.getLoginLevel();
    }

    public void onLoginFailed(EventObject eventObject, LoginProperties loginProperties) {
        this.m_loginLevel = -1;
    }

    public void onConnectionSuccess(EventObject eventObject, boolean bl) {
        Thread thread = new Thread(this);
        thread.start();
        if (bl) {
            Object object;
            Object object2;
            try {
                object2 = this.m_registry.getAll();
                object = new RegistryRequest();
                for (int i = 0; i < ((Vector)object2).size(); ++i) {
                    RegistryKey registryKey = (RegistryKey)((Vector)object2).get(i);
                    if (!registryKey.isSubscribed()) continue;
                    ((RegistryRequest)object).addKey(registryKey);
                }
                this.m_registry.subscribeRegistry((RegistryRequest)object);
            }
            catch (NotYetConnectedException notYetConnectedException) {
                notYetConnectedException.printStackTrace();
            }
            catch (CommandTimeoutException commandTimeoutException) {
                commandTimeoutException.printStackTrace();
            }
            try {
                object2 = this.m_devices.elements();
                while (object2.hasMoreElements()) {
                    object = (Device)object2.nextElement();
                    if (!((Device)object).isSubscribed()) continue;
                    ((Device)object).subscribe();
                }
            }
            catch (NotYetConnectedException notYetConnectedException) {
                notYetConnectedException.printStackTrace();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void onConnectionAttempt(EventObject eventObject, boolean bl) {
    }

    public void onConnectionFailed(EventObject eventObject) {
    }

    public void onConnectionLost(EventObject eventObject, boolean bl) {
    }

    public void onQueryForPortAttempt(EventObject eventObject) {
    }

    public void onQueryForPortSuccess(EventObject eventObject, int n) {
    }

    public void printPackets() {
        for (int i = 0; i < this.messages.size(); ++i) {
            Debug.log((Packet)this.messages.get(i));
        }
    }

    class Heartbeat
    extends ProtocolMessage {
        public Heartbeat(JniorSession jniorSession2) {
            super(jniorSession2);
        }

        public void sendHeartbeat() {
            try {
                if (System.currentTimeMillis() - JniorSession.this.m_lastSent > 60000L) {
                    if (DEBUG) {
                        Debug.log("Sent heartbeat @ " + new Date().toString());
                    }
                    this.send(new byte[]{6}, false);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (NotYetConnectedException notYetConnectedException) {
                notYetConnectedException.printStackTrace();
            }
        }
    }

    class AbstractInternals
    extends Jr310Internals {
        public AbstractInternals(JniorSession jniorSession2) {
            super(jniorSession2);
        }
    }

    class AbstractDevice
    extends Device {
        public AbstractDevice(JniorSession jniorSession2) {
            super(jniorSession2);
        }
    }

    class AbstractLogin
    extends Login {
        public AbstractLogin(JniorSession jniorSession2) {
            super(jniorSession2);
        }
    }
}

