/*
 * Decompiled with CFR 0.152.
 */
package com.dalsemi.shell.server;

import com.dalsemi.comm.NullInputStream;
import com.dalsemi.shell.server.Session;
import com.integpg.comm.SerialInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;

public class SystemInputStream
extends SerialInputStream {
    private boolean terrible_trouble = false;
    protected Session session;
    protected InputStream root;
    protected PrintStream out;
    protected boolean rawMode;
    protected byte[] buffer;
    protected int startPos;
    protected int endPos;
    public String fileInName = null;
    protected boolean ECHO = true;
    protected static final int ASCII_BS = 8;
    protected static final int ASCII_DEL = 127;
    protected static final int ASCII_SPACE = 32;
    protected static final byte[] ERASE;
    private int count_available;
    private int THRESHHOLD;
    private static final int BUFFER_LENGTH = 50;
    byte[] temp = new byte[0];

    public SystemInputStream(InputStream in, PrintStream out) {
        this.out = out;
        this.root = in;
        this.buffer = new byte[50];
        this.startPos = 0;
        this.endPos = 0;
        this.count_available = 0;
        this.THRESHHOLD = this.buffer.length >> 2;
        this.rawMode = false;
    }

    public SystemInputStream(InputStream in, PrintStream out, String fileInName) {
        this(in, out);
        this.fileInName = fileInName;
    }

    public synchronized void setEcho(boolean echo) {
        this.ECHO = echo;
    }

    public synchronized boolean getEcho() {
        return this.ECHO;
    }

    public synchronized void setEchoStream(PrintStream echo) {
        this.out = echo;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    protected int rawRead() throws IOException {
        int c = this.root.read();
        if (this.ECHO && this.out != null && c != -1) {
            this.out.print((char)c);
        }
        return c;
    }

    protected int rawRead(byte[] buff, int off, int len) throws IOException {
        int i = 0;
        for (i = 0; i < len; ++i) {
            int ch = this.rawRead();
            if (ch == -1) {
                if (i == 0) {
                    return -1;
                }
                return i;
            }
            buff[i + off] = (byte)ch;
            if (this.rawAvailable() != 0) continue;
            len = i + 1;
        }
        return len;
    }

    protected int rawAvailable() throws IOException {
        return this.root.available();
    }

    private synchronized void readLineFill() throws IOException {
        int i;
        if (this.startPos > this.THRESHHOLD) {
            int diff = this.startPos;
            for (i = 0; i < this.endPos - this.startPos; ++i) {
                this.buffer[i] = this.buffer[i + this.startPos];
            }
            this.endPos -= diff;
            this.startPos = 0;
        }
        int amount = this.rawAvailable();
        while (amount > 0) {
            if (this.temp.length < amount) {
                this.temp = new byte[amount];
            }
            if ((amount = this.rawRead(this.temp, 0, amount)) == -1) {
                throw new IOException();
            }
            this.increaseBuffer(amount);
            System.arraycopy(this.temp, 0, this.buffer, this.endPos, amount);
            this.endPos += amount;
            amount = this.rawAvailable();
        }
        if (!this.rawMode) {
            this.fixBackspaces();
        }
        this.count_available = 0;
        for (i = this.startPos; i < this.endPos; ++i) {
            if (this.buffer[i] != 13 && this.buffer[i] != 10) continue;
            this.count_available = i - this.startPos + 1;
        }
    }

    private void fixBackspaces() {
        int i = 0;
        int len = this.endPos - this.startPos;
        while (i < len) {
            if (i == 0) {
                while ((this.buffer[this.startPos] == 8 || this.buffer[this.startPos] == 127) && this.startPos < this.endPos) {
                    --len;
                    ++this.startPos;
                }
            }
            if (i >= len) continue;
            byte ch = this.buffer[i + this.startPos];
            if ((ch == 8 || ch == 127) && i < len) {
                for (int j = i - 1; j < len - 2; ++j) {
                    this.buffer[this.startPos + j] = this.buffer[this.startPos + j + 2];
                }
                i -= 2;
                len -= 2;
            }
            ++i;
        }
        this.endPos = this.startPos + len;
    }

    private synchronized int blockUntilEndOfLine() throws IOException {
        int ch;
        do {
            if ((ch = this.rawRead()) != -1) {
                this.increaseBuffer(1);
                this.buffer[this.endPos] = (byte)ch;
                ++this.endPos;
            }
            if (ch == 8 || ch == 127) {
                this.endPos = this.endPos > this.startPos + 1 ? (this.endPos -= 2) : --this.endPos;
            }
            if (ch != -1 && ch != 10) continue;
            this.count_available = this.endPos - this.startPos;
            return this.endPos;
        } while (ch != 13);
        if (this.rawAvailable() > 0) {
            ch = this.rawRead();
            if (ch != -1) {
                this.increaseBuffer(1);
                this.buffer[this.endPos++] = (byte)ch;
            }
            if (ch != 10) {
                this.count_available = this.endPos - this.startPos - 1;
                return this.endPos;
            }
        }
        this.count_available = this.endPos - this.startPos;
        return this.endPos;
    }

    public synchronized String readLine() {
        String ret = null;
        try {
            int temp_lineIndex;
            this.readLineFill();
            int lineIndex = -1;
            for (int i = this.startPos; lineIndex == -1 && i < this.endPos; ++i) {
                if (this.buffer[i] == 10) {
                    lineIndex = i;
                    continue;
                }
                if (this.buffer[i] != 13) continue;
                lineIndex = i + 1 < this.endPos && this.buffer[i + 1] == 10 ? i + 1 : i;
            }
            if (lineIndex == -1) {
                lineIndex = this.blockUntilEndOfLine() - 1;
            }
            if (lineIndex < 0) {
                return "";
            }
            for (temp_lineIndex = lineIndex; temp_lineIndex >= 0 && (this.buffer[temp_lineIndex] == 13 || this.buffer[temp_lineIndex] == 10); --temp_lineIndex) {
            }
            ret = temp_lineIndex <= this.startPos - 1 ? "" : new String(this.buffer, this.startPos, temp_lineIndex - this.startPos + 1);
            this.count_available -= lineIndex - this.startPos + 1;
            this.startPos = lineIndex + 1;
        }
        catch (IOException ioe) {
            this.terrible_trouble = true;
            return null;
        }
        return ret;
    }

    public synchronized int read() throws IOException {
        return super.read();
    }

    public synchronized int read(byte[] buff, int off, int len) throws IOException {
        boolean ret = false;
        if (len == 0) {
            return 0;
        }
        if (off + len > buff.length) {
            len = buff.length - off;
        }
        if (this.rawMode) {
            int non_raw = this.endPos - this.startPos > len ? len : this.endPos - this.startPos;
            System.arraycopy(this.buffer, this.startPos, buff, off, non_raw);
            this.startPos += non_raw;
            this.count_available -= non_raw;
            if (non_raw != len) {
                byte[] temp = new byte[len - non_raw];
                int temp_read = this.rawRead(temp, 0, temp.length);
                if (temp_read == -1) {
                    return -1;
                }
                System.arraycopy(temp, 0, buff, off + non_raw, temp.length);
                non_raw += temp_read;
            }
            return non_raw;
        }
        while (this.count_available == 0) {
            this.readLineFill();
            if (this.count_available == 0) {
                this.blockUntilEndOfLine();
            }
            if (this.count_available != 0) continue;
            return -1;
        }
        len = Math.min(this.count_available, len - off);
        System.arraycopy(this.buffer, this.startPos, buff, off, len);
        this.startPos += len;
        this.count_available -= len;
        return len;
    }

    protected void increaseBuffer(int newDataSize) {
        if (this.endPos + newDataSize > this.buffer.length) {
            byte[] temp = new byte[this.buffer.length + 50 + newDataSize];
            System.arraycopy(this.buffer, 0, temp, 0, this.buffer.length);
            this.THRESHHOLD = temp.length >> 2;
            this.buffer = temp;
        }
    }

    public int available() {
        return super.available();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRawMode(boolean rawMode) {
        SystemInputStream systemInputStream = this;
        synchronized (systemInputStream) {
            this.rawMode = rawMode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRootStream(InputStream newIn) {
        SystemInputStream systemInputStream = this;
        synchronized (systemInputStream) {
            this.root = newIn == null ? new NullInputStream() : newIn;
        }
    }

    public InputStream getRootStream() {
        return this.root;
    }

    public boolean errorOccurred() {
        return this.terrible_trouble;
    }

    static {
        System.out.println("static sys");
        System.setIn((InputStream)((Object)new SystemInputStream(System.in, System.out)));
        ERASE = new byte[]{8, 32, 8};
    }
}

