/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.snmp.objects;

import com.integpg.janoslib.io.AppLog;
import com.integpg.snmp.objects.SNMPCodec;
import com.integpg.snmp.objects.SNMPObject;
import com.integpg.system.ArrayUtils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class SNMPIpAddress
extends SNMPObject {
    public String _value;
    public byte[] _data = new byte[4];

    public SNMPIpAddress() {
    }

    public SNMPIpAddress(String value) {
        this._value = value;
        try {
            InetAddress ipAddress = InetAddress.getByName(value);
            ArrayUtils.arraycopy((Object)ipAddress.getAddress(), (int)0, (Object)this._data, (int)0, (int)1);
        }
        catch (UnknownHostException ex) {
            AppLog.error("Error getting InetAddress for " + value);
        }
    }

    @Override
    public int getTag() {
        return 64;
    }

    @Override
    public Object getValue() {
        return this._value;
    }

    @Override
    public void encodeBER(SNMPCodec codec) throws IOException {
        super.encodeBER(codec);
        codec.write(this._data);
    }

    @Override
    public int getLength() {
        return 4;
    }

    @Override
    public String toString() {
        return "SNMPIpAddress: " + this._value;
    }
}

