/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.EmbeddedHelpers.Logging;

import com.dalsemi.system.TINIOS;
import com.integpg.EmbeddedHelpers.Base.EmbeddedBase;
import com.integpg.EmbeddedHelpers.Logging.LogEntry;
import com.integpg.EmbeddedHelpers.Logging.LogEvent;
import com.integpg.EmbeddedHelpers.Logging.LogFile;
import com.integpg.EmbeddedHelpers.Time.QuickTime;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Hashtable;
import java.util.Vector;

public class LogEngine
implements Runnable {
    public static final int MAX_LOG_FILE_SIZE = 32768;
    private static final byte[] CRLF = "\r\n".getBytes();
    private int m_maxLogFileSize = 32768;
    private Hashtable m_fileSizeHash = new Hashtable();
    private boolean m_quit = false;
    private Thread thd;
    private LogEvent m_logEventListener = null;
    private Vector orderEnforcedVector = new Vector();
    private boolean _paused = false;

    public LogEngine() {
    }

    public LogEngine(int maxFileSize) {
        this.m_maxLogFileSize = maxFileSize;
    }

    public LogEngine(LogEvent listener) {
        this.m_logEventListener = listener;
    }

    public LogEngine(int maxFileSize, LogEvent listener) {
        this.m_maxLogFileSize = maxFileSize;
        this.m_logEventListener = listener;
    }

    public void setLogFileSize(String filename, int size) {
        while (filename != null && filename.length() > 0 && filename.charAt(0) == '/') {
            filename = filename.substring(1);
        }
        if (this.m_fileSizeHash.containsKey(filename)) {
            this.m_fileSizeHash.remove(filename);
        }
        this.m_fileSizeHash.put(filename, new Integer(size));
    }

    public void start() {
        this.thd = new Thread((Runnable)this, "Log Engine");
        this.thd.start();
    }

    public void stop() {
        try {
            this.m_quit = true;
            if (this.thd != null) {
                this.thd.join();
            }
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    public void pause() {
        this._paused = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        LogEngine logEngine = this;
        synchronized (logEngine) {
            this._paused = false;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        StringBuffer sb = new StringBuffer(128);
        String lastFilename = null;
        int lastCapacity = 0;
        int ensureLoggingDuration = 30000;
        long nextForceLogging = TINIOS.uptimeMillis() + (long)ensureLoggingDuration;
        while (!this.m_quit) {
            Object object;
            if (this._paused) {
                object = this;
                synchronized (object) {
                    try {
                        System.out.println("Pausing " + Thread.currentThread().getName());
                        this.wait(60000L);
                        System.out.println("Resuming " + Thread.currentThread().getName());
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                    }
                }
            }
            try {
                object = this.orderEnforcedVector;
                synchronized (object) {
                    if (this.orderEnforcedVector.size() > 0) {
                        String str;
                        Object obj = this.orderEnforcedVector.elementAt(0);
                        while (obj != null) {
                            LogEntry le = (LogEntry)obj;
                            if (le != null) {
                                if (le._timestamp == -1L || le._message == null) {
                                    System.out.println("Object not ready - " + le._message);
                                    if (System.currentTimeMillis() - le._timestamp <= 60000L) break;
                                    this.orderEnforcedVector.removeElementAt(0);
                                    break;
                                }
                                this.orderEnforcedVector.removeElementAt(0);
                                if (le._filename.indexOf(".log") > 0) {
                                    if (!(lastFilename == null || le._filename.equals(lastFilename) && TINIOS.uptimeMillis() <= nextForceLogging)) {
                                        int maxSize = this.m_maxLogFileSize;
                                        if (this.m_fileSizeHash.containsKey(lastFilename)) {
                                            maxSize = (Integer)this.m_fileSizeHash.get(lastFilename);
                                        }
                                        String str2 = sb.toString();
                                        RandomAccessFile log = LogFile.open(lastFilename, str2.length(), maxSize);
                                        log.seek(log.length());
                                        log.write(str2.getBytes());
                                        log.close();
                                        sb.setLength(0);
                                        lastFilename = null;
                                        nextForceLogging = Integer.MAX_VALUE;
                                    }
                                    str = le.toString();
                                    sb.append(str);
                                    sb.append("\r\n");
                                    if (sb.capacity() > lastCapacity) {
                                        lastCapacity = sb.capacity();
                                    }
                                    lastFilename = le._filename;
                                    if (nextForceLogging == Integer.MAX_VALUE) {
                                        nextForceLogging = TINIOS.uptimeMillis() + (long)ensureLoggingDuration;
                                    }
                                }
                            }
                            if (!this._paused && this.orderEnforcedVector.size() > 0) {
                                obj = this.orderEnforcedVector.elementAt(0);
                                continue;
                            }
                            obj = null;
                        }
                        if (sb.length() > 0) {
                            int maxSize = this.m_maxLogFileSize;
                            if (this.m_fileSizeHash.containsKey(lastFilename)) {
                                maxSize = (Integer)this.m_fileSizeHash.get(lastFilename);
                            }
                            str = sb.toString();
                            RandomAccessFile log = LogFile.open(lastFilename, str.length(), maxSize);
                            log.seek(log.length());
                            log.write(str.getBytes());
                            log.close();
                            sb.setLength(0);
                            lastFilename = null;
                            nextForceLogging = Integer.MAX_VALUE;
                        }
                    }
                }
                Thread.sleep(2000L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public synchronized LogEntry logEntry(String filename, String message) {
        return this.logEntry(filename, message, QuickTime.getTimeMillis());
    }

    public synchronized LogEntry logEntry(String filename, String message, long timestamp) {
        LogEntry le = new LogEntry();
        le._filename = filename;
        le._message = message;
        le._timestamp = timestamp;
        this.logEntry(le);
        return le;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEntry(LogEntry le) {
        Vector vector = this.orderEnforcedVector;
        synchronized (vector) {
            this.orderEnforcedVector.removeElement(le);
        }
        this.logEntry(le);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void logEntry(LogEntry le) {
        try {
            Vector vector = this.orderEnforcedVector;
            synchronized (vector) {
                int i;
                int count = this.orderEnforcedVector.size();
                for (i = 0; i < count; ++i) {
                    LogEntry leFromVector = (LogEntry)this.orderEnforcedVector.elementAt(i);
                    if (le._timestamp < leFromVector._timestamp) break;
                }
                this.orderEnforcedVector.insertElementAt(le, i);
            }
        }
        catch (Throwable t) {
            EmbeddedBase.BASE.log("Exception in logEntry() - " + t.toString());
        }
    }
}

