/*
 * Decompiled with CFR 0.152.
 */
package integpg.EmbeddedHelpers.Logging;

import com.integpg.system.JANOS;
import integpg.EmbeddedHelpers.Base.EmbeddedBase;
import integpg.EmbeddedHelpers.Logging.LogEntry;
import integpg.EmbeddedHelpers.Logging.LogEvent;
import integpg.EmbeddedHelpers.Logging.LogFile;
import integpg.EmbeddedHelpers.Time.QuickTime;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Hashtable;
import java.util.Vector;

public class LogEngine
implements Runnable {
    public static final int MAX_LOG_FILE_SIZE = 32768;
    private static final byte[] CRLF = "\r\n".getBytes();
    private int m_maxLogFileSize = 32768;
    private Hashtable m_fileSizeHash = new Hashtable();
    private boolean m_quit = false;
    private Thread thd;
    private LogEvent m_logEventListener = null;
    private Vector orderEnforcedVector = new Vector();
    private boolean _paused = false;

    public LogEngine() {
    }

    public LogEngine(int n) {
        this.m_maxLogFileSize = n;
    }

    public LogEngine(LogEvent logEvent) {
        this.m_logEventListener = logEvent;
    }

    public LogEngine(int n, LogEvent logEvent) {
        this.m_maxLogFileSize = n;
        this.m_logEventListener = logEvent;
    }

    public void setLogFileSize(String string, int n) {
        while (string != null && string.length() > 0 && string.charAt(0) == '/') {
            string = string.substring(1);
        }
        if (this.m_fileSizeHash.containsKey(string)) {
            this.m_fileSizeHash.remove(string);
        }
        this.m_fileSizeHash.put(string, new Integer(n));
    }

    public void start() {
        this.thd = new Thread((Runnable)this, "Log Engine");
        this.thd.start();
    }

    public void stop() {
        try {
            this.m_quit = true;
            if (this.thd != null) {
                this.thd.join();
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public void pause() {
        this._paused = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        LogEngine logEngine = this;
        synchronized (logEngine) {
            this._paused = false;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        StringBuffer stringBuffer = new StringBuffer(128);
        String string = null;
        int n = 0;
        int n2 = 30000;
        long l = JANOS.uptimeMillis() + (long)n2;
        while (!this.m_quit) {
            Object object;
            if (this._paused) {
                object = this;
                synchronized (object) {
                    try {
                        System.out.println("Pausing " + Thread.currentThread().getName());
                        this.wait(60000L);
                        System.out.println("Resuming " + Thread.currentThread().getName());
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
            }
            try {
                object = this.orderEnforcedVector;
                synchronized (object) {
                    if (this.orderEnforcedVector.size() > 0) {
                        String string2;
                        Object object2;
                        Object e = this.orderEnforcedVector.elementAt(0);
                        while (e != null) {
                            LogEntry logEntry = (LogEntry)e;
                            if (logEntry != null) {
                                if (logEntry._timestamp == -1L || logEntry._message == null) {
                                    System.out.println("Object not ready - " + logEntry._message);
                                    if (System.currentTimeMillis() - logEntry._timestamp <= 60000L) break;
                                    this.orderEnforcedVector.removeElementAt(0);
                                    break;
                                }
                                this.orderEnforcedVector.removeElementAt(0);
                                if (logEntry._filename.indexOf(".log") > 0) {
                                    if (!(string == null || logEntry._filename.equals(string) && JANOS.uptimeMillis() <= l)) {
                                        int n3 = this.m_maxLogFileSize;
                                        if (this.m_fileSizeHash.containsKey(string)) {
                                            n3 = (Integer)this.m_fileSizeHash.get(string);
                                        }
                                        object2 = stringBuffer.toString();
                                        RandomAccessFile randomAccessFile = LogFile.open(string, ((String)object2).length(), n3);
                                        randomAccessFile.seek(randomAccessFile.length());
                                        randomAccessFile.write(((String)object2).getBytes());
                                        randomAccessFile.close();
                                        stringBuffer.setLength(0);
                                        string = null;
                                        l = Integer.MAX_VALUE;
                                    }
                                    string2 = logEntry.toString();
                                    stringBuffer.append(string2);
                                    stringBuffer.append("\r\n");
                                    if (stringBuffer.capacity() > n) {
                                        n = stringBuffer.capacity();
                                    }
                                    string = logEntry._filename;
                                    if (l == Integer.MAX_VALUE) {
                                        l = JANOS.uptimeMillis() + (long)n2;
                                    }
                                }
                            }
                            if (!this._paused && this.orderEnforcedVector.size() > 0) {
                                e = this.orderEnforcedVector.elementAt(0);
                                continue;
                            }
                            e = null;
                        }
                        if (stringBuffer.length() > 0) {
                            int n4 = this.m_maxLogFileSize;
                            if (this.m_fileSizeHash.containsKey(string)) {
                                n4 = (Integer)this.m_fileSizeHash.get(string);
                            }
                            string2 = stringBuffer.toString();
                            object2 = LogFile.open(string, string2.length(), n4);
                            ((RandomAccessFile)object2).seek(((RandomAccessFile)object2).length());
                            ((RandomAccessFile)object2).write(string2.getBytes());
                            ((RandomAccessFile)object2).close();
                            stringBuffer.setLength(0);
                            string = null;
                            l = Integer.MAX_VALUE;
                        }
                    }
                }
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public synchronized LogEntry logEntry(String string, String string2) {
        return this.logEntry(string, string2, QuickTime.getTimeMillis());
    }

    public synchronized LogEntry logEntry(String string, String string2, long l) {
        LogEntry logEntry = new LogEntry();
        logEntry._filename = string;
        logEntry._message = string2;
        logEntry._timestamp = l;
        this.logEntry(logEntry);
        return logEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEntry(LogEntry logEntry) {
        Vector vector = this.orderEnforcedVector;
        synchronized (vector) {
            this.orderEnforcedVector.removeElement(logEntry);
        }
        this.logEntry(logEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void logEntry(LogEntry logEntry) {
        try {
            Vector vector = this.orderEnforcedVector;
            synchronized (vector) {
                int n;
                int n2 = this.orderEnforcedVector.size();
                for (n = 0; n < n2; ++n) {
                    LogEntry logEntry2 = (LogEntry)this.orderEnforcedVector.elementAt(n);
                    if (logEntry._timestamp < logEntry2._timestamp) break;
                }
                this.orderEnforcedVector.insertElementAt(logEntry, n);
            }
        }
        catch (Throwable throwable) {
            EmbeddedBase.BASE.log("Exception in logEntry() - " + throwable.toString());
        }
    }
}

