/*
 * Decompiled with CFR 0.152.
 */
package JniorProtocol;

import JniorProtocol.Helpers.Debug.Debug;
import JniorProtocol.Listeners.ConnectionListener;
import JniorProtocol.Properties.ConnectionProperties;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Date;
import java.util.EventObject;
import java.util.Vector;

public abstract class JniorConnection {
    public static final int OUTGOING = 0;
    public static final int INCOMING = 1;
    private final Vector m_connectionListeners = new Vector();
    protected SocketChannel m_socketChannel;
    private String m_host;
    private int m_port;
    private String m_codebase;
    private ConnectionProperties m_connectionProperties = new ConnectionProperties("", 0);
    protected Selector m_selector = null;
    private boolean m_cancel = false;
    private int direction = 0;
    private Thread retryThread;

    protected JniorConnection() {
    }

    public String getHost() {
        return this.m_host;
    }

    public int getPort() {
        return this.m_port;
    }

    public int getDirection() {
        return this.direction;
    }

    public void setCodebase(String string) {
        this.m_codebase = string;
    }

    public void setSocketChannel(SocketChannel socketChannel) {
        this.m_socketChannel = socketChannel;
        try {
            this.m_socketChannel.configureBlocking(false);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.direction = 1;
        this.m_host = socketChannel.socket().getInetAddress().getHostAddress();
        this.m_port = socketChannel.socket().getPort();
        this.registerSelector();
        this.m_connectionProperties.setRetryCount(0);
        this.fireConnectionSuccessEvent(false);
    }

    public void addConnectionListener(ConnectionListener connectionListener) {
        for (int i = 0; i < this.m_connectionListeners.size(); ++i) {
            if (!((ConnectionListener)this.m_connectionListeners.elementAt(i)).equals(connectionListener)) continue;
            return;
        }
        this.m_connectionListeners.add(connectionListener);
    }

    public ConnectionProperties getConnectionProperties() {
        return this.m_connectionProperties;
    }

    private static boolean isIpAddress(String string) {
        return string.matches("^[\\d]{1,3}\\.[\\d]{1,3}\\.[\\d]{1,3}\\.[\\d]{1,3}$");
    }

    private static SocketChannel createSocketChannel(String string, int n) {
        SocketChannel socketChannel = null;
        try {
            socketChannel = SocketChannel.open();
            socketChannel.configureBlocking(false);
            if (!JniorConnection.isIpAddress(string)) {
                string = InetAddress.getByName(string).getHostAddress();
            }
            Debug.log("Connect to " + string + ":" + n);
            try {
                socketChannel.connect(new InetSocketAddress(string, n));
            }
            catch (ClosedByInterruptException closedByInterruptException) {
                Debug.log(new Date().toString());
                closedByInterruptException.printStackTrace();
                return null;
            }
            if (socketChannel != null) {
                while (!socketChannel.finishConnect()) {
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
                while (!socketChannel.isConnected()) {
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
            iOException.printStackTrace();
            socketChannel = null;
        }
        return socketChannel;
    }

    public void setConnectionProperties(ConnectionProperties connectionProperties) {
        this.m_connectionProperties = connectionProperties;
    }

    public void connect() throws NullPointerException {
        if (this.m_connectionProperties == null) {
            throw new NullPointerException("Connection Properties not set, use setConnectionProperties(CP) to set the properties before calling this method.");
        }
        this.connect(this.m_connectionProperties);
    }

    public boolean connect(ConnectionProperties connectionProperties) {
        return this.connect(connectionProperties, false);
    }

    public boolean connect(ConnectionProperties connectionProperties, boolean bl) {
        this.m_connectionProperties = connectionProperties;
        return this.connect(connectionProperties.getHostAddress(), connectionProperties.getPort(), bl);
    }

    private boolean connect(String string, int n, final boolean bl) {
        if (this.retryThread != null) {
            this.retryThread = null;
        }
        this.m_host = string;
        this.m_port = n;
        if (this.m_port <= 0) {
            this.m_port = this.queryPort();
        }
        this.fireConnectionAttemptEvent();
        try {
            this.m_socketChannel = JniorConnection.createSocketChannel(this.m_host, this.m_port);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.isConnected()) {
            this.m_connectionProperties.resetRetriesLeft();
            this.registerSelector();
            if (this.m_cancel) {
                return false;
            }
            this.fireConnectionSuccessEvent(bl);
        } else {
            this.fireConnectionFailedEvent();
            if (this.m_connectionProperties.decrementRetriesLeft() > 0) {
                this.retryThread = new Thread(new Runnable(){

                    public void run() {
                        try {
                            Debug.log("Wait " + JniorConnection.this.m_connectionProperties.getRetryTimeout());
                            Thread.sleep(JniorConnection.this.m_connectionProperties.getRetryTimeout());
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                        }
                        if (JniorConnection.this.m_cancel) {
                            return;
                        }
                        Debug.log("Retry Connection from connect");
                        JniorConnection.this.connect(JniorConnection.this.m_connectionProperties, bl);
                    }
                });
                Debug.log("Start reconnect timer");
                this.retryThread.start();
            }
        }
        return this.isConnected();
    }

    public void disconnect() throws IOException {
        this.disconnect(false);
    }

    public void disconnect(boolean bl) throws IOException {
        this.m_cancel = !bl;
        Debug.log("Disconnecting");
        if (this.retryThread != null) {
            this.retryThread.interrupt();
            this.retryThread = null;
        }
        if (this.m_socketChannel != null) {
            try {
                this.m_socketChannel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.m_socketChannel = null;
        }
        boolean bl2 = bl;
        this.fireConnectionLostEvent(bl2);
        if (bl2) {
            this.retryThread = new Thread(new Runnable(){

                public void run() {
                    try {
                        Debug.log("Wait " + JniorConnection.this.m_connectionProperties.getRetryTimeout());
                        Thread.sleep(JniorConnection.this.m_connectionProperties.getRetryTimeout());
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                    Debug.log("Retry Connection from disconnect");
                    JniorConnection.this.connect(JniorConnection.this.m_connectionProperties, true);
                }
            });
            Debug.log("Start reconnect timer");
            this.retryThread.start();
        }
    }

    private void fireConnectionAttemptEvent() {
        if (this.m_connectionListeners != null) {
            int n = 0;
            while (n < this.m_connectionListeners.size()) {
                final int n2 = n++;
                new Thread(new Runnable(){

                    public void run() {
                        ConnectionListener connectionListener = (ConnectionListener)JniorConnection.this.m_connectionListeners.get(n2);
                        connectionListener.onConnectionAttempt(new EventObject(JniorConnection.this), JniorConnection.this.m_connectionProperties.getRetryCount() != JniorConnection.this.m_connectionProperties.getRetriesLeft());
                    }
                }).start();
            }
        }
    }

    private void fireConnectionSuccessEvent(final boolean bl) {
        if (this.m_connectionListeners != null) {
            int n = 0;
            while (n < this.m_connectionListeners.size()) {
                final int n2 = n++;
                new Thread(new Runnable(){

                    public void run() {
                        ConnectionListener connectionListener = (ConnectionListener)JniorConnection.this.m_connectionListeners.get(n2);
                        connectionListener.onConnectionSuccess(new EventObject(JniorConnection.this), bl);
                    }
                }).start();
            }
        }
    }

    private void fireConnectionFailedEvent() {
        if (this.m_connectionListeners != null) {
            int n = 0;
            while (n < this.m_connectionListeners.size()) {
                final int n2 = n++;
                new Thread(new Runnable(){

                    public void run() {
                        ConnectionListener connectionListener = (ConnectionListener)JniorConnection.this.m_connectionListeners.get(n2);
                        connectionListener.onConnectionFailed(new EventObject(JniorConnection.this));
                    }
                }).start();
            }
        }
    }

    private void fireConnectionLostEvent(final boolean bl) {
        if (this.m_connectionListeners != null) {
            int n = 0;
            while (n < this.m_connectionListeners.size()) {
                final int n2 = n++;
                new Thread(new Runnable(){

                    public void run() {
                        ConnectionListener connectionListener = (ConnectionListener)JniorConnection.this.m_connectionListeners.get(n2);
                        connectionListener.onConnectionLost(new EventObject(JniorConnection.this), bl);
                    }
                }).start();
            }
        }
    }

    public boolean isConnected() {
        if (this.m_socketChannel == null) {
            return false;
        }
        return this.m_socketChannel.isConnected();
    }

    private int queryPort() {
        int n;
        if (this.m_connectionListeners != null) {
            int n2 = 0;
            while (n2 < this.m_connectionListeners.size()) {
                final int n3 = n2++;
                new Thread(new Runnable(){

                    public void run() {
                        ConnectionListener connectionListener = (ConnectionListener)JniorConnection.this.m_connectionListeners.get(n3);
                        connectionListener.onQueryForPortAttempt(new EventObject(JniorConnection.this));
                    }
                }).start();
            }
        }
        long l = System.currentTimeMillis();
        if (this.m_codebase == null) {
            this.m_codebase = "http://" + this.m_host;
        }
        String string = this.m_codebase + "/query.cgi?access";
        URL uRL = null;
        URLConnection uRLConnection = null;
        DataInputStream dataInputStream = null;
        int n4 = 0;
        try {
            String string2;
            uRL = new URL(string);
            uRLConnection = uRL.openConnection();
            uRLConnection.connect();
            dataInputStream = new DataInputStream(new BufferedInputStream(uRLConnection.getInputStream()));
            while ((string2 = dataInputStream.readLine()) != null) {
                Debug.log(string2);
                int n5 = string2.indexOf("<authorization>");
                n5 = string2.indexOf("<JniorServer>");
                if (n5 < 0) continue;
                n = string2.substring(n5 + 13).indexOf("</");
                n4 = Integer.parseInt(string2.substring(n5 + 13, n5 + 13 + n));
            }
            dataInputStream.close();
        }
        catch (MalformedURLException malformedURLException) {
            Debug.log("Bad URL: " + string);
        }
        catch (IOException iOException) {
            Debug.log("IO Error:" + iOException.getMessage());
        }
        Debug.log("Time to get port " + (System.currentTimeMillis() - l));
        final int n6 = n4;
        if (this.m_connectionListeners != null) {
            n = 0;
            while (n < this.m_connectionListeners.size()) {
                final int n7 = n++;
                new Thread(new Runnable(){

                    public void run() {
                        ConnectionListener connectionListener = (ConnectionListener)JniorConnection.this.m_connectionListeners.get(n7);
                        connectionListener.onQueryForPortSuccess(new EventObject(JniorConnection.this), n6);
                    }
                }).start();
            }
        }
        return n4;
    }

    private void registerSelector() {
        try {
            this.m_selector = Selector.open();
            this.m_socketChannel.register(this.m_selector, 1);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

