/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.TaskManager;

import com.integpg.EmbeddedHelpers.Base.EmbeddedBase;
import com.integpg.system.Watchdog;
import integpg.JniorOS;
import java.io.IOException;

public class ApplicationWatchdog
implements Runnable {
    private JniorOS m_jnioros = null;
    private String m_name;
    private String m_regWatchdog;
    private long m_lastWatchdogUpdate = 0L;
    private Watchdog _watchdog = null;
    private Thread _thd;

    public ApplicationWatchdog(JniorOS jnioros, String name) {
        this.m_jnioros = jnioros;
        this.m_name = name;
        this.m_regWatchdog = "AppData/" + this.m_name + "/$Watchdog";
        this._watchdog = new Watchdog("Task");
        this._watchdog.setAction(0);
    }

    public synchronized void triggerWatchdog() {
        this.triggerWatchdog(0L);
    }

    public synchronized void triggerWatchdog(long time) {
        try {
            if (time - this.m_lastWatchdogUpdate > 30000L || time <= 0L) {
                this.m_jnioros.setRegistryString(this.m_regWatchdog, String.valueOf(time));
                this.m_lastWatchdogUpdate = time;
            }
        }
        catch (IOException ex) {
            EmbeddedBase.BASE.logError("Error triggering watchdog", ex);
        }
    }

    public void start() {
        if (null != this._watchdog && null == this._thd) {
            this._thd = new Thread(this);
            this._thd.setName("Task Watchdog");
            this._thd.setDaemon(true);
            this._thd.start();
        }
    }

    @Override
    public void run() {
        EmbeddedBase.BASE.log("Activate " + this._watchdog.getText() + " watchdog");
        this._watchdog.activate(120000);
        try {
            while (true) {
                System.out.println("hit watchdog");
                this._watchdog.refresh();
                Thread.sleep(60000L);
            }
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
            return;
        }
    }
}

