/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.web.handlers;

import com.integ.janoslib.messagepump.MessagePumpAppMessageListener;
import com.integ.janoslib.messagepump.MessagePumpEngine;
import com.integ.tasker.tasks.Task;
import com.integ.tasker.tasks.TaskCollection;
import com.integ.tasker.tasks.TaskResult;
import com.integ.tasker.web.handlers.ErrorMessage;
import com.integ.tasker.web.messages.StatusUpdateMessage;
import com.integpg.janoslib.io.AppLog;
import java.util.Json;

public class TaskExecuteHandler
implements MessagePumpAppMessageListener {
    @Override
    public void applicationMessageReceived(final Json commandJson) {
        System.out.println("commandJson: " + commandJson);
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                String taskName = "unknown";
                try {
                    taskName = commandJson.getString("TaskName");
                    Task task = TaskCollection.GLOBAL.getByTaskName(taskName);
                    if (null != task) {
                        StatusUpdateMessage message = new StatusUpdateMessage(String.format("Executing %s", taskName));
                        MessagePumpEngine.postMessage(message.build());
                        TaskResult result = task.execute();
                        if (TaskResult.SUCCESS == result) {
                            message = new StatusUpdateMessage(String.format("%s executed successfully", taskName));
                        } else if (TaskResult.CANCELLED == result) {
                            message = new StatusUpdateMessage(String.format("%s was cancelled by another Task", taskName));
                        }
                        MessagePumpEngine.postMessage(message.build());
                    }
                }
                catch (Throwable ex) {
                    AppLog.error(ex);
                    ErrorMessage message = new ErrorMessage(ex);
                    MessagePumpEngine.postMessage(message.build());
                }
            }
        });
        thread.setName("Executing " + commandJson.getString("TaskName"));
        thread.setDaemon(true);
        thread.start();
    }
}

