/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.schedules;

import com.integ.tasker.schedules.Schedule;
import com.integ.tasker.schedules.ScheduleCollection;
import com.integ.tasker.schedules.rules.ScheduleRuleBase;
import com.integpg.janoslib.logger.FileLog;
import com.integpg.janoslib.logger.LogOptions;
import com.integpg.janoslib.logger.LogTypes;
import com.integpg.janoslib.logger.Logger;
import com.integpg.janoslib.system.Application;
import java.util.ArrayList;

public class ScheduleMonitor
implements Runnable {
    private static final Logger LOG = FileLog.getLog(new LogOptions(Application.getAppName() + "_schedules.log").setLogType(LogTypes.HalfBak));
    private static final ScheduleMonitor INSTANCE = new ScheduleMonitor();
    private static Thread Thread = null;

    public static void start() {
        if (null == Thread) {
            Thread = new Thread(INSTANCE);
            Thread.setName(ScheduleMonitor.class.getName());
            Thread.start();
        }
    }

    @Override
    public void run() {
        long lastCheck = Long.MAX_VALUE;
        LOG.info("Schedule Monitor Starting...");
        while (true) {
            long now = System.currentTimeMillis();
            ArrayList<Schedule> schedules = ScheduleCollection.getSchedules();
            for (Schedule schedule : schedules) {
                ArrayList<ScheduleRuleBase> scheduleRules = schedule.getScheduleRules();
                for (ScheduleRuleBase scheduleRule : scheduleRules) {
                    long nextExecutionTime;
                    if (null == scheduleRule || lastCheck >= (nextExecutionTime = scheduleRule.getNextExecutionTime()) || nextExecutionTime > now) continue;
                    schedule.execute();
                    scheduleRule.updateNextExecutionTime();
                }
            }
            lastCheck = now;
            try {
                long elapsed = System.currentTimeMillis() - now;
                long sleepTime = 1000L - elapsed;
                if (250L > sleepTime) {
                    sleepTime = 250L;
                }
                java.lang.Thread.sleep(sleepTime);
            }
            catch (InterruptedException ex) {
            }
        }
    }
}

