/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.slaveservice;

import com.integpg.janoslib.io.AppLog;
import com.integpg.slaveservice.JniorConnection;
import com.integpg.slaveservice.JniorConnectionListener;
import com.integpg.slaveservice.SlaveService;
import com.integpg.system.JANOS;
import java.io.IOException;

public class RemoteSlaveService
extends SlaveService
implements JniorConnectionListener {
    private final JniorConnection _jniorConnection;

    public RemoteSlaveService(String ipAddress, int port, String username, String password) {
        this._jniorConnection = new JniorConnection(ipAddress, port, username, password);
        this._jniorConnection.addConnectionListener(this);
    }

    @Override
    protected void monitor() {
        AppLog.info("Starting Remote Slave Service for " + this._jniorConnection.getIPAddress());
        this._jniorConnection.start();
        this._monitorThread = new Thread(this);
        this._monitorThread.setDaemon(true);
        this._monitorThread.setName("Remote Slave Service for " + this._jniorConnection.getIPAddress());
        this._monitorThread.start();
    }

    @Override
    public void run() {
        AppLog.info("Remote Slave Service for " + this._jniorConnection.getIPAddress() + " has started");
        this._running = true;
        while (this._running) {
            if (this._jniorConnection.getConnectionState()) {
                int newOutputs = 0;
                if (this._followedInputMask != 0) {
                    newOutputs |= this.trackInputs();
                }
                if (this._followedOutputMask != 0) {
                    newOutputs |= this.trackOutputs();
                }
                try {
                    JANOS.setOutputStates((int)newOutputs, (int)this._usedOutputMask);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        AppLog.info("Remote Slave Service for " + this._jniorConnection.getIPAddress() + " has stopped");
        this._jniorConnection.close();
    }

    @Override
    public int trackInputs() {
        int inputs = this._jniorConnection.getInputStates();
        int newOutputs = 0;
        for (int channel = 0; channel < 12; ++channel) {
            int state;
            if ((this._followedInputMask >> channel & 1) == 0 || (state = inputs >> channel & 1) != 1) continue;
            int outputChannel = this._inputs[channel];
            newOutputs |= 1 << outputChannel;
        }
        return newOutputs;
    }

    @Override
    public int trackOutputs() {
        int outputs = this._jniorConnection.getOutputStates();
        int newOutputs = 0;
        for (int channel = 0; channel < 12; ++channel) {
            int state;
            if ((this._followedOutputMask >> channel & 1) == 0 || (state = outputs >> channel & 1) != 1) continue;
            int outputChannel = this._outputs[channel];
            newOutputs |= 1 << outputChannel;
        }
        return newOutputs;
    }

    @Override
    public void connectionEstablished() {
        AppLog.warn(this._jniorConnection.getIPAddress() + " connection established");
    }

    @Override
    public void connectionLost() {
        AppLog.warn(this._jniorConnection.getIPAddress() + " connection lost");
        try {
            int failedOutputStates = this.getFailedOutputStates();
            AppLog.warn("set outputs 0x" + Long.toHexString(this._failedOutputMask) + " to 0x" + Long.toHexString(failedOutputStates));
            JANOS.setOutputStates((int)failedOutputStates, (int)this._failedOutputMask);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public int getFailedOutputStates() {
        int newOutputs = 0;
        for (int channel = 0; channel < 12; ++channel) {
            if ((this._failedOutputMask >> channel & 1) == 0) continue;
            System.out.println("_failedOutputStrings[" + channel + "]: " + this._failedOutputStrings[channel]);
            int state = "relay-on".equals(this._failedOutputStrings[channel]) ? 1 : 0;
            System.out.println("Failed Output States " + (channel + 1) + "=" + state);
            if (state != 1) continue;
            System.out.println("Output " + channel + "=" + state + "   0x" + Long.toHexString(newOutputs |= 1 << channel));
        }
        return newOutputs;
    }
}

