/*
 * Decompiled with CFR 0.152.
 */
package JniorProtocol.Devices;

import JniorProtocol.Devices.Device;
import JniorProtocol.Exceptions.CommandTimeoutException;
import JniorProtocol.Exceptions.NotLoggedInException;
import JniorProtocol.Exceptions.NotYetConnectedException;
import JniorProtocol.JniorSession;
import java.io.IOException;

public abstract class Jr310InternalDevice
extends Device {
    public static final int COMMAND = 10;
    public static final int COMMAND_PULSE = 6;
    public static final int COMMAND_BLOCK_PULSE = 7;
    protected boolean m_monitorPacketsEnabled = true;
    protected boolean m_monitorPacketReceived = false;
    public byte m_currentState = 0;
    public long m_usageMeter = 0L;
    public byte m_usageAlarm = 0;

    public Jr310InternalDevice(JniorSession jniorSession) {
        super(jniorSession);
    }

    public int getChannel() {
        return this.m_channel;
    }

    public int getState() throws CommandTimeoutException, NotYetConnectedException {
        if (!this.m_monitorPacketsEnabled) {
            this.m_monitorPacketReceived = false;
            this.m_session.getInternalsInstance().requestMonitorPacket();
            long l = System.currentTimeMillis();
            while (this.m_session.isConnected() && this.m_session.isConnected() && !this.m_monitorPacketReceived && !this.isCommandTimeout(l)) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return this.m_currentState;
    }

    public Device[] enumerate() throws CommandTimeoutException, NotYetConnectedException, NotLoggedInException {
        return this.m_session.enumerate(1);
    }

    public void setEnableMonitorPackets(boolean bl) throws NotYetConnectedException {
        this.m_monitorPacketsEnabled = bl;
        if (bl) {
            this.m_session.getRequestInstance().buildRequestPacket(5);
        } else {
            this.m_session.getRequestInstance().buildRequestPacket(4);
        }
    }

    protected void buildCommandPacket(int n) throws NotYetConnectedException {
        this.buildCommandPacket(n, 0);
    }

    protected void buildCommandPacket(int n, int n2) throws NotYetConnectedException {
        byte[] byArray = new byte[8];
        int n3 = 0;
        byArray[n3++] = 10;
        byArray[n3++] = (byte)n;
        byArray = Jr310InternalDevice.setShort(byArray, n3, (short)this.m_channel);
        n3 += 2;
        if (n == 6) {
            byArray = Jr310InternalDevice.setInt(byArray, n3, n2);
            n3 += 4;
        }
        try {
            this.send(byArray, 0, n3);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    protected void buildCommandPacket(int n, int n2, int n3, int n4) throws NotYetConnectedException {
        byte[] byArray = new byte[8];
        int n5 = 0;
        byArray[n5++] = 10;
        byArray[n5++] = (byte)n;
        byArray[n5++] = (byte)n2;
        byArray[n5++] = (byte)n3;
        if (n == 7) {
            byArray = Jr310InternalDevice.setInt(byArray, n5, n4);
            n5 += 4;
        }
        try {
            this.send(byArray, 0, n5);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

