/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.slaveservice;

public abstract class SlaveService
implements Runnable {
    protected Thread _monitorThread = null;
    protected int _followedInputMask = 0;
    protected int[] _inputs = new int[12];
    protected int _followedOutputMask = 0;
    protected int[] _outputs = new int[16];
    protected int _failedOutputMask = 0;
    protected String[] _failedOutputStrings = new String[16];
    protected int _usedOutputMask = 0;
    protected boolean _running = false;

    public void followInput(int inputToMonitor, int localOutput) {
        this._followedInputMask |= 1 << inputToMonitor - 1;
        this._inputs[inputToMonitor - 1] = localOutput - 1;
        this._usedOutputMask |= 1 << localOutput - 1;
        if (this._usedOutputMask != 0 && !this.isRunning()) {
            this.monitor();
        }
    }

    public void unfollowInput(int inputToMonitor, int localOutput) {
        int inputUnmask = 1 << inputToMonitor - 1;
        this._followedInputMask &= (inputUnmask ^= 0xFFFF);
        this._inputs[inputToMonitor - 1] = -1;
        int localOutputUnmask = 1 << localOutput - 1;
        this._usedOutputMask &= (localOutputUnmask ^= 0xFFFF);
        if (this._usedOutputMask == 0 && this.isRunning()) {
            this.stop();
        }
    }

    public void followOutput(int outputToMonitor, int localOutput) {
        this._followedOutputMask |= 1 << outputToMonitor - 1;
        this._outputs[outputToMonitor - 1] = localOutput - 1;
        this._usedOutputMask |= 1 << localOutput - 1;
        if (this._usedOutputMask != 0 && !this.isRunning()) {
            this.monitor();
        }
    }

    public void unfollowOutput(int outputToMonitor, int localOutput) {
        int outputUnmask = 1 << outputToMonitor - 1;
        this._followedOutputMask &= (outputUnmask ^= 0xFFFF);
        this._inputs[outputToMonitor - 1] = -1;
        int localOutputUnmask = 1 << localOutput - 1;
        this._usedOutputMask &= (localOutputUnmask ^= 0xFFFF);
        if (this._usedOutputMask == 0 && this.isRunning()) {
            this.stop();
        }
    }

    public void setFailedCommOutputState(int channel, String failedCommString) {
        System.out.println("set failed comm state for " + channel + " to " + failedCommString);
        if (!"hold-last-state".equals(failedCommString)) {
            this._failedOutputMask |= 1 << channel - 1;
            this._failedOutputStrings[channel - 1] = failedCommString;
        } else {
            this._failedOutputMask &= 0xFFFF ^ 1 << channel - 1;
        }
        System.out.println("_failedOutputMask: 0x" + Long.toHexString(this._failedOutputMask));
    }

    public boolean isRunning() {
        return this._running;
    }

    private void stop() {
        this._running = false;
    }

    protected void monitor() {
    }

    public abstract int trackInputs();

    public abstract int trackOutputs();
}

