/*
 * Decompiled with CFR 0.152.
 */
package SerialControl;

import SerialControl.CommandHandler;
import com.integpg.system.JANOS;
import integpg.EmbeddedHelpers.Base.EmbeddedBase;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

public class TcpServer
implements Runnable {
    private static final boolean DEBUG = false;
    public static String REG_SERVER_PORT = "/TcpPort";
    private static final int SERVER_PORT_DEFAULT = 9202;
    public static int SERVER_PORT = 9202;
    private ServerSocket svrSocket;
    private Socket socket;
    private Thread theServer;
    private boolean bServerRun = true;
    private EmbeddedBase base;

    public TcpServer(EmbeddedBase embeddedBase) {
        this.base = embeddedBase;
        REG_SERVER_PORT = "AppData/" + embeddedBase.name.replace(' ', '_') + REG_SERVER_PORT;
        System.out.println(REG_SERVER_PORT);
        SERVER_PORT = JANOS.getRegistryInt((String)REG_SERVER_PORT, (int)SERVER_PORT);
        if (SERVER_PORT == 9202) {
            JANOS.setRegistryString((String)REG_SERVER_PORT, (String)String.valueOf(SERVER_PORT));
        }
        embeddedBase.printInfo("Listen on port: " + SERVER_PORT);
        try {
            this.svrSocket = new ServerSocket(SERVER_PORT);
            this.theServer = new Thread(this);
            this.theServer.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stop() throws IOException {
        this.bServerRun = false;
        this.svrSocket.close();
        try {
            this.theServer.interrupt();
            this.theServer.join();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public void run() {
        try {
            while (this.bServerRun) {
                try {
                    System.out.println("Listening for clients on port " + SERVER_PORT + ".");
                    this.socket = this.svrSocket.accept();
                    System.out.println("Client connected");
                    Thread thread = new Thread(new CommandHandler(this.socket.getInputStream(), this.socket.getOutputStream(), this.socket));
                    thread.start();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    JANOS.syslog((String)iOException.getMessage());
                    JANOS.syslog((String)"Serial Control:\r\n                         There was a problem with the configuration of the tcp server.\r\n                         Please disconnect, fix the configuration, and try to connect again.");
                    this.bServerRun = false;
                    this.base.stopApp();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    JANOS.syslog((String)("Serial Control: " + exception.getMessage()));
                    this.base.stopApp();
                }
                System.gc();
            }
        }
        catch (Exception exception) {
            if (this.bServerRun) {
                exception.printStackTrace(System.out);
            }
            this.bServerRun = false;
        }
        try {
            this.svrSocket.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.svrSocket = null;
    }
}

