/*
 * Decompiled with CFR 0.152.
 */
package TaskManagerInterface;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.NumberFormat;
import java.util.Date;
import java.util.StringTokenizer;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TimePicker
extends JPanel {
    private static final boolean DEBUG = false;
    public ActionListener timeListener;
    private static final int MAX_HOUR = 24;
    private static final int MAX_ = 60;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JSpinner spinHours;
    private JSpinner spinMinutes;
    private JSpinner spinSeconds;

    public TimePicker() {
        this.initComponents();
    }

    public void setTime(long l) {
        Date date = new Date(l);
        int n = date.getHours();
        this.spinHours.getModel().setValue(new Integer(n));
        this.spinMinutes.getModel().setValue(new Integer(date.getMinutes()));
        this.spinSeconds.getModel().setValue(new Integer(date.getSeconds()));
    }

    public long getTimeMillis() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        String string = this.getTime();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.indexOf(":") <= 0) continue;
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ":");
            int n4 = 0;
            while (stringTokenizer2.hasMoreTokens()) {
                string2 = stringTokenizer2.nextToken();
                switch (n4) {
                    case 0: {
                        n = Integer.parseInt(string2);
                        break;
                    }
                    case 1: {
                        n2 = Integer.parseInt(string2);
                        break;
                    }
                    case 2: {
                        n3 = Integer.parseInt(string2);
                    }
                }
                ++n4;
            }
        }
        return n * 3600000 + n2 * 60000 + n3 * 1000;
    }

    public String getTime() {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMinimumIntegerDigits(2);
        return numberFormat.format(this.spinHours.getValue()) + ":" + numberFormat.format(this.spinMinutes.getValue()) + ":" + numberFormat.format(this.spinSeconds.getValue());
    }

    public void addTimeChangeListener(ActionListener actionListener) {
        this.timeListener = actionListener;
    }

    @Override
    public void setEnabled(boolean bl) {
        this.spinHours.setEnabled(bl);
        this.spinMinutes.setEnabled(bl);
        this.spinSeconds.setEnabled(bl);
    }

    private void initComponents() {
        this.spinHours = new JSpinner();
        this.jLabel1 = new JLabel();
        this.spinMinutes = new JSpinner();
        this.jLabel2 = new JLabel();
        this.spinSeconds = new JSpinner();
        this.jLabel3 = new JLabel();
        this.setLayout(new BoxLayout(this, 0));
        this.spinHours.setEditor(new JSpinner.NumberEditor(this.spinHours, "00"));
        this.spinHours.setModel(new SpinnerNumberModel(0, -1, 24, 1));
        this.spinHours.setMinimumSize(new Dimension(40, 20));
        this.spinHours.setPreferredSize(new Dimension(40, 20));
        this.spinHours.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                TimePicker.this.timeChanged(changeEvent);
            }
        });
        this.spinHours.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                TimePicker.this.keyTyped(keyEvent);
            }
        });
        this.add(this.spinHours);
        this.jLabel1.setText(" :");
        this.add(this.jLabel1);
        this.spinMinutes.setModel(new SpinnerNumberModel(0, -1, 60, 1));
        this.spinMinutes.setMinimumSize(new Dimension(40, 20));
        this.spinMinutes.setPreferredSize(new Dimension(40, 20));
        this.spinMinutes.setEditor(new JSpinner.NumberEditor(this.spinMinutes, "00"));
        this.spinMinutes.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                TimePicker.this.timeChanged(changeEvent);
            }
        });
        this.spinMinutes.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                TimePicker.this.keyTyped(keyEvent);
            }
        });
        this.add(this.spinMinutes);
        this.jLabel2.setText(" :");
        this.add(this.jLabel2);
        this.spinSeconds.setModel(new SpinnerNumberModel(0, -1, 60, 1));
        this.spinSeconds.setMinimumSize(new Dimension(40, 20));
        this.spinSeconds.setPreferredSize(new Dimension(40, 20));
        this.spinSeconds.setEditor(new JSpinner.NumberEditor(this.spinSeconds, "00"));
        this.spinSeconds.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                TimePicker.this.timeChanged(changeEvent);
            }
        });
        this.spinSeconds.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                TimePicker.this.keyTyped(keyEvent);
            }
        });
        this.add(this.spinSeconds);
        this.jLabel3.setText("  ");
        this.add(this.jLabel3);
    }

    private void keyTyped(KeyEvent keyEvent) {
        JSpinner jSpinner = (JSpinner)keyEvent.getSource();
        if (Integer.parseInt(jSpinner.getValue().toString() + keyEvent.getKeyChar()) > 59 || Integer.parseInt(jSpinner.getValue().toString() + keyEvent.getKeyChar()) < 0) {
            keyEvent.consume();
        }
    }

    private void timeChanged(ChangeEvent changeEvent) {
        JSpinner jSpinner = (JSpinner)changeEvent.getSource();
        if (jSpinner.equals(this.spinHours)) {
            if (Integer.parseInt(jSpinner.getValue().toString()) < 0) {
                jSpinner.getModel().setValue(new Integer(23));
            } else if (Integer.parseInt(jSpinner.getValue().toString()) == 24) {
                jSpinner.getModel().setValue(new Integer(0));
            }
        } else if (Integer.parseInt(jSpinner.getValue().toString()) == -1) {
            jSpinner.getModel().setValue(new Integer(59));
        } else if (Integer.parseInt(jSpinner.getValue().toString()) == 60) {
            jSpinner.getModel().setValue(new Integer(0));
        }
        if (this.timeListener != null) {
            this.timeListener.actionPerformed(new ActionEvent(this, 0, this.getTime()));
        }
    }
}

