/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.TaskManager;

import com.integpg.EmbeddedHelpers.Base.EmbeddedBase;
import java.io.IOException;

public class AnalogValueFromLogDevType {
    private static final int EXT_420mA = 0;
    private static final int EXT_10V = 1;
    private static final int AIN_420mA = 2;
    private static final int AOUT_420mA = 3;
    private static final int AIN_10V = 4;
    private static final int AOUT_10V = 5;
    private static final int ATEMP = 6;
    private static final int ARTD = 7;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double getAddressFromValue(int devtype, int channel) {
        int deviceIndex;
        String addressRegKey = null;
        if (devtype == 2) {
            deviceIndex = (channel - 1) / 4 + 1;
            addressRegKey = addressRegKey + "externals/deviceorder/typeFE_" + deviceIndex;
        } else if (devtype == 3) {
            deviceIndex = (channel - 1) / 2 + 1;
            addressRegKey = addressRegKey + "externals/deviceorder/typeFE_" + deviceIndex;
        } else if (devtype == 4) {
            deviceIndex = (channel - 1) / 4 + 1;
            addressRegKey = addressRegKey + "externals/deviceorder/typeFD_" + deviceIndex;
        } else if (devtype == 5) {
            deviceIndex = (channel - 1) / 2 + 1;
            addressRegKey = addressRegKey + "externals/deviceorder/typeFD_" + deviceIndex;
        } else if (devtype == 6) {
            addressRegKey = addressRegKey + "externals/deviceorder/type28_" + channel;
        } else if (devtype == 7) {
            deviceIndex = (channel - 1) / 4 + 1;
            addressRegKey = addressRegKey + "externals/deviceorder/typeFC_" + deviceIndex;
        }
        if (null == addressRegKey) return -1.0;
        String addressString = EmbeddedBase.BASE.m_jnioros.getRegistryString(addressRegKey, "");
        System.out.println(addressRegKey + " = " + addressString);
        if ("".equals(addressString)) return -1.0;
        try {
            long address = AnalogValueFromLogDevType.parseHex(addressString);
            byte[] bytes = EmbeddedBase.BASE.m_jnioros.readDeviceBlock(address);
            if (null != bytes && 0 == bytes.length) return -1.0;
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return -1.0;
    }

    public static long parseHex(String s) {
        if (s == null || s.length() != 16) {
            return 0L;
        }
        long l = Long.parseLong(s.substring(0, 8), 16);
        l <<= 32;
        return l += Long.parseLong(s.substring(8), 16);
    }
}

