/*
 * Decompiled with CFR 0.152.
 */
package TaskManagerInterface;

import JniorProtocol.Exceptions.CommandTimeoutException;
import JniorProtocol.Exceptions.NotLoggedInException;
import JniorProtocol.Exceptions.NotYetConnectedException;
import JniorProtocol.Helpers.Dialogs.LoginDialog;
import JniorProtocol.Listeners.RegistryListener;
import JniorProtocol.Properties.LoginProperties;
import JniorProtocol.Registry.Registry;
import JniorProtocol.Registry.RegistryKey;
import JniorProtocol.Registry.RegistryRequest;
import TaskManagerInterface.JniorProtocolWrapper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class RunningStatus
extends JPanel
implements RegistryListener {
    public static final String START_APP = "START the Application";
    public static final String STOP_APP = "STOP the Application";
    private static final boolean STATUS_CONTROL_ENABLED = true;
    private JniorProtocolWrapper wrapper;
    private String appName;
    private Timer watchdogTimer = null;
    private long watchdogMillis = 0L;
    private long lastWatchdogTime = 0L;
    private long lastWatchdogMillis = 0L;
    private String appControl = "START the Application";
    private JLabel lblStatus;

    public RunningStatus(JniorProtocolWrapper jniorProtocolWrapper, String string) {
        this.initComponents();
        this.lblStatus.setBackground(Color.RED);
        this.wrapper = jniorProtocolWrapper;
        this.appName = string;
    }

    public void monitorWatchdog() {
        try {
            Registry registry = this.wrapper.m_session.getRegistryInstance();
            RegistryRequest registryRequest = new RegistryRequest();
            registryRequest.addKey(registry.getRegKey("AppData/" + this.appName + "/$Watchdog", "0"));
            registryRequest.addKey(registry.getRegKey("AppData/" + this.appName + "/$Quit", "0"));
            registryRequest.addRegistryListener(this);
            registry.subscribeRegistry(registryRequest);
        }
        catch (CommandTimeoutException commandTimeoutException) {
            commandTimeoutException.printStackTrace();
        }
        catch (NotYetConnectedException notYetConnectedException) {
            notYetConnectedException.printStackTrace();
        }
        if (this.watchdogTimer == null) {
            this.watchdogTimer = new Timer(1500, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        if (System.currentTimeMillis() - RunningStatus.this.lastWatchdogTime <= 120000L && RunningStatus.this.lastWatchdogMillis != 0L) {
                            RunningStatus.this.appControl = RunningStatus.STOP_APP;
                            if (RunningStatus.this.lblStatus.getBackground() == Color.GREEN) {
                                RunningStatus.this.lblStatus.setBackground(Color.WHITE);
                            } else {
                                RunningStatus.this.lblStatus.setBackground(Color.GREEN);
                            }
                        } else {
                            RunningStatus.this.appControl = RunningStatus.START_APP;
                            RunningStatus.this.lblStatus.setBackground(Color.RED);
                        }
                        if (RunningStatus.this.watchdogMillis != RunningStatus.this.lastWatchdogMillis) {
                            if (RunningStatus.this.lastWatchdogMillis != 0L) {
                                RunningStatus.this.lastWatchdogTime = System.currentTimeMillis();
                            }
                            RunningStatus.this.lastWatchdogMillis = RunningStatus.this.watchdogMillis;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        numberFormatException.printStackTrace();
                    }
                }
            });
        }
        this.watchdogTimer.start();
    }

    private void initComponents() {
        this.lblStatus = new JLabel();
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createBevelBorder(1));
        this.setMinimumSize(new Dimension(75, 20));
        this.setPreferredSize(new Dimension(75, 20));
        this.lblStatus.setHorizontalAlignment(0);
        this.lblStatus.setText("status");
        this.lblStatus.setOpaque(true);
        this.lblStatus.setPreferredSize(new Dimension(30, 20));
        this.lblStatus.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                RunningStatus.this.lblStatusMouseReleased(mouseEvent);
            }
        });
        this.add((Component)this.lblStatus, "Center");
    }

    private void lblStatusMouseReleased(MouseEvent mouseEvent) {
        if (!mouseEvent.isPopupTrigger()) {
            return;
        }
        Object object = mouseEvent.getSource();
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(STOP_APP);
        jMenuItem.setEnabled(this.appControl.equals(STOP_APP));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (JOptionPane.showConfirmDialog(RunningStatus.this.wrapper, "Are you sure you want to stop the " + RunningStatus.this.appName + " application?", "Stop " + RunningStatus.this.appName, 0) == 1) {
                    return;
                }
                ((RunningStatus)RunningStatus.this).wrapper.m_details.setStatusText("Stopping " + RunningStatus.this.appName);
                ((RunningStatus)RunningStatus.this).wrapper.m_blur.setVisible(true);
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ((RunningStatus)RunningStatus.this).wrapper.m_session.getRegistryInstance().writeRegistry("AppData/" + RunningStatus.this.appName + "/$Quit", "true");
                        }
                        catch (CommandTimeoutException commandTimeoutException) {
                            commandTimeoutException.printStackTrace();
                        }
                        catch (NotYetConnectedException notYetConnectedException) {
                            notYetConnectedException.printStackTrace();
                        }
                        catch (NotLoggedInException notLoggedInException) {
                            notLoggedInException.printStackTrace();
                        }
                        while (!RunningStatus.this.appControl.equals(RunningStatus.START_APP)) {
                            try {
                                Thread.sleep(50L);
                            }
                            catch (InterruptedException interruptedException) {
                                interruptedException.printStackTrace();
                            }
                        }
                        ((RunningStatus)RunningStatus.this).wrapper.m_blur.setVisible(false);
                    }
                }).start();
            }
        });
        jPopupMenu.add(jMenuItem);
        jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
    }

    private LoginProperties promptForLogin() {
        LoginProperties loginProperties = null;
        try {
            Window window = SwingUtilities.getWindowAncestor(this);
            LoginDialog loginDialog = null;
            loginDialog = window instanceof Frame ? new LoginDialog((Frame)window, true) : new LoginDialog((Dialog)window, true);
            loginDialog.centerParent();
            loginDialog.setVisible(true);
            if (loginDialog.getResult() == 1) {
                loginProperties = new LoginProperties(loginDialog.getUsername(), loginDialog.getPassword());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return loginProperties;
    }

    @Override
    public void onRegistryKeyReceived(EventObject eventObject, RegistryKey registryKey) {
        if (registryKey.getKey().indexOf("/$Watchdog") >= 0 && !registryKey.getValue().equals("")) {
            this.watchdogMillis = Long.parseLong(registryKey.getValue());
            if (System.currentTimeMillis() - this.watchdogMillis <= 120000L && this.appControl.equals(START_APP)) {
                this.appControl = STOP_APP;
                this.lastWatchdogTime = this.lastWatchdogMillis = this.watchdogMillis;
                this.lblStatus.setBackground(Color.GREEN);
            }
        }
    }

    @Override
    public void onRegistryListReceived(EventObject eventObject, String string, String[] stringArray) {
    }
}

