 /*
  JNIOR Monitor/Configuration Page
  INTEG Process Group, Inc., 2919 E Hardies Rd, Gibsonia PA 
  724.933.9350
  
  File: temperature.js
  
  The user is hereby granted license to use, modify, and redistribute the contents of this
  file for any purpose, commercial or otherwise. No prior authorization by INTEG Process 
  Group, Inc. is required.
*/ 

// Function returns float from hex string (temperature sensore status)
function getFloat(str) {
	var buffer = new ArrayBuffer(8);
	var view = new DataView(buffer);
	for (i = 0; i < 8; i++)
		view.setUint8(i, parseInt(str.substr(2 * i, 2), 16));
	return view.getFloat64(0);
}

// Function returns HTML for a Temperature Sensor
function device_temp(key) {
	var id = module_keyToId[key];
	var idn = "temp:" + id;

	var modkey = "externals/" + id.toLowerCase() + "/";
	var desc_key = modkey + "Desc";
	var desc = getkey(desc_key, "Temperature Sensor");
	
	// Status returns 16 character hex representation of 8-byte double which
	//  is a 64 bit IEEE 754 double precision Floating Point Number. 
	var status = module_idToStatus[id];
	var tread = getFloat(status);
	var celsius = tread.toFixed(1);
	var fahrenheit = (9 * tread / 5 + 32.0).toFixed(1);
	
	var fahr = istrue(getkey(modkey + "Fahrenheit", "false"));
	
	var inner = "<td name='temp'>";
	inner += "<p class='modname' name='" + keystd(desc_key) + "'>" + desc + "</span></p>";
	inner += "<p class='modaddr'>" + id + "</p>";
	inner += "<div class='modio' id='" + idn + "'>";
	if (fahr) {
		inner += "<div class='temperature'>" + fahrenheit + "</div><div class='degrees'>&deg;F</div>";
		inner += "<div class='alttemp'>" + celsius + "&deg;C</div>";
	}
	else {
		inner += "<div class='temperature'>" + celsius + "</div><div class='degrees'>&deg;C</div>";
		inner += "<div class='alttemp'>" + fahrenheit + "&deg;F</div>";
	}
	inner += "</div>";
	inner += "</td>";
	return inner;
}

// Updates the Temperature Sensor block

function update_temp(key) {
	var id = module_keyToId[key];
	var idn = "temp:" + id;

	var modkey = "externals/" + id.toLowerCase() + "/";
	var fahr = istrue(getkey(modkey + "Fahrenheit", "false"));

	// Status returns 16 character hex representation of 8-byt double which
	//  is a 64 bit IEEE 754 double precision Floating Point Number. 
	var status = module_idToStatus[id];
	var tread = getFloat(status);
	var celsius = tread.toFixed(1);
	var fahrenheit = (9 * tread / 5 + 32.0).toFixed(1);

	var elem = document.getElementById(idn);
	if (elem) {
		if (fahr) {
			var inner = "<div class='temperature' style='width:60%;'>" + fahrenheit + "</div><div class='degrees'>&deg;F</div>";
			inner += "<div class='alttemp'>" + celsius + "&deg;C</div>";
			elem.innerHTML = inner;
		}
		else {
			var inner = "<div class='temperature' style='width:60%;'>" + celsius + "</div><div class='degrees'>&deg;C</div>";
			inner += "<div class='alttemp'>" + fahrenheit + "&deg;F</div>";
			elem.innerHTML = inner;
		}
	}
		
	return false;
	
}

// Updates the Environment Sensor block
//
// Status returns 6 bytes (hex string length 12)
//		Byte 	Len			Data
//		0			2				ID
//		2			2				Temperature
//		4			2				Humidity
//
// Temperature/Humidity Register Format (Type 0x7E)
//
//    	  BIT7   BIT6   BIT5   BIT4   BIT3   BIT2   BIT1   BIT0
//   		+------+------+------+------+------+------+------+------+
// LSB	| 2^3  | 2^2  | 2^1  | 2^0  | 2^-1 | 2^-2 | 2^-3 | 2^-4 |
//	   	+------+------+------+------+------+------+------+------+
//
//    	  BIT7   BIT6   BIT5   BIT4   BIT3   BIT2   BIT1   BIT0
//  	 	+------+------+------+------+------+------+------+------+
// MSB	|  S   |  S   |  S   |  S   |  S   | 2^6  | 2^5  | 2^4  |
//   		+------+------+------+------+------+------+------+------+

function update_env(key) {
	var id = module_keyToId[key];
	var idn = "temp:" + id;

	var modkey = "externals/" + id.toLowerCase() + "/";
	var fahr = istrue(getkey(modkey + "Fahrenheit", "false"));

	var status = module_idToStatus[id];
	var raw = parseInt(status.substr(4, 4), 16);
	if (raw > 32767)
		raw -= 65536; 
	var reading = raw / 16;
	var celsius = reading.toFixed(1);
	var fahrenheit = (9 * reading / 5 + 32.0).toFixed(1);
	
	var raw = parseInt(status.substr(8, 4), 16);
	var reading = raw / 16;
	var humidity = reading.toFixed(0);

	var elem = document.getElementById(idn);
	if (elem) {
		if (fahr) {
			var inner = "<div class='humidity'>" + humidity + "% RH</div>";
			inner += "<div class='temperature' style='width:40%;'>" + fahrenheit + "</div><div class='degrees'>&deg;F</div>";
			inner += "<div class='alttemp'>" + celsius + "&deg;C</div>";
			elem.innerHTML = inner;
		}
		else {
			var inner = "<div class='humidity'>" + humidity + "% RH</div>";
			inner += "<div class='temperature' style='width:40%;'>" + celsius + "</div><div class='degrees'>&deg;C</div>";
			inner += "<div class='alttemp'>" + fahrenheit + "&deg;F</div>";
			elem.innerHTML = inner;
		}
	}
		
	return false;
}