/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.TaskManager.Event;

import com.dalsemi.system.TINIOS;
import com.integpg.EmbeddedHelpers.Base.EmbeddedBase;
import com.integpg.EmbeddedHelpers.Time.QuickTime;
import com.integpg.TaskManager.Event.EventData;
import com.integpg.TaskManager.ExternalModuleFromEventBasedTypeKey;
import com.integpg.TaskManager.TaskListener;
import com.integpg.TaskManager.TaskManager;
import com.integpg.TaskManager.UnitConfig;
import com.integpg.TaskManager.externals.ExternalChannelInfo;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Calendar;
import java.util.Date;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class Event {
    private static RandomAccessFile fw = null;
    private static final int ACTION_TOKEN = 0;
    private static final int CHANNEL_TOKEN = 1;
    private static final int EXT_420mA = 0;
    private static final int EXT_10V = 1;
    public static final int EXT_10V_ID = 253;
    public static final int EXT_420mA_ID = 254;
    private static final int AIN_420mA = 2;
    private static final int AOUT_420mA = 3;
    private static final int AIN_10V = 4;
    private static final int AOUT_10V = 5;
    private static final int ATEMP = 6;
    private static final int ARTD = 7;
    private static final boolean IN = false;
    private static final boolean OUT = true;
    private static final double maxxy = 65520.0;
    private EventData ed;
    private long eventStartTime;
    private int[] exts;
    private final TaskListener _taskListener;
    private Thread _thd = null;
    private boolean _quit = false;
    private static long tRef = 0L;
    private static String sPrefix = null;

    public Event(TaskListener listener) {
        this._taskListener = listener;
    }

    public void triggerEvent() {
        this._taskListener.taskStarted(this);
        int totalTokens = 50;
        String otherAction = "";
        long SystemTime = QuickTime.getTimeMillis();
        System.out.println("\r\nEvent " + this.ed.name + " triggered at " + Event.getDateStamp(SystemTime));
        System.out.println(this.ed.actionCount);
        for (int actionCount = 0; actionCount < this.ed.actionCount && !this._quit; ++actionCount) {
            String actionToken = this.ed.actions[actionCount];
            int mandatoryToken = 0;
            String action = null;
            int time = -1;
            boolean mask = false;
            boolean random = false;
            String io = null;
            int channelMask = -1;
            int channelNumber = 0;
            String fileName = null;
            int fileMax = 32;
            String opts = null;
            String format = null;
            String profile = null;
            long analogValue = 0L;
            StringTokenizer tokenizerTokens = new StringTokenizer(actionToken, " ");
            try {
                while (tokenizerTokens.hasMoreTokens() && totalTokens-- > 0) {
                    block55: {
                        String token = tokenizerTokens.nextToken().trim().toLowerCase();
                        System.out.println("token: " + token);
                        if (token.charAt(0) == '-') {
                            --mandatoryToken;
                            if (token.equals("-mask")) {
                                mask = true;
                            } else if (token.equals("-rnd")) {
                                random = true;
                            } else if (token.equals("-time")) {
                                time = Integer.parseInt(tokenizerTokens.nextToken());
                            } else if (token.equals("-file")) {
                                fileName = tokenizerTokens.nextToken();
                            } else if (token.equals("-max")) {
                                fileMax = Integer.parseInt(tokenizerTokens.nextToken());
                                if (fileMax > 150) {
                                    fileMax = 150;
                                }
                            } else if (token.equals("-opts")) {
                                opts = tokenizerTokens.nextToken();
                            } else if (token.equals("-format")) {
                                format = tokenizerTokens.nextToken();
                            } else if (token.equals("-profile")) {
                                profile = tokenizerTokens.nextToken();
                            } else if (token.equals("-dev")) {
                                io = tokenizerTokens.nextToken();
                                channelMask = io.equals("mA") ? 0 : 1;
                            } else if (token.equals("-chan")) {
                                channelNumber = Integer.parseInt(tokenizerTokens.nextToken());
                            } else if (token.equals("-val")) {
                                analogValue = Long.parseLong(tokenizerTokens.nextToken());
                            } else {
                                if (token.equals("-delay")) {
                                    int delayTime = Integer.parseInt(tokenizerTokens.nextToken());
                                    try {
                                        Thread.sleep(delayTime * 1000);
                                        if (!this._quit) break block55;
                                        break;
                                    }
                                    catch (InterruptedException iex) {
                                        break block55;
                                    }
                                }
                                if (token.equals("-action")) {
                                    StringBuilder sb = new StringBuilder();
                                    while (tokenizerTokens.hasMoreTokens()) {
                                        if (0 < sb.length()) {
                                            sb.append(" ");
                                        }
                                        String nextToken = tokenizerTokens.nextToken();
                                        System.out.println("   token: " + nextToken);
                                        sb.append(nextToken);
                                        if (!nextToken.endsWith("'")) continue;
                                        break;
                                    }
                                    otherAction = sb.toString();
                                }
                            }
                        } else {
                            switch (mandatoryToken) {
                                case 0: {
                                    action = token;
                                    if (!action.equals("execute")) break;
                                    totalTokens = 0;
                                    break;
                                }
                                case 1: {
                                    io = token;
                                    channelNumber = Integer.parseInt(tokenizerTokens.nextToken());
                                    if (random) {
                                        if (mask) {
                                            channelNumber = (int)(Math.random() * 65535.0 % 65535.0) & channelNumber;
                                        } else {
                                            channelNumber = (int)(Math.random() * 65535.0 % 16.0) & channelNumber;
                                            channelMask = 1 << channelNumber - 1;
                                        }
                                    }
                                    channelMask = mask ? channelNumber : 1 << channelNumber - 1;
                                }
                            }
                        }
                    }
                    ++mandatoryToken;
                }
            }
            catch (NumberFormatException ex) {
                System.out.println(actionToken);
                System.out.println(tokenizerTokens.toString());
                ex.printStackTrace(System.out);
            }
            if (this._quit) break;
            EmbeddedBase.BASE.log("  [" + this.ed.name + "] action: " + actionToken);
            if (action.equals("log")) {
                int inStates = 0;
                int outStates = 0;
                try {
                    inStates = EmbeddedBase.BASE.m_jnioros.getInputStates();
                    outStates = EmbeddedBase.BASE.m_jnioros.getOutputStates();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace(System.out);
                }
                System.out.println(outStates);
                Event.doLog(fileName, fileMax, format, mask, io, channelMask, Event.getDateStamp(SystemTime), inStates, outStates);
                continue;
            }
            if (action.equals("analog")) {
                this.doAnalog(channelMask, channelNumber, analogValue);
                continue;
            }
            if (action.equals("reset")) {
                Event.doReset(opts.toLowerCase(), io, channelMask);
                continue;
            }
            if (action.equals("email")) {
                if (profile.equals("<default>")) {
                    profile = "";
                }
                EmbeddedBase.BASE.m_jnioros.sendMail(profile, "Scheduler", "Please define a subject and body in your email profile.");
                continue;
            }
            if (action.equals("other")) {
                if (otherAction.startsWith("'")) {
                    otherAction = otherAction.substring(1);
                }
                if (otherAction.endsWith("'")) {
                    otherAction = otherAction.substring(0, otherAction.length() - 1);
                }
                Runtime runtime = Runtime.getRuntime();
                try {
                    System.out.println("execute " + otherAction);
                    Process process = runtime.exec(otherAction);
                    process.waitFor();
                    System.out.println(otherAction + " done");
                }
                catch (Exception ex) {
                    EmbeddedBase.BASE.logError("Error executing other action: " + otherAction, ex);
                }
                continue;
            }
            Event.doAction(action, time, channelMask);
        }
        if (this._quit) {
            System.out.println(this.ed.name + " has been aborted.");
            EmbeddedBase.BASE.log(this.ed.name + " has been aborted.");
        }
        this._taskListener.taskCompleted(this);
    }

    public void doAnalog(int device, int channel, long value) {
        this.exts = TaskManager.exts;
        int extoff = 0;
        int halfmax = 3;
        if (device == 0) {
            if ((this.exts[1] != 254 || this.exts[0] != 254) && channel > halfmax) {
                extoff = halfmax + 1;
            } else if (channel > halfmax) {
                extoff = 2;
            }
            try {
                EmbeddedBase.BASE.m_jnioros.set420Out(channel - extoff, (double)value / 1000.0);
            }
            catch (IOException iex) {}
        } else if (device == 1) {
            if ((this.exts[1] != 253 || this.exts[0] != 253) && channel > halfmax) {
                extoff = halfmax + 1;
            } else if (channel > halfmax) {
                extoff = 2;
            }
            try {
                EmbeddedBase.BASE.m_jnioros.set10vOut(channel - extoff, (double)value / 1000.0);
            }
            catch (IOException iex) {
                // empty catch block
            }
        }
    }

    public void doEvent(final EventData ed) {
        this.ed = ed;
        long dayTime = TaskManager.getDayTime();
        if (ed.time > dayTime) {
            EmbeddedBase.BASE.log("Too early in day to execute " + ed.name + " task");
            return;
        }
        if (-1L != ed.endTime && ed.endTime < dayTime) {
            EmbeddedBase.BASE.log("Too late in day to execute " + ed.name + " task");
            return;
        }
        if (ed.action.equals("")) {
            EmbeddedBase.BASE.log(ed.name + " does not have any actions assigned");
            return;
        }
        EmbeddedBase.BASE.log("Executing " + ed.name + " task");
        this._thd = new Thread(new Runnable(){

            @Override
            public void run() {
                Thread.currentThread().setName("DoEvent_" + ed.name);
                Event.this.eventStartTime = TINIOS.uptimeMillis();
                try {
                    Event.this.triggerEvent();
                }
                catch (Exception e) {
                    EmbeddedBase.BASE.logError("Error triggering event: " + ed.toString(), e);
                }
                System.out.println(TINIOS.uptimeMillis() - Event.this.eventStartTime + " milliseconds");
                Event.this._thd = null;
            }
        });
        this._thd.start();
    }

    private static void doAction(String action, int time, int channelMask) {
        boolean valid = false;
        try {
            int relayStates = 0;
            if (action.indexOf("pulse") >= 0) {
                if (action.indexOf("hi") >= 0) {
                    relayStates = 65535;
                }
                if (!EmbeddedBase.BASE.m_jnioros.setOutputPulsed(relayStates, channelMask, time)) {
                    EmbeddedBase.BASE.log("Output Pulsed FAILED");
                }
                return;
            }
            if (action.equals("count")) {
                relayStates = EmbeddedBase.BASE.m_jnioros.getOutputStates();
                ++relayStates;
                valid = true;
            } else if (action.equals("toggle")) {
                relayStates = EmbeddedBase.BASE.m_jnioros.getOutputStates();
                relayStates ^= 0xFFFF;
                valid = true;
            } else if (action.equals("close")) {
                relayStates = 65535;
                valid = true;
            } else if (action.equals("open")) {
                relayStates = 0;
                valid = true;
            }
            if (valid) {
                EmbeddedBase.BASE.m_jnioros.setOutputStates(relayStates, channelMask);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace(System.out);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ie) {
                ie.printStackTrace(System.out);
            }
        }
    }

    private static void doReset(String opts, String io, int channelMask) {
        try {
            System.out.println("Resetting " + opts + " " + io + " " + channelMask);
            for (int i = 1; i <= 8; ++i) {
                System.out.println(i + " " + (channelMask & 1));
                if ((channelMask & 1) != 0) {
                    if (opts.indexOf("usage") >= 0) {
                        System.out.println("Resetting usage " + io + " " + channelMask);
                        int iUsage = io.equals("rout") ? i + UnitConfig.InputCount : i;
                        double usage = EmbeddedBase.BASE.m_jnioros.getUsageMeter(iUsage - 1);
                        EmbeddedBase.BASE.m_jnioros.resetUsageMeter(iUsage - 1);
                        usage = EmbeddedBase.BASE.m_jnioros.getUsageMeter(iUsage - 1);
                    }
                    if (opts.indexOf("counter") >= 0) {
                        System.out.println("Resetting counter " + io + " " + channelMask);
                        EmbeddedBase.BASE.m_jnioros.resetInputCounter(i - 1);
                    }
                }
                channelMask >>= 1;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace(System.out);
        }
    }

    public static synchronized RandomAccessFile open(String fileName, int max) {
        return Event.open(fileName, max, true);
    }

    public static synchronized RandomAccessFile open(String fileName, int max, boolean tryAgain) {
        RandomAccessFile SysLog;
        block6: {
            SysLog = null;
            try {
                SysLog = new RandomAccessFile(fileName, "rw");
                if (SysLog.length() >= (long)(max * 1024)) {
                    SysLog.close();
                    try {
                        EmbeddedBase.BASE.m_jnioros.backupFile(fileName);
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    SysLog = new RandomAccessFile(fileName, "rw");
                }
                SysLog.seek(SysLog.length());
            }
            catch (IOException ioe) {
                Event.close(fw);
                EmbeddedBase.BASE.logError("Unable to open " + fileName, ioe);
                ioe.printStackTrace(System.out);
                if (ioe.getClass() != FileNotFoundException.class || !tryAgain) break block6;
                String path = fileName.substring(0, fileName.lastIndexOf("/") + 1);
                System.out.println("Making sure the directory, " + path + ", exists for our file.");
                new File(path).mkdirs();
                SysLog = Event.open(fileName, max, false);
            }
        }
        return SysLog;
    }

    private static synchronized void close(RandomAccessFile raf) {
        try {
            if (raf != null) {
                raf.close();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace(System.out);
        }
    }

    public static void doLog(String fileName, int max, String format, boolean mask, String io, int channelMask, String time, int inStates, int outStates) {
        String line = "";
        int totalTokens = 50;
        try {
            int end;
            char next;
            int tdev;
            int channelNumber;
            String token;
            int pos;
            if (fileName.equals("")) {
                fileName = "log.dat";
            }
            if (fileName.charAt(0) != '/') {
                fileName = "/" + fileName;
            }
            if ((pos = fileName.indexOf("%minute%")) >= 0) {
                Calendar cal = Calendar.getInstance();
                cal.setTimeInMillis(QuickTime.getTimeMillis());
                String minute = "00" + cal.get(12);
                minute = minute.substring(minute.length() - 2);
                fileName = fileName.substring(0, pos) + minute + fileName.substring(pos + 8);
            }
            System.out.println(fileName);
            fw = Event.open(fileName, max);
            if (fw == null) {
                return;
            }
            StringTokenizer st = new StringTokenizer(format, "%");
            if (fw.getFilePointer() == 0L) {
                while (st.hasMoreTokens() && totalTokens-- > 0) {
                    token = st.nextToken();
                    try {
                        if (token.toLowerCase().equals("timestamp")) {
                            token = "DateTime";
                        } else if (token.toLowerCase().equals("milliseconds")) {
                            token = "Milliseconds";
                        } else if (token.toLowerCase().indexOf("din") == 0) {
                            channelNumber = Integer.parseInt(token.substring(3, 4));
                            token = "InputState" + channelNumber;
                        } else if (token.toLowerCase().indexOf("rout") == 0) {
                            channelNumber = Integer.parseInt(token.substring(4));
                            System.out.println("token=" + token + " channelNumber=" + channelNumber);
                            token = "OutputState" + channelNumber;
                        } else if (token.toLowerCase().indexOf("uin") == 0) {
                            channelNumber = Integer.parseInt(token.substring(3, 4));
                            token = "InputUsage" + channelNumber;
                        } else if (token.toLowerCase().indexOf("uout") == 0) {
                            channelNumber = Integer.parseInt(token.substring(4, 5));
                            token = "OutputUsage" + channelNumber;
                        } else if (token.toLowerCase().indexOf("cin") == 0) {
                            channelNumber = Integer.parseInt(token.substring(3, 4));
                            token = "Counter" + channelNumber;
                        } else if (token.toLowerCase().indexOf("ext") == 0) {
                            boolean ttype = true;
                            tdev = -1;
                            next = token.charAt(3);
                            if (token.charAt(3) == 'i') {
                                ttype = false;
                            } else if (token.charAt(3) == 'o') {
                                ttype = true;
                            }
                            next = token.charAt(4);
                            next = Character.toLowerCase(next);
                            if (next == 'a') {
                                tdev = ttype ? 3 : 2;
                            } else if (next == 'r') {
                                tdev = 7;
                            } else if (next == 't') {
                                tdev = 6;
                            } else if (next == 'v') {
                                tdev = ttype ? 5 : 4;
                            }
                            channelNumber = Integer.parseInt(token.substring(5, 6));
                            String description = Event.getDescriptionFromNumber(tdev, channelNumber - 1);
                            if (null == description) {
                                String sttype = "N/A";
                                String stdev = "N/A";
                                next = token.charAt(3);
                                if (token.charAt(3) == 'i') {
                                    sttype = "In";
                                } else if (token.charAt(3) == 'o') {
                                    sttype = "Out";
                                }
                                next = token.charAt(4);
                                next = Character.toLowerCase(next);
                                if (next == 'a') {
                                    stdev = "_4-20mA_";
                                } else if (next == 'r') {
                                    stdev = "_RTD_";
                                } else if (next == 't') {
                                    stdev = "_Temp_";
                                } else if (next == 'v') {
                                    stdev = "_10V_";
                                }
                                token = "External" + stdev + sttype + channelNumber;
                            } else {
                                token = description;
                            }
                        } else if (token.length() > 5) {
                            int begin = token.indexOf(",");
                            if (begin >= 0) {
                                end = token.lastIndexOf(",");
                                if (begin != end) {
                                    token = token.substring(begin, end + 1);
                                }
                            } else {
                                token = EmbeddedBase.BASE.m_jnioros.getRegistryString(token, "");
                            }
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    line = line + token;
                    System.out.println("line: " + line);
                }
                fw.write((line + "\r\n").getBytes());
            }
            line = new String();
            st = new StringTokenizer(format, "%");
            while (st.hasMoreTokens() && totalTokens-- > 0) {
                block83: {
                    token = st.nextToken();
                    try {
                        if (token.toLowerCase().equals("timestamp")) {
                            token = time;
                            break block83;
                        }
                        if (token.toLowerCase().equals("milliseconds")) {
                            token = String.valueOf(QuickTime.getTimeMillis());
                            break block83;
                        }
                        if (token.toLowerCase().indexOf("din") == 0) {
                            channelNumber = Integer.parseInt(token.substring(3, 4));
                            token = String.valueOf(inStates >> channelNumber - 1 & 1);
                            break block83;
                        }
                        if (token.toLowerCase().indexOf("rout") == 0) {
                            channelNumber = Integer.parseInt(token.substring(4));
                            System.out.println("token=" + token + " Out states: " + outStates + " channelNumber=" + channelNumber);
                            token = String.valueOf(outStates >> channelNumber - 1 & 1);
                            break block83;
                        }
                        if (token.toLowerCase().indexOf("uin") == 0) {
                            channelNumber = Integer.parseInt(token.substring(3, 4)) - 1;
                            token = String.valueOf(EmbeddedBase.BASE.m_jnioros.getUsageMeter(channelNumber));
                            break block83;
                        }
                        if (token.toLowerCase().indexOf("uout") == 0) {
                            channelNumber = Integer.parseInt(token.substring(4, 5)) - 1;
                            token = String.valueOf(EmbeddedBase.BASE.m_jnioros.getUsageMeter(channelNumber + UnitConfig.InputCount));
                            break block83;
                        }
                        if (token.toLowerCase().indexOf("cin") == 0) {
                            channelNumber = Integer.parseInt(token.substring(3, 4)) - 1;
                            token = String.valueOf(EmbeddedBase.BASE.m_jnioros.getInputCounter(channelNumber));
                            break block83;
                        }
                        if (token.toLowerCase().indexOf("ext") == 0) {
                            boolean ttype = true;
                            tdev = -1;
                            next = token.charAt(3);
                            if (token.charAt(3) == 'i') {
                                ttype = false;
                            } else if (token.charAt(3) == 'o') {
                                ttype = true;
                            }
                            next = token.charAt(4);
                            next = Character.toLowerCase(next);
                            if (next == 'a') {
                                tdev = ttype ? 3 : 2;
                            } else if (next == 'r') {
                                tdev = 7;
                            } else if (next == 't') {
                                tdev = 6;
                            } else if (next == 'v') {
                                tdev = ttype ? 5 : 4;
                            }
                            channelNumber = Integer.parseInt(token.substring(5, 6));
                            try {
                                double analog = (double)((long)(Event.getIOFromNumber(tdev, channelNumber - 1) * 1000.0)) / 1000.0;
                                System.out.println("Analog: " + analog);
                                if (analog != -1.0) {
                                    String fix1 = Long.toString((long)analog);
                                    String fix2 = Double.toString(Math.abs(analog - (double)((long)analog)));
                                    if (fix2.length() > 1) {
                                        token = fix2.length() < 5 ? fix1 + fix2.substring(1) : fix1 + fix2.substring(1, 5);
                                    }
                                    break block83;
                                }
                                token = "N/A";
                            }
                            catch (IOException iex) {
                                iex.printStackTrace();
                                token = "Device Error";
                            }
                            break block83;
                        }
                        if (token.length() > 5) {
                            int begin = token.indexOf(",");
                            if (begin >= 0) {
                                end = token.lastIndexOf(",");
                                if (begin != end) {
                                    token = token.substring(begin, end + 1);
                                }
                            } else {
                                token = EmbeddedBase.BASE.m_jnioros.getRegistryString(token, "");
                            }
                        }
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                line = line + token;
            }
            fw.write((line + "\r\n").getBytes());
            Event.close(fw);
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace(System.out);
        }
        catch (IOException ioe) {
            ioe.printStackTrace(System.out);
        }
        catch (NoSuchElementException nsee) {
            nsee.printStackTrace(System.out);
        }
    }

    private static String getDescriptionFromNumber(int devtype, int channel) throws IOException {
        int ioNumber;
        ExternalChannelInfo externalChannelInfo = null;
        String registryKey = "externals/";
        if (devtype == 2) {
            ioNumber = 64 + channel + 1;
            externalChannelInfo = ExternalModuleFromEventBasedTypeKey.getExternalModuleFromIoNumber(ioNumber);
            registryKey = registryKey + externalChannelInfo.getAddressString() + "/ain" + externalChannelInfo.getChannel() + "/desc";
        } else if (devtype == 3) {
            ioNumber = 72 + channel + 1;
            externalChannelInfo = ExternalModuleFromEventBasedTypeKey.getExternalModuleFromIoNumber(ioNumber);
            registryKey = registryKey + externalChannelInfo.getAddressString() + "/aout" + externalChannelInfo.getChannel() + "/desc";
        } else if (devtype == 4) {
            ioNumber = 48 + channel + 1;
            externalChannelInfo = ExternalModuleFromEventBasedTypeKey.getExternalModuleFromIoNumber(ioNumber);
            registryKey = registryKey + externalChannelInfo.getAddressString() + "/ain" + externalChannelInfo.getChannel() + "/desc";
        } else if (devtype == 5) {
            ioNumber = 56 + channel + 1;
            externalChannelInfo = ExternalModuleFromEventBasedTypeKey.getExternalModuleFromIoNumber(ioNumber);
            registryKey = registryKey + externalChannelInfo.getAddressString() + "/aout" + externalChannelInfo.getChannel() + "/desc";
        } else if (devtype == 6) {
            ioNumber = 24 + channel + 1;
            externalChannelInfo = ExternalModuleFromEventBasedTypeKey.getExternalModuleFromIoNumber(ioNumber);
            registryKey = registryKey + externalChannelInfo.getAddressString() + "/desc";
        } else if (devtype == 7) {
            // empty if block
        }
        if (null != externalChannelInfo) {
            String addressString = externalChannelInfo.getAddressString();
            System.out.println("get description for " + addressString + " channel " + externalChannelInfo.getChannel());
            System.out.println(registryKey);
            String description = EmbeddedBase.BASE.m_jnioros.getRegistryString(registryKey, null);
            System.out.println("description: " + description);
            return description;
        }
        return null;
    }

    private static double getIOFromNumber(int devtype, int channel) throws IOException {
        if (devtype == 2) {
            int ioNumber = 64 + channel + 1;
            ExternalChannelInfo externalChannelInfo = ExternalModuleFromEventBasedTypeKey.getExternalModuleFromIoNumber(ioNumber);
            externalChannelInfo.refreshDevice();
            double analog = externalChannelInfo.getScaledValue();
            return analog;
        }
        if (devtype == 3) {
            int ioNumber = 72 + channel + 1;
            ExternalChannelInfo externalChannelInfo = ExternalModuleFromEventBasedTypeKey.getExternalModuleFromIoNumber(ioNumber);
            externalChannelInfo.refreshDevice();
            double analog = externalChannelInfo.getScaledValue();
            return analog;
        }
        if (devtype == 4) {
            int ioNumber = 48 + channel + 1;
            ExternalChannelInfo externalChannelInfo = ExternalModuleFromEventBasedTypeKey.getExternalModuleFromIoNumber(ioNumber);
            externalChannelInfo.refreshDevice();
            double analog = externalChannelInfo.getScaledValue();
            return analog;
        }
        if (devtype == 5) {
            int ioNumber = 56 + channel + 1;
            ExternalChannelInfo externalChannelInfo = ExternalModuleFromEventBasedTypeKey.getExternalModuleFromIoNumber(ioNumber);
            externalChannelInfo.refreshDevice();
            double analog = externalChannelInfo.getScaledValue();
            return analog;
        }
        if (devtype == 6) {
            int ioNumber = 24 + channel + 1;
            ExternalChannelInfo externalChannelInfo = ExternalModuleFromEventBasedTypeKey.getExternalModuleFromIoNumber(ioNumber);
            externalChannelInfo.refreshDevice();
            double analog = externalChannelInfo.getValue();
            return analog;
        }
        if (devtype == 7) {
            int ioNumber = 40 + channel + 1;
            ExternalChannelInfo externalChannelInfo = ExternalModuleFromEventBasedTypeKey.getExternalModuleFromIoNumber(ioNumber);
            externalChannelInfo.refreshDevice();
            double analog = externalChannelInfo.getValue();
            return analog;
        }
        return -1.0;
    }

    public static String getDateStamp() {
        return Event.getDateStamp(QuickTime.getTimeMillis());
    }

    public static String getDateStamp(long time) {
        if (sPrefix == null || tRef > time || time - tRef >= 60000L) {
            Event.InitRefs(time);
        }
        int delta = (int)(time - tRef);
        int rSecond = delta / 1000;
        int rMillis = delta - 1000 * rSecond;
        return sPrefix + Integer.toString(rSecond + 100).substring(1) + "." + Integer.toString(rMillis + 1000).substring(1);
    }

    private static void InitRefs(long time) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date(time));
        int rMonth = cal.get(2);
        int rDay = cal.get(5);
        int rYear = cal.get(1);
        int rHour = cal.get(11);
        int rMinute = cal.get(12);
        int rSecond = cal.get(13);
        int rMillis = cal.get(14);
        tRef = time - (long)(1000 * rSecond + rMillis);
        StringBuffer buf = new StringBuffer(32);
        buf.append(Integer.toString(rMonth + 101).substring(1));
        buf.append("/");
        buf.append(Integer.toString(rDay + 100).substring(1));
        buf.append("/");
        buf.append(Integer.toString(rYear).substring(2));
        buf.append(" ");
        buf.append(Integer.toString(rHour + 100).substring(1));
        buf.append(":");
        buf.append(Integer.toString(rMinute + 100).substring(1));
        buf.append(":");
        sPrefix = buf.toString();
    }

    public void shouldAbort(long inputStates, long outputStates) {
        try {
            String abortIoPoint = EmbeddedBase.BASE.m_jnioros.getRegistryString("Schedule/Events/" + this.ed.name + "/AbortIoPoint", "");
            if ("".equalsIgnoreCase(abortIoPoint)) {
                EmbeddedBase.BASE.m_jnioros.setRegistryString("Schedule/Events/" + this.ed.name + "/AbortIoPoint", "not set");
            }
            if (abortIoPoint.startsWith("din")) {
                int channel = Integer.parseInt(abortIoPoint.substring(3));
                int channelState = (int)(inputStates >> channel - 1) & 1;
                System.out.println("Should abort on intput " + channel + " = " + channelState + " " + this._quit);
                this._quit = 0 != channelState;
            } else if (abortIoPoint.startsWith("rout")) {
                int channel = Integer.parseInt(abortIoPoint.substring(4));
                int channelState = (int)(outputStates >> channel - 1);
                System.out.println("channelstate: " + channelState);
                this._quit = 0 != (channelState &= 1);
                System.out.println("Should abort on output " + channel + " = " + channelState + " " + this._quit);
            }
            if (this._quit && null != this._thd) {
                this._thd.interrupt();
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
    }
}

