/*
 * Decompiled with CFR 0.152.
 */
package JniorProtocol.Devices;

import JniorProtocol.Devices.Jr310InternalDevice;
import JniorProtocol.Exceptions.CommandTimeoutException;
import JniorProtocol.Exceptions.InvalidStateException;
import JniorProtocol.Exceptions.NotLoggedInException;
import JniorProtocol.Exceptions.NotYetConnectedException;
import JniorProtocol.JniorSession;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public abstract class Jr310InternalOutput
extends Jr310InternalDevice {
    public static final int COMMAND_CLOSE = 1;
    public static final int COMMAND_OPEN = 2;
    public static final int COMMAND_TOGGLE = 3;
    public static final int COMMAND_CLEAR_OUTPUT_USAGE_METER = 9;
    private boolean m_fromMonitorPacket = false;
    private Jr310InternalOutput m_lastState = null;

    public Jr310InternalOutput(JniorSession jniorSession, int n) {
        super(jniorSession);
        this.m_channel = n + 1;
    }

    public void setState(int n) throws InvalidStateException, CommandTimeoutException, NotYetConnectedException, NotLoggedInException {
        this.m_session.isLoggedIn();
        if (n != 0 && n != 1) {
            throw new InvalidStateException();
        }
        int n2 = this.getState();
        if (n == 0) {
            n = 2;
        }
        this.buildCommandPacket(n);
        if (n != n2 && !this.m_monitorPacketsEnabled) {
            long l = System.currentTimeMillis();
            while (this.m_session.isConnected() && this.getState() == n2 && !this.isCommandTimeout(l)) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public void close() throws CommandTimeoutException, NotYetConnectedException, NotLoggedInException {
        this.m_session.isLoggedIn();
        try {
            this.setState(1);
        }
        catch (InvalidStateException invalidStateException) {
            invalidStateException.printStackTrace();
        }
    }

    public void open() throws CommandTimeoutException, NotYetConnectedException, NotLoggedInException {
        this.m_session.isLoggedIn();
        try {
            this.setState(0);
        }
        catch (InvalidStateException invalidStateException) {
            invalidStateException.printStackTrace();
        }
    }

    public void toggle() throws CommandTimeoutException, NotYetConnectedException, NotLoggedInException {
        this.m_session.isLoggedIn();
        int n = this.getState();
        this.buildCommandPacket(3);
        if (!this.m_monitorPacketsEnabled) {
            long l = System.currentTimeMillis();
            while (this.getState() == n && !this.isCommandTimeout(l)) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public void pulse(int n) throws NotYetConnectedException, NotLoggedInException {
        this.m_session.isLoggedIn();
        this.buildCommandPacket(6, n);
    }

    public void clearUsageMeter() throws NotYetConnectedException, NotLoggedInException {
        this.m_session.isLoggedIn();
        this.buildCommandPacket(9, this.m_channel);
    }

    public void receive(ByteArrayInputStream byteArrayInputStream, boolean bl) {
        this.m_fromMonitorPacket = bl;
        this.receive(byteArrayInputStream);
    }

    public void receive(ByteArrayInputStream byteArrayInputStream) {
        try {
            this.m_currentState = (byte)Jr310InternalOutput.get(byteArrayInputStream);
            this.m_session.getInternalsInstance().m_outputStates = this.m_currentState == 1 ? (this.m_session.getInternalsInstance().m_outputStates |= 1 << this.m_channel - 1) : (this.m_session.getInternalsInstance().m_outputStates &= ~(1 << this.m_channel - 1));
            if (!this.m_fromMonitorPacket) {
                this.m_usageMeter = Jr310InternalOutput.getLong(byteArrayInputStream);
                this.m_usageAlarm = (byte)Jr310InternalOutput.get(byteArrayInputStream);
            }
            this.m_monitorPacketReceived = true;
            if (!this.compareTo(this.m_lastState)) {
                this.m_lastState = (Jr310InternalOutput)this.clone();
                this.fireStateChange();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public boolean compareTo(Object object) {
        Jr310InternalOutput jr310InternalOutput = (Jr310InternalOutput)object;
        if (object == null) {
            return false;
        }
        if (jr310InternalOutput.m_currentState != this.m_currentState) {
            return false;
        }
        if (jr310InternalOutput.m_usageMeter != this.m_usageMeter) {
            return false;
        }
        return jr310InternalOutput.m_usageAlarm == this.m_usageAlarm;
    }

    public Object clone() {
        AbstractOutput abstractOutput = new AbstractOutput(this.m_session, this.m_channel);
        abstractOutput.m_currentState = this.m_currentState;
        abstractOutput.m_usageMeter = this.m_usageMeter;
        abstractOutput.m_usageAlarm = this.m_usageAlarm;
        return abstractOutput;
    }

    public String toString() {
        return "Output " + this.m_channel + " : " + (this.m_currentState == 1 ? " ON" : " OFF");
    }

    class AbstractOutput
    extends Jr310InternalOutput {
        public AbstractOutput(JniorSession jniorSession, int n) {
            super(jniorSession, n);
        }
    }
}

