/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.EmbeddedHelpers.Base;

import com.dalsemi.system.ArrayUtils;
import com.dalsemi.system.TINIOS;
import com.integpg.EmbeddedHelpers.Base.ConfigBase;
import com.integpg.EmbeddedHelpers.Logging.LogEngine;
import com.integpg.EmbeddedHelpers.Time.QuickDateStamp;
import com.integpg.EmbeddedHelpers.Time.QuickTime;
import integpg.JniorOS;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public abstract class EmbeddedBase {
    public static final byte[] CRLF = "\r\n".getBytes();
    protected static final byte[] INFO = new byte[60];
    protected static byte[] infoBytes = new byte[INFO.length];
    public static EmbeddedBase BASE;
    private static final long GC_RATE = 60000L;
    private static final String zones = "AST,PST,MST,CST,EST,CNT";
    private long m_nextGC;
    public JniorOS m_jnioros;
    public ConfigBase m_config;
    public String fileName;
    public String name;
    public String version;
    public long appStartTime = QuickTime.getTimeMillis();
    private String appName;
    public boolean m_quitApp = false;
    public LogEngine m_appLog = null;
    public static final int JUSTIFY_LEFT = 0;
    public static final int JUSTIFY_CENTER = 1;
    public static final int JUSTIFY_RIGHT = 2;
    private static StringBuffer sb;
    private static StringBuffer chars;

    private EmbeddedBase() {
        this.checkTimeZones();
        QuickDateStamp.invalidate();
        BASE = this;
        this.m_appLog = new LogEngine();
        EmbeddedBase.INFO[0] = 91;
        EmbeddedBase.INFO[EmbeddedBase.INFO.length - 1] = 93;
        ArrayUtils.arrayFill(INFO, 1, INFO.length - 1, (byte)32);
        try {
            this.printInfo("Init JNIOR OS Interface");
            this.m_jnioros = new JniorOS();
        }
        catch (IllegalAccessException ex) {
            EmbeddedBase.ExitException("Unable to init JniorOS");
            ex.printStackTrace();
            return;
        }
    }

    public EmbeddedBase(String name, String version) {
        this(name, version, null);
    }

    public EmbeddedBase(String name, String version, String instanceName) {
        this.checkTimeZones();
        QuickDateStamp.invalidate();
        BASE = this;
        this.name = name;
        this.fileName = name.toLowerCase().replace(' ', '_') + ".log";
        if (instanceName != null && !instanceName.equals("")) {
            this.name = this.name + "_" + instanceName;
        }
        this.version = version;
        this.m_appLog = new LogEngine();
        this.m_appLog.start();
        EmbeddedBase.INFO[0] = 91;
        EmbeddedBase.INFO[EmbeddedBase.INFO.length - 1] = 93;
        ArrayUtils.arrayFill(INFO, 1, INFO.length - 1, (byte)32);
        this.printInfo();
        this.printInfo();
        try {
            this.printInfo("Init JNIOR OS Interface");
            this.m_jnioros = new JniorOS();
        }
        catch (IllegalAccessException ex) {
            EmbeddedBase.ExitException("Unable to init JniorOS");
            ex.printStackTrace();
            return;
        }
        this.checkTimeZones();
        String startInfo = name + " - v." + version;
        this.printInfo(startInfo);
        this.printInfo(new Date(QuickTime.getTimeMillis()).toString());
        this.printInfo();
        startInfo = name + " - v." + version;
        this.m_jnioros.syslog(startInfo);
        try {
            this.appName = name.replace(' ', '_');
            this.m_jnioros.setRegistryString("AppData/" + this.appName + "/Name", name);
            this.m_jnioros.setRegistryString("AppData/" + this.appName + "/Version", version);
            this.m_jnioros.setRegistryString("AppData/" + this.appName + "/$Started", new Date(this.appStartTime).toString());
            this.m_jnioros.setRegistryString("AppData/" + this.appName + "/$Quit", "false");
            this.m_jnioros.setRegistryString("AppData/" + this.appName + "/$AppDone", "");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void log(String text) {
        this.m_appLog.logEntry(this.fileName, text);
    }

    public void logError(String error, Exception ex) {
        this.log(error + ": " + ex.toString());
        StringWriter sw = new StringWriter();
        ex.printStackTrace(new PrintWriter(sw));
        String exceptionAsString = sw.toString();
        System.err.println(error + "\r\n" + exceptionAsString);
    }

    protected boolean isDuplicateInstance(String appName) {
        String[] tasks = TINIOS.getTaskTable();
        int foundInstances = 0;
        for (int i = 0; i < tasks.length; ++i) {
            if (tasks[i].toLowerCase().indexOf(appName) >= 0) {
                ++foundInstances;
            }
            if (foundInstances <= 1) continue;
            return true;
        }
        return false;
    }

    public void checkTimeZones() {
        if (zones.indexOf(TINIOS.getTimeZone()) != -1) {
            TimeZone tz = TimeZone.getDefault();
            SimpleTimeZone newTZ = new SimpleTimeZone(tz.getRawOffset(), tz.getID(), 2, 8, -1, 0x6DDD00, 10, 1, -1, 0x6DDD00);
            TimeZone.setDefault(newTZ);
        }
    }

    public void stopApp() {
        try {
            this.printInfo("Stopping Application");
            this.m_quitApp = true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            if (this.m_appLog != null) {
                this.printInfo("Stopping Application Log");
                this.m_appLog.stop();
                this.m_appLog = null;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.gc();
    }

    public void waitForUserInput() {
    }

    public abstract void onUserInput(int var1);

    protected void printActiveThreads() {
        ThreadGroup group = Thread.currentThread().getThreadGroup();
        int numThreads = group.activeCount();
        System.out.println("   Active Threads : " + numThreads);
        Thread[] threads = new Thread[numThreads * 2];
        numThreads = group.enumerate(threads, false);
        for (int i = 0; i < numThreads; ++i) {
            Thread thread = threads[i];
            System.out.println("   " + thread.toString() + ", " + threads[i].getClass().toString() + (thread.isDaemon() ? " - DAEMON" : ""));
        }
    }

    public String printInfo() {
        return this.printInfo("", 1);
    }

    public String printInfo(String info) {
        return this.printInfo(info, 1);
    }

    public synchronized String printInfo(String info, int justification) {
        int staticInfoLength = INFO.length;
        int infoLen = Math.min(info.length(), staticInfoLength - 2);
        int start = (int)((double)(staticInfoLength - infoLen) / 2.0);
        int end = start + infoLen;
        switch (justification) {
            case 0: {
                start = 2;
                end = start + infoLen;
                break;
            }
            case 2: {
                end = staticInfoLength - 2;
                start = end - infoLen;
            }
        }
        try {
            ArrayUtils.arraycopy(INFO, 0, infoBytes, 0, start);
            ArrayUtils.arraycopy(info.getBytes(), 0, infoBytes, start, end - start);
            ArrayUtils.arraycopy(INFO, end, infoBytes, end, staticInfoLength - end);
            System.out.write(infoBytes, 0, infoBytes.length);
            System.out.write(CRLF);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            if (this.m_appLog != null) {
                this.m_appLog.logEntry(this.fileName, new String(infoBytes), QuickTime.getTimeMillis());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return new String(infoBytes);
    }

    private String replace(String orig, String target, String replacement) {
        if (target.equals(replacement)) {
            return orig;
        }
        int p1 = orig.indexOf(target);
        if (p1 >= 0) {
            int p2 = p1 + target.length();
            return orig.substring(0, p1) + replacement + orig.substring(p2);
        }
        return orig;
    }

    protected void finalize() throws Throwable {
        try {
            this.m_jnioros = null;
        }
        finally {
            super.finalize();
        }
    }

    public static void gc() {
        if (TINIOS.uptimeMillis() >= EmbeddedBase.BASE.m_nextGC) {
            System.gc();
            EmbeddedBase.BASE.m_nextGC = TINIOS.uptimeMillis() + 60000L;
        }
    }

    public static boolean sleep(long millis) {
        try {
            if (millis < 0L) {
                millis = 1L;
            }
            Thread.sleep(millis);
            return true;
        }
        catch (InterruptedException ex) {
            return false;
        }
    }

    public static void ExitException(String error) {
        System.err.println(EmbeddedBase.BASE.name + ": " + error);
        if (EmbeddedBase.BASE.m_appLog != null) {
            EmbeddedBase.BASE.m_appLog.logEntry(EmbeddedBase.BASE.fileName, error);
        }
        if (EmbeddedBase.BASE.m_jnioros != null) {
            EmbeddedBase.BASE.m_jnioros.syslog(EmbeddedBase.BASE.name.toLowerCase().replace(' ', '_') + ": " + error);
        }
        EmbeddedBase.BASE.m_quitApp = true;
        EmbeddedBase.gc();
        System.exit(-1);
    }

    public static String hexDump(byte[] bytes) {
        return EmbeddedBase.hexDump(bytes, 0, bytes.length);
    }

    public static synchronized String hexDump(byte[] bytes, int offset, int length) {
        int i;
        sb.setLength(0);
        chars.setLength(0);
        for (i = 0; i < length; ++i) {
            byte b;
            if (i % 16 == 0) {
                if (chars.length() > 0) {
                    sb.append("  ");
                    sb.append(chars.toString());
                    chars = new StringBuffer();
                    sb.append("\r\n");
                }
            } else if (i % 16 == 8) {
                chars.append(" ");
                sb.append("  ");
            }
            if ((b = bytes[i + offset]) >= 32) {
                chars.append((char)b);
            } else {
                chars.append('.');
            }
            int p = sb.length();
            sb.append(Integer.toHexString((b & 0xFF) / 16));
            sb.append(Integer.toHexString((b & 0xFF) % 16));
            sb.append(" ");
        }
        int mod = i % 16;
        if (mod != 0) {
            if (mod <= 8) {
                sb.append("  ");
            }
            for (i = 16 - mod; i > 0; --i) {
                sb.append("   ");
            }
            sb.append("  ");
            sb.append(chars.toString());
        }
        return sb.toString();
    }

    static {
        sb = new StringBuffer();
        chars = new StringBuffer();
    }
}

