/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.TaskManager;

import com.integpg.EmbeddedHelpers.ExceptionHandler;
import com.integpg.utils.Queue;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;

public class Logic {
    private static Vector unary_operators = new Vector();
    private static Hashtable unary_operator_lookup = new Hashtable();
    private static Vector binary_operators = new Vector();
    private static Hashtable binary_operator_lookup = new Hashtable();
    private Queue output = new Queue();
    private Stack ops = new Stack();
    private Stack temp = new Stack();
    private String _logic;
    private String _status;
    private int _inputsUsedMask = 0;
    private int _outputsUsedMask = 0;

    public Logic(String logic) {
        this._logic = logic;
        StringTokenizer st = new StringTokenizer(this._logic, " ");
        while (st.hasMoreElements()) {
            int channel;
            String token = st.nextToken();
            String lowerToken = token.toLowerCase();
            int afterLeftParen = 0;
            while (lowerToken.charAt(afterLeftParen) == '(') {
                this.ops.push(new Character('('));
                ++afterLeftParen;
            }
            int beforeRightParen = lowerToken.length() - 1;
            int rightParenCount = 0;
            while (lowerToken.charAt(beforeRightParen) == ')') {
                --beforeRightParen;
                ++rightParenCount;
            }
            int n = lowerToken.indexOf("din");
            if (n != -1) {
                channel = Integer.parseInt(token.substring(n + 3, beforeRightParen + 1));
                this._inputsUsedMask |= 1 << channel - 1;
                continue;
            }
            n = lowerToken.indexOf("rout");
            if (n == -1) continue;
            channel = Integer.parseInt(token.substring(n + 4, beforeRightParen + 1));
            this._outputsUsedMask |= 1 << channel - 1;
        }
    }

    public String getLogic() {
        return this._logic;
    }

    public int getInputsUsedMask() {
        return this._inputsUsedMask;
    }

    public int getOutputsUsedMask() {
        return this._outputsUsedMask;
    }

    public int evaluate(long inputStates, long outputStates) {
        try {
            if (this._logic == null) {
                return 0;
            }
            this._status = "Get I/O States";
            this.output = new Queue();
            this.ops = new Stack();
            this.temp = new Stack();
            this._status = "Convert to RPN Notation";
            StringTokenizer st = new StringTokenizer(this._logic, " ");
            while (st.hasMoreElements()) {
                int channel;
                String token = st.nextToken();
                String lowerToken = token.toLowerCase();
                int afterLeftParen = 0;
                while (lowerToken.charAt(afterLeftParen) == '(') {
                    this.ops.push(new Character('('));
                    ++afterLeftParen;
                }
                int beforeRightParen = lowerToken.length() - 1;
                int rightParenCount = 0;
                while (lowerToken.charAt(beforeRightParen) == ')') {
                    --beforeRightParen;
                    ++rightParenCount;
                }
                int n = lowerToken.indexOf("din");
                if (n != -1) {
                    channel = Integer.parseInt(token.substring(n + 3, beforeRightParen + 1));
                    lowerToken = String.valueOf(inputStates >> channel - 1 & 1L);
                } else {
                    n = lowerToken.indexOf("rout");
                    if (n != -1) {
                        channel = Integer.parseInt(token.substring(n + 4, beforeRightParen + 1));
                        lowerToken = String.valueOf(outputStates >> channel - 1 & 1L);
                    } else if (afterLeftParen != 0 || beforeRightParen != lowerToken.length()) {
                        lowerToken = lowerToken.substring(afterLeftParen, beforeRightParen + 1);
                    }
                }
                if (unary_operator_lookup.containsKey(lowerToken)) {
                    this.ops.push(unary_operator_lookup.get(lowerToken));
                } else if (binary_operator_lookup.containsKey(lowerToken)) {
                    char oper = ((Character)binary_operator_lookup.get(lowerToken)).charValue();
                    while (this.ops.size() > 0 && this.GetOperatorRank(oper) <= this.GetOperatorRank(((Character)this.ops.peek()).charValue())) {
                        this.output.enqueue(((Character)this.ops.pop()).toString());
                    }
                    this.ops.push(new Character(oper));
                } else {
                    this.output.enqueue(lowerToken);
                }
                while (rightParenCount-- > 0) {
                    while (this.ops.size() > 0 && ((Character)this.ops.peek()).charValue() != '(') {
                        this.output.enqueue(((Character)this.ops.pop()).toString());
                    }
                    if (((Character)this.ops.peek()).charValue() != '(') continue;
                    this.ops.pop();
                }
            }
            while (this.ops.size() > 0) {
                this.output.enqueue(((Character)this.ops.pop()).toString());
            }
            this._status = "Perform Logic";
            String result = null;
            while (this.output.size() > 0) {
                if (this.output.size() > 1) {
                    Queue tq;
                    String left = this.output.dequeue().toString();
                    String oper = this.output.dequeue().toString();
                    if (unary_operators.contains(new Character(oper.charAt(0)))) {
                        result = String.valueOf(this.unary_eval(oper.charAt(0), left));
                        Queue tq2 = new Queue();
                        while (this.temp.size() > 0) {
                            tq2.enqueue(this.temp.pop());
                        }
                        tq2.enqueue(result);
                        while (this.output.size() > 0) {
                            tq2.enqueue(this.output.dequeue());
                        }
                        this.output = tq2;
                        continue;
                    }
                    String right = oper;
                    oper = this.output.dequeue().toString();
                    if (binary_operators.contains(new Character(oper.charAt(0)))) {
                        result = String.valueOf(this.binary_eval(oper.charAt(0), left, right));
                        tq = new Queue();
                        while (this.temp.size() > 0) {
                            tq.enqueue(this.temp.pop());
                        }
                        tq.enqueue(result);
                        while (this.output.size() > 0) {
                            tq.enqueue(this.output.dequeue());
                        }
                        this.output = tq;
                        continue;
                    }
                    this.temp.push(left);
                    tq = new Queue();
                    tq.enqueue(right);
                    tq.enqueue(oper);
                    while (this.output.size() > 0) {
                        tq.enqueue(this.output.dequeue());
                    }
                    this.output = tq;
                    continue;
                }
                result = this.output.dequeue().toString();
            }
            if (result != null) {
                return Integer.parseInt(result);
            }
            return 0;
        }
        catch (Exception ex) {
            if (this._status != null) {
                ExceptionHandler.logException(0, ex);
            } else {
                ex.printStackTrace();
            }
            return 0;
        }
    }

    private int GetOperatorRank(char oper) {
        switch (oper) {
            case '^': {
                return 9;
            }
            case '!': {
                return 10;
            }
            case '&': {
                return 9;
            }
            case '|': {
                return 9;
            }
            case '*': {
                return 8;
            }
            case '/': {
                return 8;
            }
            case '%': {
                return 8;
            }
            case '+': {
                return 6;
            }
            case '-': {
                return 6;
            }
            case '(': {
                return -1;
            }
        }
        return 0;
    }

    private int unary_eval(char oper, String right) {
        int vRight = Integer.parseInt(right);
        if (oper == '!') {
            return vRight ^ 1;
        }
        return 0;
    }

    private int binary_eval(char oper, String left, String right) {
        int vLeft = Integer.parseInt(left);
        int vRight = Integer.parseInt(right);
        if (oper == '&') {
            return vLeft & vRight;
        }
        if (oper == '|') {
            return vLeft | vRight;
        }
        if (oper == '^') {
            return vLeft ^ vRight;
        }
        return 0;
    }

    static {
        unary_operators.addElement(new Character('!'));
        unary_operator_lookup.put("not", new Character('!'));
        binary_operators.addElement(new Character('&'));
        binary_operators.addElement(new Character('|'));
        binary_operators.addElement(new Character('^'));
        binary_operator_lookup.put("and", new Character('&'));
        binary_operator_lookup.put("or", new Character('|'));
        binary_operator_lookup.put("xor", new Character('^'));
    }
}

