/*
 * Decompiled with CFR 0.152.
 */
package TaskManagerInterface.Event;

import JniorProtocol.Exceptions.CommandTimeoutException;
import JniorProtocol.Exceptions.NotLoggedInException;
import JniorProtocol.Exceptions.NotYetConnectedException;
import TaskManagerInterface.Event.ActionDialog;
import TaskManagerInterface.Event.EventData;
import TaskManagerInterface.Event.EventDataFormListener;
import TaskManagerInterface.TaskManagerPanel;
import TaskManagerInterface.TimePicker;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.NumberFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class EventProperties
extends JPanel
implements ListDataListener,
ActionListener {
    private static final boolean DEBUG = false;
    public static final int EITHER = 3;
    public static final int FALLING = 2;
    public static final int RISING = 1;
    private TaskManagerPanel main;
    private EventDataFormListener listener;
    private Hashtable controlHash = null;
    private DefaultComboBoxModel modelActions = new DefaultComboBoxModel();
    private EventData eventData;
    private boolean allDays = false;
    private JButton buttonAddAction;
    private JButton buttonEditAction;
    private ButtonGroup buttonGroupEventBasedType;
    private ButtonGroup buttonGroupEventIO;
    private ButtonGroup buttonGroupEventType;
    private ButtonGroup buttonGroupReset;
    private ButtonGroup buttonGroupTransitionType;
    private JButton buttonMoveDown;
    private JButton buttonMoveUp;
    private JButton buttonRemoveAction;
    private JPanel cardEventBased;
    private JPanel cardEventType;
    private JCheckBox chkAll;
    private JCheckBox chkEnabled;
    private JCheckBox chkFri;
    private JCheckBox chkMon;
    private JCheckBox chkRecurring;
    private JCheckBox chkSat;
    private JCheckBox chkSun;
    private JCheckBox chkThu;
    private JCheckBox chkTue;
    private JCheckBox chkWed;
    private JComboBox combDeviceSelect;
    private JComboBox combIOSelect;
    private JComboBox combLocationSelect;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel17;
    private JLabel jLabel19;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JLabel jLabel22;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel11;
    private JPanel jPanel12;
    private JPanel jPanel13;
    private JPanel jPanel14;
    private JPanel jPanel19;
    private JPanel jPanel2;
    private JPanel jPanel20;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel6;
    private JPanel jPanel9;
    private JScrollPane jScrollPane1;
    private JTextArea jTextArea1;
    private JList lvwActions;
    private JCheckBox onRising;
    private JPanel panelAnalog;
    private JPanel panelCounter;
    private JPanel panelEventBased;
    private JPanel panelInterval;
    private JPanel panelLogical;
    private JPanel panelTimeBased;
    private JPanel panelTransition;
    private JPanel panelUsageMeter;
    private JRadioButton rbAnalog;
    private JRadioButton rbCounter;
    private JRadioButton rbEither;
    private JRadioButton rbEventBased;
    private JRadioButton rbFalling;
    private JRadioButton rbLogical;
    private JRadioButton rbRising;
    private JRadioButton rbTimeBased;
    private JRadioButton rbTransition;
    private JRadioButton rbUsage;
    private TimePicker timePickerEnd;
    private TimePicker timePickerStart;
    private JTextField txtAction;
    private JLabel txtActionsSize;
    private JTextField txtActivateValue;
    private JTextField txtCounterValue;
    private JTextField txtDeactivateValue;
    private JTextField txtIntervalHours;
    private JTextField txtIntervalMinutes;
    private JTextField txtIntervalSeconds;
    private JTextField txtLogicalExpression;
    private JTextField txtName;
    private JTextField txtUsageValue;

    public EventProperties(TaskManagerPanel taskManagerPanel) {
        this.main = taskManagerPanel;
        this.initComponents();
        this.lvwActions.getModel().addListDataListener(this);
        this.timePickerStart.addTimeChangeListener(this);
        this.timePickerEnd.addTimeChangeListener(this);
    }

    public void setChangeListener(EventDataFormListener eventDataFormListener) {
        this.listener = eventDataFormListener;
    }

    private void controlSnapshot(Container container) {
        this.controlHash = new Hashtable();
        this.txtAction.setVisible(false);
        this.traverseControls(container);
    }

    private void traverseControls(Container container) {
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component = container.getComponent(i);
            Object object = this.getControlValue(component);
            if (object != null) {
                this.controlHash.put(component, object);
            }
            this.traverseControls((Container)component);
        }
    }

    private Object getControlValue(Component component) {
        if (component instanceof JTextField) {
            return ((JTextField)component).getText();
        }
        if (component instanceof JCheckBox) {
            return ((JCheckBox)component).isSelected();
        }
        if (component instanceof JRadioButton) {
            return ((JRadioButton)component).isSelected();
        }
        if (component instanceof JSpinner) {
            return ((JSpinner)component).getModel().getValue();
        }
        if (component instanceof JList) {
            return ((JList)component).getModel();
        }
        if (component instanceof JComboBox) {
            return ((JComboBox)component).getSelectedIndex();
        }
        if (component instanceof TimePicker) {
            return ((TimePicker)component).getTimeMillis();
        }
        if (component instanceof JPanel || component instanceof JButton || component instanceof JScrollPane || component instanceof JViewport || component instanceof JLabel) {
            // empty if block
        }
        return null;
    }

    private void compare() {
        if (this.isChange(this)) {
            this.fireChangeEvent();
        } else {
            this.fireUndoChangesEvent();
        }
    }

    private void fireChangeEvent() {
        if (this.listener != null) {
            this.listener.onChange(new EventObject(this));
        }
    }

    private void fireUndoChangesEvent() {
        if (this.listener != null) {
            this.listener.onUndoChanges(new EventObject(this));
        }
    }

    private boolean isChange(Container container) {
        if (this.controlHash == null) {
            return false;
        }
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component = container.getComponent(i);
            Object object = this.getControlValue(component);
            if (object != null && !this.controlHash.get(component).equals(object)) {
                return true;
            }
            if (!this.isChange((Container)component)) continue;
            return true;
        }
        return false;
    }

    public void displayScheduleData() {
        this.displayScheduleData(this.eventData);
    }

    public void displayScheduleData(EventData eventData) {
        this.controlHash = null;
        this.eventData = eventData;
        if (eventData == null) {
            return;
        }
        this.fireUndoChangesEvent();
        this.txtName.setText(eventData.name);
        this.chkEnabled.setSelected(eventData.enabled);
        Date date = new Date(eventData.interval);
        Date date2 = new Date(eventData.startTimeMillis + (long)(date.getTimezoneOffset() * 60 * 1000));
        this.timePickerStart.setTime(eventData.startTimeMillis + (long)(date.getTimezoneOffset() * 60 * 1000));
        Date date3 = new Date(eventData.endTimeMillis + (long)(date.getTimezoneOffset() * 60 * 1000));
        this.timePickerEnd.setTime(eventData.endTimeMillis + (long)(date.getTimezoneOffset() * 60 * 1000));
        int n = eventData.getDaysMask();
        this.chkSun.setSelected((n & 1) != 0);
        this.chkMon.setSelected((n & 2) != 0);
        this.chkTue.setSelected((n & 4) != 0);
        this.chkWed.setSelected((n & 8) != 0);
        this.chkThu.setSelected((n & 0x10) != 0);
        this.chkFri.setSelected((n & 0x20) != 0);
        this.chkSat.setSelected((n & 0x40) != 0);
        int n2 = eventData.eventChannel - 1;
        if (n2 < 0) {
            n2 = 0;
        }
        int n3 = n2 / 8;
        int n4 = 0;
        if (n3 > 1 && n2 % 8 > 3) {
            n4 = 1;
        }
        n2 = n2 % 8 - n4 * 4;
        this.combDeviceSelect.setSelectedIndex(n3);
        this.combDeviceSelectItemStateChanged(null);
        this.combLocationSelect.setSelectedIndex(n4);
        this.combIOSelect.setSelectedIndex(n2);
        this.txtCounterValue.setText("");
        this.txtUsageValue.setText("");
        this.txtActivateValue.setText("");
        this.txtDeactivateValue.setText("");
        this.txtLogicalExpression.setText("");
        if (eventData.eventBased) {
            this.timePickerEnd.setEnabled(true);
            this.rbEventBased.setSelected(true);
            switch (eventData.type) {
                case 1: {
                    this.rbTransition.setSelected(true);
                    if (eventData.value == 1) {
                        this.rbRising.setSelected(true);
                        break;
                    }
                    if (eventData.value == 2) {
                        this.rbFalling.setSelected(true);
                        break;
                    }
                    this.rbEither.setSelected(true);
                    break;
                }
                case 2: {
                    this.rbCounter.setSelected(true);
                    this.txtCounterValue.setText(Integer.toString(eventData.value));
                    break;
                }
                case 3: {
                    this.rbUsage.setSelected(true);
                    double d = eventData.value;
                    d /= 1000.0;
                    d /= 60.0;
                    NumberFormat numberFormat = NumberFormat.getInstance();
                    numberFormat.setMaximumFractionDigits(2);
                    this.txtUsageValue.setText(numberFormat.format(d /= 60.0));
                    break;
                }
                case 4: {
                    this.onRising.setSelected(true);
                    double d = eventData.value;
                    NumberFormat numberFormat = NumberFormat.getInstance();
                    numberFormat.setMaximumFractionDigits(3);
                    this.txtActivateValue.setText(numberFormat.format(d /= 1000.0));
                    d = eventData.misc;
                    this.txtDeactivateValue.setText(numberFormat.format(d /= 1000.0));
                    break;
                }
                case 5: {
                    this.onRising.setSelected(false);
                    double d = eventData.value;
                    NumberFormat numberFormat = NumberFormat.getInstance();
                    numberFormat.setMaximumFractionDigits(3);
                    this.txtActivateValue.setText(numberFormat.format(d /= 1000.0));
                    d = eventData.misc;
                    this.txtDeactivateValue.setText(numberFormat.format(d /= 1000.0));
                }
            }
        } else if (eventData.logical) {
            this.rbLogical.setSelected(true);
            this.txtLogicalExpression.setText(eventData._logicalExpression);
        } else {
            this.rbTimeBased.setSelected(true);
            this.timePickerEnd.setEnabled(eventData.recurring);
        }
        this.chkRecurring.setSelected(eventData.recurring);
        date.setTime(date.getTime() + (long)(date.getTimezoneOffset() * 60 * 1000));
        this.txtIntervalHours.setText(String.valueOf(date.getHours()));
        this.txtIntervalMinutes.setText(String.valueOf(date.getMinutes()));
        this.txtIntervalSeconds.setText(String.valueOf(date.getSeconds()));
        this.txtAction.setText(eventData.action);
        this.txtActionsSize.setText(this.txtAction.getText().length() + " / 255");
        if (this.txtAction.getText().length() > 255) {
            this.txtActionsSize.setForeground(Color.RED);
        } else if (this.txtAction.getText().length() > 200) {
            this.txtActionsSize.setForeground(Color.ORANGE);
        } else {
            this.txtActionsSize.setForeground(Color.BLACK);
        }
        this.modelActions.removeAllElements();
        if (eventData.action != null && !eventData.action.equals("")) {
            String[] stringArray = eventData.action.split(";; ");
            for (int i = 0; i < stringArray.length; ++i) {
                this.addAction(stringArray[i]);
            }
        }
        this.controlSnapshot(this);
        this.fireUndoChangesEvent();
    }

    private void addAction(String string) {
        this.modelActions.addElement(string);
        this.lvwActions.setModel(this.modelActions);
    }

    private void setActionText() {
        this.txtAction.setText("");
        for (int i = 0; i < this.modelActions.getSize(); ++i) {
            String string = this.modelActions.getElementAt(i).toString();
            if (string.trim().equals("")) continue;
            if (!this.txtAction.getText().equals("")) {
                this.txtAction.setText(this.txtAction.getText() + ";; ");
            }
            this.txtAction.setText(this.txtAction.getText() + string);
            this.txtActionsSize.setText(this.txtAction.getText().length() + " / 253");
            if (this.txtAction.getText().length() > 253) {
                this.txtActionsSize.setForeground(Color.RED);
                continue;
            }
            if (this.txtAction.getText().length() > 200) {
                this.txtActionsSize.setForeground(Color.ORANGE);
                continue;
            }
            this.txtActionsSize.setForeground(Color.BLACK);
        }
        this.txtAction.getActionListeners()[0].actionPerformed(new ActionEvent(this, 0, "Action added"));
    }

    public void saveEventData() {
        if (this.eventData == null) {
            return;
        }
        if (this.txtAction.getText().length() > 253) {
            JOptionPane.showMessageDialog(this, "There are too many actions associated with this task.  Plese remove some actions before saving.", "Too many actions", 2);
            return;
        }
        try {
            this.eventData.enabled = this.chkEnabled.isSelected();
            this.eventData.startTime = this.timePickerStart.getTime();
            this.eventData.endTime = this.timePickerEnd.getTime();
            int n = 0;
            if (this.chkSun.isSelected()) {
                n |= 1;
            }
            if (this.chkMon.isSelected()) {
                n |= 2;
            }
            if (this.chkTue.isSelected()) {
                n |= 4;
            }
            if (this.chkWed.isSelected()) {
                n |= 8;
            }
            if (this.chkThu.isSelected()) {
                n |= 0x10;
            }
            if (this.chkFri.isSelected()) {
                n |= 0x20;
            }
            if (this.chkSat.isSelected()) {
                n |= 0x40;
            }
            this.eventData.setDaysMask(n);
            if (this.rbTimeBased.isSelected()) {
                this.eventData.timeBased = true;
                this.eventData.eventBased = false;
                this.eventData.logical = false;
                this.eventData.recurring = this.chkRecurring.isSelected();
                int n2 = 0;
                try {
                    n2 = Integer.parseInt(this.txtIntervalHours.getText()) * 3600 + Integer.parseInt(this.txtIntervalMinutes.getText()) * 60 + Integer.parseInt(this.txtIntervalSeconds.getText());
                    if (n2 < 5 && this.chkRecurring.isSelected()) {
                        throw new Exception("Interval cannot be less than 5 seconds");
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                this.eventData.interval = n2;
            } else if (this.rbEventBased.isSelected()) {
                double d;
                this.eventData.eventBased = this.rbEventBased.isSelected();
                this.eventData.timeBased = false;
                this.eventData.logical = false;
                if (this.rbTransition.isSelected()) {
                    this.eventData.type = 1;
                    this.eventData.value = this.rbRising.isSelected() ? 1 : (this.rbFalling.isSelected() ? 2 : 3);
                } else if (this.rbCounter.isSelected()) {
                    if (this.txtCounterValue.getText().equals("")) {
                        throw new Exception("Please Enter a valid Counter value");
                    }
                    this.eventData.type = 2;
                    this.eventData.value = Integer.parseInt(this.txtCounterValue.getText());
                } else if (this.rbUsage.isSelected()) {
                    if (this.txtUsageValue.getText().equals("")) {
                        throw new Exception("Please enter a valid Usage Meter value");
                    }
                    this.eventData.type = 3;
                    d = Double.parseDouble(this.txtUsageValue.getText());
                    d *= 60.0;
                    d *= 60.0;
                    this.eventData.value = (int)(d *= 1000.0);
                } else if (this.rbAnalog.isSelected()) {
                    if (this.txtActivateValue.getText().equals("")) {
                        throw new Exception("Please enter a valid analog trigger value. Scaling is based on main applet.");
                    }
                    if (this.txtDeactivateValue.getText().equals("")) {
                        throw new Exception("Please enter a valid analog reset value. Scaling is based on main applet.");
                    }
                    this.eventData.type = this.onRising.isSelected() ? 4 : 5;
                    d = Double.parseDouble(this.txtActivateValue.getText());
                    double d2 = Double.parseDouble(this.txtDeactivateValue.getText());
                    this.eventData.value = (int)(d * 1000.0);
                    this.eventData.misc = (int)(d2 * 1000.0);
                }
                int n3 = this.combDeviceSelect.getSelectedIndex() * 8;
                n3 += this.combIOSelect.getSelectedIndex() + 1;
                if (this.combDeviceSelect.getSelectedIndex() > 1) {
                    n3 += this.combLocationSelect.getSelectedIndex() * 4;
                }
                this.eventData.eventChannel = n3;
            } else if (this.rbLogical.isSelected()) {
                this.eventData.eventBased = false;
                this.eventData.timeBased = false;
                this.eventData.logical = true;
                this.eventData._logicalExpression = this.txtLogicalExpression.getText();
            }
            this.eventData.action = "\"" + this.txtAction.getText() + "\"";
            this.fireUndoChangesEvent();
            this.main.m_details.setStatusText("Saving Data");
            this.main.m_blur.setVisible(true);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        EventProperties.this.eventData.save();
                    }
                    catch (NotYetConnectedException notYetConnectedException) {
                        notYetConnectedException.printStackTrace();
                    }
                    catch (CommandTimeoutException commandTimeoutException) {
                        commandTimeoutException.printStackTrace();
                    }
                    catch (NotLoggedInException notLoggedInException) {
                        notLoggedInException.printStackTrace();
                    }
                    ((EventProperties)EventProperties.this).main.m_blur.setVisible(false);
                }
            }).start();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception.getMessage());
        }
    }

    private void initComponents() {
        this.buttonGroupReset = new ButtonGroup();
        this.buttonGroupEventType = new ButtonGroup();
        this.buttonGroupEventBasedType = new ButtonGroup();
        this.buttonGroupTransitionType = new ButtonGroup();
        this.buttonGroupEventIO = new ButtonGroup();
        this.jPanel9 = new JPanel();
        this.jLabel7 = new JLabel();
        this.txtName = new JTextField();
        this.chkEnabled = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.timePickerStart = new TimePicker();
        this.jLabel8 = new JLabel();
        this.timePickerEnd = new TimePicker();
        this.jPanel11 = new JPanel();
        this.jLabel9 = new JLabel();
        this.chkSun = new JCheckBox();
        this.chkMon = new JCheckBox();
        this.chkTue = new JCheckBox();
        this.chkWed = new JCheckBox();
        this.chkThu = new JCheckBox();
        this.chkFri = new JCheckBox();
        this.chkSat = new JCheckBox();
        this.chkAll = new JCheckBox();
        this.jPanel19 = new JPanel();
        this.jLabel17 = new JLabel();
        this.rbTimeBased = new JRadioButton();
        this.rbEventBased = new JRadioButton();
        this.rbLogical = new JRadioButton();
        this.cardEventType = new JPanel();
        this.panelTimeBased = new JPanel();
        this.jPanel4 = new JPanel();
        this.chkRecurring = new JCheckBox();
        this.panelInterval = new JPanel();
        this.jLabel2 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.txtIntervalHours = new JTextField();
        this.txtIntervalMinutes = new JTextField();
        this.txtIntervalSeconds = new JTextField();
        this.panelEventBased = new JPanel();
        this.jPanel20 = new JPanel();
        this.rbTransition = new JRadioButton();
        this.rbCounter = new JRadioButton();
        this.rbUsage = new JRadioButton();
        this.rbAnalog = new JRadioButton();
        this.cardEventBased = new JPanel();
        this.panelTransition = new JPanel();
        this.rbRising = new JRadioButton();
        this.rbFalling = new JRadioButton();
        this.rbEither = new JRadioButton();
        this.panelCounter = new JPanel();
        this.jLabel20 = new JLabel();
        this.txtCounterValue = new JTextField();
        this.panelUsageMeter = new JPanel();
        this.jLabel22 = new JLabel();
        this.txtUsageValue = new JTextField();
        this.jLabel19 = new JLabel();
        this.panelAnalog = new JPanel();
        this.onRising = new JCheckBox();
        this.jLabel10 = new JLabel();
        this.txtActivateValue = new JTextField();
        this.jLabel11 = new JLabel();
        this.txtDeactivateValue = new JTextField();
        this.combDeviceSelect = new JComboBox();
        this.combIOSelect = new JComboBox();
        this.jLabel13 = new JLabel();
        this.jLabel14 = new JLabel();
        this.jLabel15 = new JLabel();
        this.combLocationSelect = new JComboBox();
        this.panelLogical = new JPanel();
        this.jTextArea1 = new JTextArea();
        this.jPanel3 = new JPanel();
        this.jLabel12 = new JLabel();
        this.txtLogicalExpression = new JTextField();
        this.jPanel12 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.lvwActions = new JList();
        this.jPanel14 = new JPanel();
        this.buttonMoveUp = new JButton();
        this.buttonMoveDown = new JButton();
        this.jPanel13 = new JPanel();
        this.buttonAddAction = new JButton();
        this.buttonRemoveAction = new JButton();
        this.buttonEditAction = new JButton();
        this.jPanel6 = new JPanel();
        this.jLabel3 = new JLabel();
        this.txtActionsSize = new JLabel();
        this.txtAction = new JTextField();
        this.setLayout(new GridBagLayout());
        this.jPanel9.setLayout(new BoxLayout(this.jPanel9, 2));
        this.jLabel7.setText("Task Name");
        this.jPanel9.add(this.jLabel7);
        this.txtName.setMinimumSize(new Dimension(150, 19));
        this.txtName.setPreferredSize(new Dimension(150, 21));
        this.txtName.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent caretEvent) {
                EventProperties.this.txtNameCaretUpdate(caretEvent);
            }
        });
        this.jPanel9.add(this.txtName);
        this.chkEnabled.setText("Enabled");
        this.chkEnabled.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                EventProperties.this.chkEnabledItemStateChanged(itemEvent);
            }
        });
        this.jPanel9.add(this.chkEnabled);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.jPanel9, gridBagConstraints);
        this.jLabel1.setText("Start Time");
        this.jPanel2.add(this.jLabel1);
        this.jPanel2.add(this.timePickerStart);
        this.jLabel8.setText("End Time");
        this.jPanel2.add(this.jLabel8);
        this.timePickerEnd.setEnabled(false);
        this.jPanel2.add(this.timePickerEnd);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 2.0;
        this.add((Component)this.jPanel2, gridBagConstraints);
        this.jLabel9.setText("Days of the week");
        this.jPanel11.add(this.jLabel9);
        this.chkSun.setText("Sun");
        this.chkSun.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                EventProperties.this.daysOfWeekItmStateChanged(itemEvent);
            }
        });
        this.jPanel11.add(this.chkSun);
        this.chkMon.setText("Mon");
        this.chkMon.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                EventProperties.this.daysOfWeekItmStateChanged(itemEvent);
            }
        });
        this.jPanel11.add(this.chkMon);
        this.chkTue.setText("Tue");
        this.chkTue.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                EventProperties.this.daysOfWeekItmStateChanged(itemEvent);
            }
        });
        this.jPanel11.add(this.chkTue);
        this.chkWed.setText("Wed");
        this.chkWed.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                EventProperties.this.daysOfWeekItmStateChanged(itemEvent);
            }
        });
        this.jPanel11.add(this.chkWed);
        this.chkThu.setText("Thu");
        this.chkThu.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                EventProperties.this.daysOfWeekItmStateChanged(itemEvent);
            }
        });
        this.jPanel11.add(this.chkThu);
        this.chkFri.setText("Fri");
        this.chkFri.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                EventProperties.this.daysOfWeekItmStateChanged(itemEvent);
            }
        });
        this.jPanel11.add(this.chkFri);
        this.chkSat.setText("Sat");
        this.chkSat.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                EventProperties.this.daysOfWeekItmStateChanged(itemEvent);
            }
        });
        this.jPanel11.add(this.chkSat);
        this.chkAll.setText("All");
        this.chkAll.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                EventProperties.this.chkAllItemStateChanged(itemEvent);
            }
        });
        this.jPanel11.add(this.chkAll);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.jPanel11, gridBagConstraints);
        this.jLabel17.setText("Type of Task : ");
        this.jPanel19.add(this.jLabel17);
        this.buttonGroupEventType.add(this.rbTimeBased);
        this.rbTimeBased.setSelected(true);
        this.rbTimeBased.setText("Time Based");
        this.rbTimeBased.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                EventProperties.this.eventTypeItemStateChanged(itemEvent);
            }
        });
        this.jPanel19.add(this.rbTimeBased);
        this.buttonGroupEventType.add(this.rbEventBased);
        this.rbEventBased.setText("Event Based");
        this.rbEventBased.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                EventProperties.this.eventTypeItemStateChanged(itemEvent);
            }
        });
        this.jPanel19.add(this.rbEventBased);
        this.buttonGroupEventType.add(this.rbLogical);
        this.rbLogical.setText("Logical");
        this.rbLogical.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                EventProperties.this.eventTypeItemStateChanged(itemEvent);
            }
        });
        this.jPanel19.add(this.rbLogical);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.jPanel19, gridBagConstraints);
        this.cardEventType.setLayout(new CardLayout());
        this.chkRecurring.setText("Recurring");
        this.chkRecurring.setHorizontalTextPosition(10);
        this.chkRecurring.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                EventProperties.this.chkRecurringItemStateChanged(itemEvent);
            }
        });
        this.jPanel4.add(this.chkRecurring);
        this.jLabel2.setText("Interval");
        this.panelInterval.add(this.jLabel2);
        this.jPanel1.setLayout(new GridLayout(2, 0));
        this.jLabel4.setText("  Hours");
        this.jPanel1.add(this.jLabel4);
        this.jLabel5.setText("  Minutes");
        this.jPanel1.add(this.jLabel5);
        this.jLabel6.setText("  Seconds");
        this.jPanel1.add(this.jLabel6);
        this.txtIntervalHours.setEnabled(false);
        this.txtIntervalHours.setPreferredSize(new Dimension(35, 21));
        this.txtIntervalHours.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent caretEvent) {
                EventProperties.this.intervalCaretUpdate(caretEvent);
            }
        });
        this.jPanel1.add(this.txtIntervalHours);
        this.txtIntervalMinutes.setEnabled(false);
        this.txtIntervalMinutes.setPreferredSize(new Dimension(35, 21));
        this.txtIntervalMinutes.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent caretEvent) {
                EventProperties.this.intervalCaretUpdate(caretEvent);
            }
        });
        this.jPanel1.add(this.txtIntervalMinutes);
        this.txtIntervalSeconds.setEnabled(false);
        this.txtIntervalSeconds.setPreferredSize(new Dimension(35, 21));
        this.txtIntervalSeconds.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent caretEvent) {
                EventProperties.this.intervalCaretUpdate(caretEvent);
            }
        });
        this.jPanel1.add(this.txtIntervalSeconds);
        this.panelInterval.add(this.jPanel1);
        this.jPanel4.add(this.panelInterval);
        this.panelTimeBased.add(this.jPanel4);
        this.cardEventType.add((Component)this.panelTimeBased, "TimeBased");
        this.panelEventBased.setLayout(new GridBagLayout());
        this.jPanel20.setLayout(new BoxLayout(this.jPanel20, 2));
        this.buttonGroupEventBasedType.add(this.rbTransition);
        this.rbTransition.setSelected(true);
        this.rbTransition.setText("Transition");
        this.rbTransition.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                EventProperties.this.rbTransitionItemStateChanged(itemEvent);
            }
        });
        this.jPanel20.add(this.rbTransition);
        this.buttonGroupEventBasedType.add(this.rbCounter);
        this.rbCounter.setText("Counter");
        this.rbCounter.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                EventProperties.this.rbCounterItemStateChanged(itemEvent);
            }
        });
        this.jPanel20.add(this.rbCounter);
        this.buttonGroupEventBasedType.add(this.rbUsage);
        this.rbUsage.setText("Usage Meter");
        this.rbUsage.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                EventProperties.this.rbUsageItemStateChanged(itemEvent);
            }
        });
        this.jPanel20.add(this.rbUsage);
        this.buttonGroupEventBasedType.add(this.rbAnalog);
        this.rbAnalog.setText("Analog");
        this.rbAnalog.setEnabled(false);
        this.rbAnalog.setPreferredSize(new Dimension(87, 23));
        this.rbAnalog.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                EventProperties.this.rbAnalogItemStateChanged(itemEvent);
            }
        });
        this.jPanel20.add(this.rbAnalog);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 20, 0, 0);
        this.panelEventBased.add((Component)this.jPanel20, gridBagConstraints);
        this.cardEventBased.setLayout(new CardLayout());
        this.panelTransition.setLayout(new BoxLayout(this.panelTransition, 2));
        this.buttonGroupTransitionType.add(this.rbRising);
        this.rbRising.setText("Low to High");
        this.rbRising.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                EventProperties.this.rbRisingItemStateChanged(itemEvent);
            }
        });
        this.panelTransition.add(this.rbRising);
        this.buttonGroupTransitionType.add(this.rbFalling);
        this.rbFalling.setText("High to Low");
        this.rbFalling.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                EventProperties.this.rbFallingItemStateChanged(itemEvent);
            }
        });
        this.panelTransition.add(this.rbFalling);
        this.buttonGroupTransitionType.add(this.rbEither);
        this.rbEither.setSelected(true);
        this.rbEither.setText("Either");
        this.rbEither.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                EventProperties.this.rbEitherItemStateChanged(itemEvent);
            }
        });
        this.panelTransition.add(this.rbEither);
        this.cardEventBased.add((Component)this.panelTransition, "Transition");
        this.panelCounter.setLayout(new FlowLayout(0));
        this.jLabel20.setText("Counter Value");
        this.panelCounter.add(this.jLabel20);
        this.txtCounterValue.setMinimumSize(new Dimension(60, 19));
        this.txtCounterValue.setPreferredSize(new Dimension(60, 19));
        this.txtCounterValue.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent caretEvent) {
                EventProperties.this.txtCounterValueCaretUpdate(caretEvent);
            }
        });
        this.panelCounter.add(this.txtCounterValue);
        this.cardEventBased.add((Component)this.panelCounter, "Counter");
        this.panelUsageMeter.setLayout(new FlowLayout(0));
        this.jLabel22.setText("Usage Meter Value");
        this.panelUsageMeter.add(this.jLabel22);
        this.txtUsageValue.setMinimumSize(new Dimension(60, 19));
        this.txtUsageValue.setPreferredSize(new Dimension(60, 19));
        this.txtUsageValue.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent caretEvent) {
                EventProperties.this.txtUsageValueCaretUpdate(caretEvent);
            }
        });
        this.panelUsageMeter.add(this.txtUsageValue);
        this.jLabel19.setText("hrs");
        this.panelUsageMeter.add(this.jLabel19);
        this.cardEventBased.add((Component)this.panelUsageMeter, "Usage");
        this.panelAnalog.setLayout(new GridBagLayout());
        this.onRising.setText("On Rising:");
        this.onRising.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.onRising.setHorizontalTextPosition(10);
        this.onRising.setMargin(new Insets(0, 0, 0, 0));
        this.onRising.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                EventProperties.this.onRisingItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelAnalog.add((Component)this.onRising, gridBagConstraints);
        this.jLabel10.setText("Trigger Value:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.panelAnalog.add((Component)this.jLabel10, gridBagConstraints);
        this.txtActivateValue.setMinimumSize(new Dimension(40, 20));
        this.txtActivateValue.setPreferredSize(new Dimension(40, 19));
        this.txtActivateValue.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent caretEvent) {
                EventProperties.this.txtActivateValueCaretUpdate(caretEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelAnalog.add((Component)this.txtActivateValue, gridBagConstraints);
        this.jLabel11.setText("Reset Value:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.panelAnalog.add((Component)this.jLabel11, gridBagConstraints);
        this.txtDeactivateValue.setMinimumSize(new Dimension(40, 20));
        this.txtDeactivateValue.setPreferredSize(new Dimension(40, 19));
        this.txtDeactivateValue.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent caretEvent) {
                EventProperties.this.txtDeactivateValueCaretUpdate(caretEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelAnalog.add((Component)this.txtDeactivateValue, gridBagConstraints);
        this.cardEventBased.add((Component)this.panelAnalog, "Analog");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 20, 0, 0);
        this.panelEventBased.add((Component)this.cardEventBased, gridBagConstraints);
        this.combDeviceSelect.setModel(new DefaultComboBoxModel<String>(new String[]{"Digital In 1 - 8", "Relay Out 1 - 8", "Ext. Temp. Probe (8 bit)", "Ext. Temp. Probe (12 bit)", "Relay Out 9 - 16", "Ext. RTD Temp. Module", "Ext. 10V Analog Module (Input)", "Ext. 10V Analog Module (Output)", "Ext. 4-20mA Analog Module (Input)", "Ext. 4-20mA Analog Module (Output)"}));
        this.combDeviceSelect.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                EventProperties.this.combDeviceSelectItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 10, 0);
        this.panelEventBased.add((Component)this.combDeviceSelect, gridBagConstraints);
        this.combIOSelect.setModel(new DefaultComboBoxModel<String>(new String[]{"Digital In 1", "Digital In 2", "Digital In 3", "Digital In 4", "Digital In 5", "Digital In 6", "Digital In 7", "Digital In 8"}));
        this.combIOSelect.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                EventProperties.this.combIOSelectItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelEventBased.add((Component)this.combIOSelect, gridBagConstraints);
        this.jLabel13.setText("Device:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 20, 10, 0);
        this.panelEventBased.add((Component)this.jLabel13, gridBagConstraints);
        this.jLabel14.setText("I/O:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        this.panelEventBased.add((Component)this.jLabel14, gridBagConstraints);
        this.jLabel15.setText("Location:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 180, 0, 0);
        this.panelEventBased.add((Component)this.jLabel15, gridBagConstraints);
        this.combLocationSelect.setModel(new DefaultComboBoxModel<String>(new String[]{"Built in"}));
        this.combLocationSelect.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                EventProperties.this.combLocationSelectItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelEventBased.add((Component)this.combLocationSelect, gridBagConstraints);
        this.cardEventType.add((Component)this.panelEventBased, "EventBased");
        this.panelLogical.setLayout(new BorderLayout());
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setFont(new Font("Arial", 0, 12));
        this.jTextArea1.setRows(5);
        this.jTextArea1.setText("Enter your Logical Expression above that when satisfied will execute the Actions below.\nYou can use inputs and outputs (dinX, routX where X is the input or output number), \nlogical functions AND, OR, NOT, XOR and parentheses ( ).\n   \nExample Logical Expression      (din1 AND NOT din2) OR rout3");
        this.jTextArea1.setOpaque(false);
        this.panelLogical.add((Component)this.jTextArea1, "Center");
        this.jLabel12.setText("Logical Expression");
        this.jPanel3.add(this.jLabel12);
        this.txtLogicalExpression.setPreferredSize(new Dimension(200, 20));
        this.txtLogicalExpression.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent caretEvent) {
                EventProperties.this.txtLogicalExpressionCaretUpdate(caretEvent);
            }
        });
        this.txtLogicalExpression.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                EventProperties.this.txtLogicalExpressionKeyTyped(keyEvent);
            }
        });
        this.jPanel3.add(this.txtLogicalExpression);
        this.panelLogical.add((Component)this.jPanel3, "North");
        this.cardEventType.add((Component)this.panelLogical, "Logical");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.cardEventType, gridBagConstraints);
        this.jPanel12.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.jPanel12.setMinimumSize(new Dimension(505, 167));
        this.jPanel12.setLayout(new BorderLayout());
        this.jScrollPane1.setPreferredSize(new Dimension(250, 100));
        this.jScrollPane1.setViewportView(this.lvwActions);
        this.jPanel12.add((Component)this.jScrollPane1, "Center");
        this.jPanel14.setLayout(new GridLayout(6, 0));
        this.buttonMoveUp.setBackground(new Color(200, 200, 200));
        this.buttonMoveUp.setText("Move Up");
        this.buttonMoveUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EventProperties.this.buttonMoveUpActionPerformed(actionEvent);
            }
        });
        this.jPanel14.add(this.buttonMoveUp);
        this.buttonMoveDown.setBackground(new Color(200, 200, 200));
        this.buttonMoveDown.setText("Move Down");
        this.buttonMoveDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EventProperties.this.buttonMoveDownActionPerformed(actionEvent);
            }
        });
        this.jPanel14.add(this.buttonMoveDown);
        this.jPanel14.add(this.jPanel13);
        this.buttonAddAction.setBackground(new Color(200, 200, 200));
        this.buttonAddAction.setText("Add Action");
        this.buttonAddAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EventProperties.this.buttonAddActionActionPerformed(actionEvent);
            }
        });
        this.jPanel14.add(this.buttonAddAction);
        this.buttonRemoveAction.setBackground(new Color(200, 200, 200));
        this.buttonRemoveAction.setText("Remove Action");
        this.buttonRemoveAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EventProperties.this.buttonRemoveActionActionPerformed(actionEvent);
            }
        });
        this.jPanel14.add(this.buttonRemoveAction);
        this.buttonEditAction.setBackground(new Color(200, 200, 200));
        this.buttonEditAction.setText("Edit Action");
        this.buttonEditAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EventProperties.this.buttonEditActionActionPerformed(actionEvent);
            }
        });
        this.jPanel14.add(this.buttonEditAction);
        this.jPanel12.add((Component)this.jPanel14, "East");
        this.jPanel6.setLayout(new GridBagLayout());
        this.jLabel3.setText("Actions");
        this.jLabel3.setMinimumSize(new Dimension(60, 14));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 17;
        gridBagConstraints.anchor = 18;
        this.jPanel6.add((Component)this.jLabel3, gridBagConstraints);
        this.txtActionsSize.setText("/255");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 315, 0, 106);
        this.jPanel6.add((Component)this.txtActionsSize, gridBagConstraints);
        this.txtAction.setText("jTextField1");
        this.txtAction.setMinimumSize(new Dimension(64, 19));
        this.txtAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EventProperties.this.txtActionActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 250, 0, 0);
        this.jPanel6.add((Component)this.txtAction, gridBagConstraints);
        this.jPanel12.add((Component)this.jPanel6, "North");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.jPanel12, gridBagConstraints);
    }

    private void txtDeactivateValueCaretUpdate(CaretEvent caretEvent) {
        this.compare();
    }

    private void combLocationSelectItemStateChanged(ItemEvent itemEvent) {
        this.compare();
    }

    private void combIOSelectItemStateChanged(ItemEvent itemEvent) {
        this.compare();
    }

    private void txtActivateValueCaretUpdate(CaretEvent caretEvent) {
        this.compare();
    }

    private void onRisingItemStateChanged(ItemEvent itemEvent) {
        this.compare();
    }

    private void rbEitherItemStateChanged(ItemEvent itemEvent) {
        this.compare();
    }

    private void rbFallingItemStateChanged(ItemEvent itemEvent) {
        this.compare();
    }

    private void rbRisingItemStateChanged(ItemEvent itemEvent) {
        this.compare();
    }

    private void combDeviceSelectItemStateChanged(ItemEvent itemEvent) {
        String[] stringArray;
        this.combIOSelect.removeAllItems();
        String[] stringArray2 = new String[]{"None"};
        int n = this.combDeviceSelect.getSelectedIndex();
        if (n == 0) {
            stringArray = new String[]{"Digital In 1", "Digital In 2", "Digital In 3", "Digital In 4", "Digital In 5", "Digital In 6", "Digital In 7", "Digital In 8"};
            stringArray2 = stringArray;
        } else if (n == 1) {
            stringArray = new String[]{"Relay Out 1", "Relay Out 2", "Relay Out 3", "Relay Out 4", "Relay Out 5", "Relay Out 6", "Relay Out 7", "Relay Out 8"};
            stringArray2 = stringArray;
        } else if (n == 2 || n == 3) {
            stringArray = new String[]{"Temperature"};
            stringArray2 = stringArray;
        } else if (n == 4) {
            stringArray = new String[]{"Relay A", "Relay B", "Relay C", "Relay D"};
            stringArray2 = stringArray;
        } else if (n == 5 || n == 6 || n == 8) {
            stringArray = new String[]{"Analog In 1", "Analog  In 2", "Analog  In 3", "Analog  In 4"};
            stringArray2 = stringArray;
        } else {
            stringArray = new String[]{"Analog Out 1", "Analog Out 2"};
            stringArray2 = stringArray;
        }
        for (int i = 0; i < stringArray2.length; ++i) {
            this.combIOSelect.addItem(stringArray2[i]);
        }
        this.combLocationSelect.removeAllItems();
        if (n == 0 || n == 1) {
            this.combLocationSelect.addItem("Built in");
        } else {
            this.combLocationSelect.addItem("External 1");
            this.combLocationSelect.addItem("External 2");
        }
        if (n == 0 || n == 1 || n == 4) {
            this.rbTransition.setEnabled(true);
            if (n == 0 || n == 1) {
                this.rbUsage.setEnabled(true);
            } else {
                this.rbUsage.setEnabled(false);
                if (this.rbUsage.isSelected()) {
                    this.rbTransition.setSelected(true);
                }
            }
            if (n == 0) {
                this.rbCounter.setEnabled(true);
            } else {
                this.rbCounter.setEnabled(false);
                if (this.rbCounter.isSelected()) {
                    this.rbTransition.setSelected(true);
                }
            }
            this.rbAnalog.setEnabled(false);
            if (this.rbAnalog.isSelected()) {
                this.rbTransition.setSelected(true);
            }
        } else {
            this.rbTransition.setEnabled(false);
            this.rbUsage.setEnabled(false);
            this.rbCounter.setEnabled(false);
            this.rbAnalog.setEnabled(true);
            this.rbAnalog.setSelected(true);
        }
        this.compare();
    }

    private void rbAnalogItemStateChanged(ItemEvent itemEvent) {
        if (this.rbAnalog.isSelected()) {
            CardLayout cardLayout = (CardLayout)this.cardEventBased.getLayout();
            cardLayout.show(this.cardEventBased, "Analog");
        }
        this.compare();
    }

    private void rbEither1transitionActionPerformed(ActionEvent actionEvent) {
    }

    private void rbFalling1transitionActionPerformed(ActionEvent actionEvent) {
    }

    private void rbRising1transitionActionPerformed(ActionEvent actionEvent) {
    }

    private void buttonMoveDownActionPerformed(ActionEvent actionEvent) {
        int n = this.lvwActions.getSelectedIndex();
        Object e = this.modelActions.getElementAt(n);
        if (n < 0 || n == this.modelActions.getSize() - 1 || e == null) {
            return;
        }
        this.modelActions.removeElement(e);
        this.modelActions.insertElementAt(e, ++n);
        this.setActionText();
        this.lvwActions.setSelectedIndex(n);
    }

    private void buttonMoveUpActionPerformed(ActionEvent actionEvent) {
        int n;
        Object e = null;
        if (this.modelActions.getSelectedItem() != null) {
            e = this.lvwActions.getSelectedValue();
        }
        if ((n = this.lvwActions.getSelectedIndex()) <= 0 || e == null) {
            return;
        }
        this.modelActions.removeElement(e);
        this.modelActions.insertElementAt(e, --n);
        this.setActionText();
        if (e != null) {
            this.lvwActions.setSelectedValue(e, true);
        }
    }

    private void chkAllItemStateChanged(ItemEvent itemEvent) {
        if (this.chkAll.isSelected() == this.allDays) {
            return;
        }
        if (!this.chkAll.isSelected()) {
            this.allDays = this.chkAll.isSelected();
        }
        this.chkSun.setSelected(this.chkAll.isSelected());
        this.chkMon.setSelected(this.chkAll.isSelected());
        this.chkTue.setSelected(this.chkAll.isSelected());
        this.chkWed.setSelected(this.chkAll.isSelected());
        this.chkThu.setSelected(this.chkAll.isSelected());
        this.chkFri.setSelected(this.chkAll.isSelected());
        this.chkSat.setSelected(this.chkAll.isSelected());
        this.allDays = this.chkAll.isSelected();
        this.compare();
    }

    private void txtUsageValueCaretUpdate(CaretEvent caretEvent) {
        this.compare();
    }

    private void txtCounterValueCaretUpdate(CaretEvent caretEvent) {
        this.compare();
    }

    private void rbUsageItemStateChanged(ItemEvent itemEvent) {
        if (this.rbUsage.isSelected()) {
            CardLayout cardLayout = (CardLayout)this.cardEventBased.getLayout();
            cardLayout.show(this.cardEventBased, "Usage");
        }
        this.compare();
    }

    private void rbCounterItemStateChanged(ItemEvent itemEvent) {
        if (this.rbCounter.isSelected()) {
            CardLayout cardLayout = (CardLayout)this.cardEventBased.getLayout();
            cardLayout.show(this.cardEventBased, "Counter");
        }
        this.compare();
    }

    private void rbTransitionItemStateChanged(ItemEvent itemEvent) {
        if (this.rbTransition.isSelected()) {
            CardLayout cardLayout = (CardLayout)this.cardEventBased.getLayout();
            cardLayout.show(this.cardEventBased, "Transition");
        }
        this.compare();
    }

    private void txtActionActionPerformed(ActionEvent actionEvent) {
        this.compare();
    }

    private void buttonEditActionActionPerformed(ActionEvent actionEvent) {
        Object e = this.lvwActions.getSelectedValue();
        if (e == null) {
            JOptionPane.showMessageDialog(this, "You must select an action to edit", "Please select an action", 0);
            return;
        }
        String string = e.toString();
        ActionDialog actionDialog = new ActionDialog((Frame)SwingUtilities.getRoot(this), true, this.main);
        actionDialog.loadAction(string);
        actionDialog.centerParent();
        actionDialog.setVisible(true);
        if (actionDialog.getReturnStatus() == 1) {
            int n = this.lvwActions.getSelectedIndex();
            this.modelActions.removeElement(e);
            this.modelActions.insertElementAt(actionDialog.getAction(), n);
            this.setActionText();
            this.lvwActions.setSelectedValue(e, true);
        }
    }

    private void buttonRemoveActionActionPerformed(ActionEvent actionEvent) {
        Object e = this.lvwActions.getSelectedValue();
        if (e == null) {
            JOptionPane.showMessageDialog(this, "You must select an action to remove", "Please select an action", 0);
            return;
        }
        String string = e.toString();
        if (JOptionPane.showConfirmDialog(this, "Are you usure you want to delete the selected action(s)?", "Confirm Delete", 2) == 0) {
            int[] nArray = this.lvwActions.getSelectedIndices();
            for (int i = nArray.length - 1; i >= 0; --i) {
                this.modelActions.removeElementAt(nArray[i]);
            }
            if (nArray.length == 1) {
                nArray[0] = nArray[0] - 1;
                this.lvwActions.setSelectedIndex(nArray[0]);
            }
            this.setActionText();
            if (this.modelActions.getSize() == 0) {
                return;
            }
        }
    }

    private void buttonAddActionActionPerformed(ActionEvent actionEvent) {
        ActionDialog actionDialog = new ActionDialog((Frame)SwingUtilities.getRoot(this), true, this.main);
        actionDialog.centerParent();
        actionDialog.setVisible(true);
        if (actionDialog.getReturnStatus() == 1) {
            this.addAction(actionDialog.getAction());
            this.setActionText();
        }
    }

    private void intervalCaretUpdate(CaretEvent caretEvent) {
        this.compare();
    }

    private void chkRecurringItemStateChanged(ItemEvent itemEvent) {
        this.txtIntervalHours.setEnabled(this.chkRecurring.isSelected());
        this.txtIntervalMinutes.setEnabled(this.chkRecurring.isSelected());
        this.txtIntervalSeconds.setEnabled(this.chkRecurring.isSelected());
        this.compare();
        this.timePickerEnd.setEnabled(this.chkRecurring.isSelected());
    }

    private void eventTypeItemStateChanged(ItemEvent itemEvent) {
        CardLayout cardLayout = (CardLayout)this.cardEventType.getLayout();
        if (itemEvent.getSource() == this.rbTimeBased) {
            cardLayout.show(this.cardEventType, "TimeBased");
        } else if (itemEvent.getItem() == this.rbEventBased) {
            cardLayout.show(this.cardEventType, "EventBased");
        } else if (itemEvent.getItem() == this.rbLogical) {
            cardLayout.show(this.cardEventType, "Logical");
        }
        if (this.rbTimeBased.isSelected() && this.chkRecurring.isSelected()) {
            this.timePickerEnd.setEnabled(true);
        } else if (this.rbEventBased.isSelected()) {
            this.timePickerEnd.setEnabled(true);
        } else if (this.rbLogical.isSelected()) {
            this.timePickerEnd.setEnabled(true);
        } else {
            this.timePickerEnd.setEnabled(false);
        }
        this.compare();
    }

    private void daysOfWeekItmStateChanged(ItemEvent itemEvent) {
        int n = 0;
        if (this.chkSun.isSelected()) {
            n |= 0x40;
        }
        if (this.chkMon.isSelected()) {
            n |= 0x20;
        }
        if (this.chkTue.isSelected()) {
            n |= 0x10;
        }
        if (this.chkWed.isSelected()) {
            n |= 8;
        }
        if (this.chkThu.isSelected()) {
            n |= 4;
        }
        if (this.chkFri.isSelected()) {
            n |= 2;
        }
        if (this.chkSat.isSelected()) {
            n |= 1;
        }
        if (n == 127) {
            this.allDays = true;
            this.chkAll.setSelected(true);
        } else if (this.allDays && this.chkAll.isSelected()) {
            this.allDays = false;
            this.chkAll.setSelected(false);
        }
        this.compare();
    }

    private void chkEnabledItemStateChanged(ItemEvent itemEvent) {
        this.compare();
    }

    private void txtNameCaretUpdate(CaretEvent caretEvent) {
        this.compare();
    }

    private void txtLogicalExpressionKeyTyped(KeyEvent keyEvent) {
        this.compare();
    }

    private void txtLogicalExpressionCaretUpdate(CaretEvent caretEvent) {
        this.compare();
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.compare();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.compare();
    }
}

