/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.collections;

import com.integpg.janoslib.collections.LinkedListNode;

public class LinkedList {
    private LinkedListNode _head = null;

    public int getLength() {
        int length = 0;
        LinkedListNode node = this._head;
        while (null != node) {
            node = node.getNextNode();
            ++length;
        }
        return length;
    }

    public LinkedListNode getFirstNode() {
        return this._head;
    }

    public void addNode(LinkedListNode newNode) {
        if (null == this._head) {
            this._head = newNode;
        } else {
            LinkedListNode node;
            LinkedListNode prevNode = null;
            for (node = this._head; null != node; node = node.getNextNode()) {
                if (node.shouldInsertNode(newNode)) {
                    if (null == prevNode) {
                        newNode.setNextNode(this._head);
                        this._head = newNode;
                    } else {
                        newNode.setNextNode(prevNode.getNextNode());
                        prevNode.setNextNode(newNode);
                    }
                    return;
                }
                if (null == node.getNextNode()) break;
                prevNode = node;
            }
            node.setNextNode(newNode);
        }
    }

    public void removeNode(LinkedListNode oldNode) {
        if (null != this._head) {
            LinkedListNode prevNode = null;
            for (LinkedListNode node = this._head; null != node; node = node.getNextNode()) {
                if (node == oldNode) {
                    if (null != prevNode) {
                        prevNode.setNextNode(oldNode.getNextNode());
                    } else {
                        this._head = oldNode.getNextNode();
                    }
                    return;
                }
                if (null == node.getNextNode()) break;
                prevNode = node;
            }
        }
    }

    public void printList() {
        System.out.println(this.getLength() + " nodes");
        System.out.println(this._head.toString());
    }

    public LinkedListNode pop() {
        LinkedListNode head = this._head;
        this._head = this._head.getNextNode();
        return head;
    }
}

