/*
 * Decompiled with CFR 0.152.
 */
package JniorProtocol.Devices;

import JniorProtocol.Devices.Jr310Internals;
import JniorProtocol.Exceptions.NotLoggedInException;
import JniorProtocol.Exceptions.NotYetConnectedException;
import JniorProtocol.JniorSession;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public abstract class Jr310InternalInput
extends Jr310Internals {
    public byte m_alarmState = 0;
    public long m_count = 0L;
    public byte m_countAlarm1 = 0;
    public byte m_countAlarm2 = 0;
    private boolean m_fromMonitorPacket = false;
    private Jr310InternalInput m_lastState = null;

    public Jr310InternalInput(JniorSession jniorSession, int n) {
        super(jniorSession);
        this.m_channel = n + 1;
        this.m_address = (this.m_channel << 8) + 255;
    }

    public void resetLatch() throws NotYetConnectedException, NotLoggedInException {
        this.m_session.isLoggedIn();
        this.buildCommandPacket(4, this.m_channel);
    }

    public void clearCounter() throws NotYetConnectedException, NotLoggedInException {
        this.m_session.isLoggedIn();
        this.buildCommandPacket(5, this.m_channel);
    }

    public void clearUsageMeter() throws NotYetConnectedException, NotLoggedInException {
        this.m_session.isLoggedIn();
        this.buildCommandPacket(8, this.m_channel);
    }

    public void receive(ByteArrayInputStream byteArrayInputStream, boolean bl) {
        this.m_fromMonitorPacket = bl;
        this.receive(byteArrayInputStream);
    }

    public void receive(ByteArrayInputStream byteArrayInputStream) {
        try {
            this.m_currentState = (byte)Jr310InternalInput.get(byteArrayInputStream);
            this.m_session.getInternalsInstance().m_inputStates = this.m_currentState == 1 ? (this.m_session.getInternalsInstance().m_inputStates |= 1 << this.m_channel - 1) : (this.m_session.getInternalsInstance().m_inputStates &= ~(1 << this.m_channel - 1));
            this.m_alarmState = (byte)Jr310InternalInput.get(byteArrayInputStream);
            this.m_count = Jr310InternalInput.getInt(byteArrayInputStream);
            this.m_countAlarm1 = (byte)Jr310InternalInput.get(byteArrayInputStream);
            this.m_countAlarm2 = (byte)Jr310InternalInput.get(byteArrayInputStream);
            if (!this.m_fromMonitorPacket) {
                this.m_usageMeter = Jr310InternalInput.getLong(byteArrayInputStream);
                this.m_usageAlarm = (byte)Jr310InternalInput.get(byteArrayInputStream);
            }
            if (!this.compareTo(this.m_lastState)) {
                this.m_lastState = (Jr310InternalInput)this.clone();
                this.fireStateChange();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public boolean compareTo(Object object) {
        Jr310InternalInput jr310InternalInput = (Jr310InternalInput)object;
        if (object == null) {
            return false;
        }
        if (jr310InternalInput.m_currentState != this.m_currentState) {
            return false;
        }
        if (jr310InternalInput.m_alarmState != this.m_alarmState) {
            return false;
        }
        if (jr310InternalInput.m_count != this.m_count) {
            return false;
        }
        if (jr310InternalInput.m_countAlarm1 != this.m_countAlarm1) {
            return false;
        }
        if (jr310InternalInput.m_countAlarm2 != this.m_countAlarm2) {
            return false;
        }
        if (jr310InternalInput.m_usageMeter != this.m_usageMeter) {
            return false;
        }
        return jr310InternalInput.m_usageAlarm == this.m_usageAlarm;
    }

    public Object clone() {
        AbstractInput abstractInput = new AbstractInput(this.m_session, this.m_channel);
        abstractInput.m_currentState = this.m_currentState;
        abstractInput.m_alarmState = this.m_alarmState;
        abstractInput.m_count = this.m_count;
        abstractInput.m_countAlarm1 = this.m_countAlarm1;
        abstractInput.m_countAlarm2 = this.m_countAlarm2;
        abstractInput.m_usageMeter = this.m_usageMeter;
        abstractInput.m_usageAlarm = this.m_usageAlarm;
        return abstractInput;
    }

    public String toString() {
        return "Input " + this.m_channel + " : " + (this.m_currentState == 1 ? " ON" : " OFF") + " Count: " + this.m_count;
    }

    class AbstractInput
    extends Jr310InternalInput {
        public AbstractInput(JniorSession jniorSession, int n) {
            super(jniorSession, n);
        }
    }
}

