 /*
  JNIOR Monitor/Configuration Page
  INTEG Process Group, Inc., 2919 E Hardies Rd, Gibsonia PA 
  724.933.9350
  
  File: peers.js
  
  The user is hereby granted license to use, modify, and redistribute the contents of this
  file for any purpose, commercial or otherwise. No prior authorization by INTEG Process 
  Group, Inc. is required.
*/ 

// Active peer array
var peers = new Array();

// peer display update flag
var peer_update = false;

// initialize the syslog on new connection
var peers_onopen = chan.onopen;
chan.onopen = function(evt) {
	
	// Request peer data
 	var meta = new Object();
 	meta['Op'] = "peers";
    	
	var request = new Object();
	request['Message'] = "Registry List";
	request['Meta'] = meta;
	request['Node'] = "Peers";
  chan.sendJson(request);

	// clear any prior syslog content
	document.getElementById("peertable").innerHTML = "";
	
	// chain
	if (peers_onopen)
		peers_onopen(evt);
}

// message processing
var peers_onmessage = chan.onmessage;
chan.onmessage = function(evt) {
	var jobj = JSON.parse(evt.data);

	if (jobj['Message'] === 'Registry List Response') {
		var meta = jobj['Meta'];
		var op = meta['Op'];
		
	 	// process operations for the Peers page
	 	if (op === "peers") {
			var keys = jobj['Keys'];
			
	 		var request = new Object();
	 		request['Message'] = "Registry Read";
	 		request['Meta'] = meta;
	 		request['Keys'] = keys;
	 		chan.sendJson(request);
	 	}
	}

	else if (jobj['Message'] === 'Registry Response') {
		var meta = jobj['Meta'];
		if (meta) {
			var op = meta['Op'];
			
		 	// process operations for the Peers page
		 	if (op === "peers") {
				var keys = jobj['Keys'];
				
				peer_update = true;
				peers = new Array();
				for (key in keys) {
			   	var keylower = keystd(key);
		    	var keyvalue = keys[key];
		    	
		    	var pos = keylower.indexOf("$");
		    	if (pos >= 0) {
		    		var sn_string = keylower.substring(pos + 1);
		    		var sn = parseInt(sn_string);
		    		if (sn.toString() === sn_string) {
		    			peers[sn_string] = keyvalue;
		    		}	    		
		    	}
	    	}
			}
	 	}
	}

	else if (jobj['Message'] === 'Registry Update') {
		var keys = jobj['Keys'];
    for (key in keys) {
	   	var keylower = keystd(key);
	   	if (keylower.startsWith("peers/")) {
		   	var keylower = keystd(key);
	    	var keyvalue = keys[key];
	    	
	    	var pos = keylower.indexOf("$");
	    	if (pos >= 0) {
	   			peer_update = true;
	    		var sn_string = keylower.substring(pos + 1);
	    		var sn = parseInt(sn_string);
	    		if (sn.toString() === sn_string) {
	    			if (keyvalue.length > 0)
	    				peers[sn_string] = keyvalue;
	    			else
	    				delete peers[sn_string];
	    		}	    		
		    }
	   	}
	 	}
	}
	
	// updates the peer display as something likely changed
	if (peer_update) {
		peer_update = false;
		
		// determine protocol (http or https)
		prot = window.location.protocol + "//";
		
		// obtain a non-relational sorted array
		var arr = new Array();
		var cnt = 0;
		var models = new Array(0,0,310,312,314,0,410,412,414,"412DMX");
		for (sn in peers) {
			// insert model
			var model = models[sn.toString().substr(0, 1)];
			var peer = peers[sn];
			var p = peer.indexOf(' ');
			arr[cnt++] = peer.substring(0, p + 1) + model + peer.substring(p);
		}

		if (cnt == 0) {
			var content = "<tr><td>None Available.</td></tr>";
		}		
		else {
			// sort units
			arr.sort(comp_peers);
			
			// update table
			var content = "";
			if (cnt > 12) {
				
				// separate into columns
				var c = Math.ceil(cnt/2);		

				for (n = 0; n < c; n++) {
					content += "<tr>" + peer_entry(arr[n]);
					if (c + n < cnt) 
						content += peer_entry(arr[c + n]);
					else
						content += "<td></td><td></td>";
					content += "</tr>";
				}
			}
			else {
				for (n = 0; n < cnt; n++) {
					content += "<tr>" + peer_entry(arr[n]) + "</tr>";
				}
			}
		}
		
		var stats = document.getElementById("peerstats");
		stats.innerHTML = cnt + " unit" + (cnt != 1 ? "s" : "") + " found";
		
		document.getElementById("peerdata").className = "";
		var elem = document.getElementById("peertable");
		elem.innerHTML = content;
		elem.style = "width:" + (cnt <= 12 ? "50%" : "100%");
	}

	if (peers_onmessage)
		peers_onmessage(evt);	// chain message processing
}

// format peers entry
function peer_entry(ent) {
		var p = ent.indexOf(" ");
		var ip = ent.substring(0, p);
		var hst = ent.substring(p + 1);
		if (hst.substr(0, 1) == "4")
			var str = "<td><a href='" + prot + ip + "' target='_blank'>" + ip + "</a></td><td>" + hst + "</td>";
		else
			var str = "<td>" + ip + "</td><td>" + hst + "</td>";
		return str;
}

// sorting compare function
function comp_peers(a, b) {
	
	// IP address comparison
	var pa = a.indexOf('.');		
	var pb = b.indexOf('.');		
	var na = parseInt(a.substring(0, pa));
	var nb = parseInt(b.substring(0, pb));
	if (na != nb)
		return (na - nb);

	a = a.substring(pa + 1);
	b = b.substring(pb + 1);	
	pa = a.indexOf('.');		
	pb = b.indexOf('.');		
	na = parseInt(a.substring(0, pa));
	nb = parseInt(b.substring(0, pb));
	if (na != nb)
		return (na - nb);
	
	a = a.substring(pa + 1);
	b = b.substring(pb + 1);	
	pa = a.indexOf('.');		
	pb = b.indexOf('.');		
	na = parseInt(a.substring(0, pa));
	nb = parseInt(b.substring(0, pb));
	if (na != nb)
		return (na - nb);
	
	a = a.substring(pa + 1);
	b = b.substring(pb + 1);	
	pa = a.indexOf(' ');		
	pb = b.indexOf(' ');		
	na = parseInt(a.substring(0, pa));
	nb = parseInt(b.substring(0, pb));
	return (na - nb);
}

// function to cause peer list refresh
function peerrefresh(evt) {
	var request = new Object();
	request['Message'] = "Peer Refresh";
  chan.sendJson(request);
}
