/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.slaveservice;

import com.integpg.janoslib.io.AppLog;
import com.integpg.slaveservice.JniorConnectionListener;
import com.integpg.system.JANOS;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Vector;

public class JniorConnection
implements Runnable {
    public Vector _listeners = new Vector();
    private final String IPAddress;
    private final String _username;
    private final String _password;
    private final int _port;
    private boolean shutdown = false;
    private int _inputs;
    private int _outputs;
    private boolean _goodConnection = false;

    public JniorConnection(String ipAddress, int port, String username, String password) {
        this.IPAddress = ipAddress;
        this._port = 0 != port ? port : 9200;
        this._username = !"".equals(username) ? username : "jnior";
        this._password = !"".equals(password) ? password : "jnior";
    }

    public String getIPAddress() {
        return this.IPAddress;
    }

    public boolean getConnectionState() {
        return this._goodConnection;
    }

    public void addConnectionListener(JniorConnectionListener listener) {
        this._listeners.addElement(listener);
    }

    private void alertConnectionEstablished() {
        for (int i = 0; i < this._listeners.size(); ++i) {
            JniorConnectionListener jcl = (JniorConnectionListener)this._listeners.elementAt(i);
            jcl.connectionEstablished();
        }
    }

    private void alertConnectionLost() {
        System.out.println("alerting connection lost");
        for (int i = 0; i < this._listeners.size(); ++i) {
            JniorConnectionListener jcl = (JniorConnectionListener)this._listeners.elementAt(i);
            jcl.connectionLost();
        }
    }

    public int getInputStates() {
        return this._inputs;
    }

    public int getOutputStates() {
        return this._outputs;
    }

    public void start() {
        Thread thd = new Thread(this);
        thd.setDaemon(true);
        thd.setName("Jnior Connection: " + this.IPAddress);
        thd.start();
    }

    @Override
    public void run() {
        FilterInputStream jIn = null;
        FilterOutputStream jOut = null;
        long keepAlive = 0L;
        Socket jRemote = null;
        byte MsgType = 0;
        this.shutdown = false;
        block18: while (!this.shutdown) {
            try {
                int port = 0 != this._port ? this._port : 9200;
                jRemote = new Socket(InetAddress.getByName(this.IPAddress), port);
                this.alertConnectionEstablished();
                jIn = new DataInputStream(jRemote.getInputStream());
                jOut = new DataOutputStream(new BufferedOutputStream(jRemote.getOutputStream(), 4096));
                ByteArrayOutputStream dataBytes = new ByteArrayOutputStream();
                DataOutputStream data = new DataOutputStream(dataBytes);
                data.writeByte(126);
                this.writeString(this._username, data);
                this.writeString(this._password, data);
                System.out.println(this.IPAddress + "   Remote UserName: " + this._username);
                System.out.println(this.IPAddress + "   Remote Password: " + this._password);
                data.flush();
                this.sendMsg(dataBytes.toByteArray(), (DataOutputStream)jOut);
                jRemote.setSoTimeout(15000);
                AppLog.info("send login");
                while (!this.shutdown) {
                    long lastActivity = JANOS.uptimeMillis();
                    if (!this.shutdown) {
                        try {
                            while (((DataInputStream)jIn).readByte() != 1) {
                                lastActivity = JANOS.uptimeMillis();
                            }
                        }
                        catch (InterruptedIOException iioe) {
                            AppLog.info(this.IPAddress + " SlaveService " + this.IPAddress + " connection lost");
                            throw new EOFException();
                        }
                    }
                    if (this.shutdown) {
                        AppLog.info("shutdown");
                        continue block18;
                    }
                    byte[] msg = this.getMsg((DataInputStream)jIn);
                    if (msg == null || msg.length == 0) continue;
                    this._goodConnection = true;
                    DataInputStream in = new DataInputStream(new ByteArrayInputStream(msg));
                    MsgType = in.readByte();
                    System.out.println(this.IPAddress + "   MsgType: " + MsgType);
                    switch (MsgType) {
                        case 1: {
                            this.parseMonitor(in);
                            break;
                        }
                        case 2: {
                            this.parseExtendedMonitor(in);
                            break;
                        }
                        case 125: {
                            AppLog.info(this.IPAddress + " SlaveService login " + this.IPAddress + ":" + this._port);
                            dataBytes.reset();
                            data.writeByte(5);
                            data.writeShort(1);
                            data.writeInt(10000);
                            data.flush();
                            this.sendMsg(dataBytes.toByteArray(), (DataOutputStream)jOut);
                            break;
                        }
                    }
                    if (JANOS.uptimeMillis() <= keepAlive + 300000L) continue;
                    keepAlive = JANOS.uptimeMillis();
                    ((DataOutputStream)jOut).writeByte(6);
                    ((DataOutputStream)jOut).flush();
                }
            }
            catch (EOFException ex) {
                block29: {
                    ex.printStackTrace();
                    try {
                        if (!this._goodConnection) {
                            this.alertConnectionLost();
                        }
                        this._goodConnection = false;
                        if (jIn != null) {
                            jIn.close();
                        }
                        if (jOut != null) {
                            jOut.close();
                        }
                        if (jRemote == null) break block29;
                        jRemote.close();
                    }
                    catch (IOException ioe4) {
                        this.logException(4, ioe4);
                        break;
                    }
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {}
            }
            catch (IOException ex) {
                block30: {
                    ex.printStackTrace();
                    try {
                        if (jIn != null) {
                            jIn.close();
                        }
                        if (jOut != null) {
                            jOut.close();
                        }
                        if (jRemote == null) break block30;
                        jRemote.close();
                    }
                    catch (IOException ioe3) {
                        this.logException(3, ioe3);
                        break;
                    }
                }
                if (!this._goodConnection) {
                    this.alertConnectionLost();
                }
                this._goodConnection = false;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {}
            }
        }
        AppLog.info(this.IPAddress + " connection ended");
    }

    private void parseMonitor(DataInputStream in) throws IOException {
        byte state;
        int n;
        int inputs = 0;
        int outputs = 0;
        String modelAndVersion = this.readString(in);
        for (n = 0; n < 8; ++n) {
            state = in.readByte();
            inputs |= state << n;
            in.skip(7L);
        }
        this._inputs = inputs;
        for (n = 0; n < 8; ++n) {
            state = in.readByte();
            outputs |= state << n;
        }
        this._outputs = outputs;
        long time = in.readLong();
    }

    private void parseExtendedMonitor(DataInputStream in) throws IOException {
        int inputs = this._inputs;
        int outputs = this._outputs;
        int inputCount = in.readByte();
        for (int n = 0; n < inputCount; ++n) {
            byte state = in.readByte();
            inputs |= state << n + 8;
        }
        this._inputs = inputs;
        int outputCount = in.readByte();
        for (int n = 0; n < outputCount; ++n) {
            byte state = in.readByte();
            outputs |= state << n + 8;
        }
        this._outputs = outputs;
        long time = in.readLong();
    }

    private String readString(DataInputStream in) throws IOException {
        byte[] bData = new byte[in.readByte() & 0xFF];
        in.read(bData);
        return new String(bData);
    }

    private void writeString(String str, DataOutputStream out) throws IOException {
        if (str.length() < 255) {
            out.writeByte(str.length());
            out.writeBytes(str);
        } else {
            out.writeByte(255);
            out.writeBytes(str.substring(0, 255));
        }
    }

    private byte[] getMsg(DataInputStream in) throws IOException {
        short len = in.readShort();
        int crc = in.readShort() & 0xFFFF;
        byte[] data = new byte[len];
        in.read(data);
        if (crc != JANOS.CRC16((byte[])data, (int)0, (int)len, (int)0)) {
            return null;
        }
        return data;
    }

    private void sendMsg(byte[] message, DataOutputStream out) throws IOException {
        if (message == null) {
            return;
        }
        out.writeByte(1);
        out.writeShort(message.length);
        out.writeShort(JANOS.CRC16((byte[])message, (int)0, (int)message.length, (int)0));
        out.write(message);
        out.flush();
    }

    private void logException(int code, Exception e) {
        String str = "SlaveService(" + code + "): " + e.toString();
        AppLog.error(this.IPAddress + " " + str);
    }

    void close() {
        this.shutdown = true;
    }
}

