/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.EmbeddedHelpers.Monitor;

import com.integpg.EmbeddedHelpers.Base.EmbeddedBase;
import com.integpg.EmbeddedHelpers.Message.MessagePump;
import com.integpg.EmbeddedHelpers.Monitor.IOStateListener;
import com.integpg.EmbeddedHelpers.Monitor.IOStateMessagePumpObject;
import com.integpg.TaskManager.UnitConfig;
import java.io.IOException;
import java.util.Vector;

public class IOStateMonitor
implements Runnable {
    public static final int INPUT = 0;
    public static final int OUTPUT = 1;
    private Thread thd;
    private boolean running;
    private IOStateListenerRunner runner;
    private EmbeddedBase base;
    protected Vector[] inputListeners = null;
    protected Vector[] outputListeners = null;
    protected long savedInputStateMask = 0L;
    protected long savedOutputStateMask = 0L;
    public long inputStateMask = 0L;
    public long outputStateMask = 0L;
    private long inputChangeMask = 0L;
    private long outputChangeMask = 0L;
    private int[] savedCounts = new int[12];
    private int[] deltaCounts = new int[12];
    private long lastIoSignature = 0L;
    private int _scanRate = 500;
    private MessagePump _msgPump = new MessagePump();
    private static IOStateMonitor _instance;

    private IOStateMonitor() {
        this.base = EmbeddedBase.BASE;
        this.runner = new IOStateListenerRunner(this._msgPump);
        String regScanRate = "AppData/" + this.base.name.replace(' ', '_') + "/IOMonitorScanRate";
        this._scanRate = this.base.m_jnioros.getRegistryInt(regScanRate, this._scanRate);
        this.base.printInfo("IO Monitor Scan Rate Set to " + this._scanRate + " milliseconds");
        try {
            this.savedInputStateMask = this.inputStateMask = (long)this.base.m_jnioros.getInputStates();
            this.savedOutputStateMask = this.outputStateMask = (long)this.base.m_jnioros.getOutputStates();
            for (int i = 0; i < 12; ++i) {
                this.savedCounts[i] = this.base.m_jnioros.getInputCounter(i);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            EmbeddedBase.BASE.log(ex.toString());
        }
    }

    public static IOStateMonitor getInstance() {
        if (_instance == null) {
            _instance = new IOStateMonitor();
            _instance.setScanRate(100);
            _instance.start();
        }
        return _instance;
    }

    public void removeStateListener(IOStateListener l, int io, int channel) {
        if (io == 0 && this.inputListeners != null && --channel < this.inputListeners.length && this.inputListeners[channel] != null && this.inputListeners[channel].contains(l)) {
            System.out.println("Removing state listener " + l + " for Input " + (channel + 1));
            this.inputListeners[channel].removeElement(l);
        }
        if (io == 1 && this.outputListeners != null && channel < this.outputListeners.length && this.outputListeners[channel] != null && this.outputListeners[channel].contains(l)) {
            System.out.println("Removing state listener " + l + " for Output " + (channel + 1));
            this.outputListeners[channel].removeElement(l);
        }
    }

    public void addStateListener(IOStateListener l, int io, int channel) {
        if (io == 0) {
            System.out.println("Adding IO State Listener " + l + " for Input " + channel);
            if (channel > 12) {
                throw new IllegalArgumentException("Channel Out of Range");
            }
            if (this.inputListeners == null) {
                this.inputListeners = new Vector[12];
            }
            if (this.inputListeners[channel - 1] == null) {
                this.inputListeners[channel - 1] = new Vector();
            }
            if (!this.inputListeners[channel - 1].contains(l)) {
                this.inputListeners[channel - 1].addElement(l);
            }
        } else if (io == 1) {
            System.out.println("Adding IO State Listener for " + l + " Output " + channel);
            if (channel > 16) {
                throw new IllegalArgumentException("Channel Out of Range");
            }
            if (this.outputListeners == null) {
                this.outputListeners = new Vector[16];
            }
            if (this.outputListeners[channel - 1] == null) {
                this.outputListeners[channel - 1] = new Vector();
            }
            if (!this.outputListeners[channel - 1].contains(l)) {
                this.outputListeners[channel - 1].addElement(l);
            }
        }
    }

    public void setScanRate(int scanrate) {
        this._scanRate = scanrate;
    }

    public void start() {
        this.runner.start();
        this.thd = new Thread((Runnable)this, "IO State Watcher");
        this.thd.setDaemon(true);
        this.thd.start();
    }

    public void stop() {
        try {
            this.running = false;
            System.out.println("Stopping IO Monitor");
            this.runner.stop();
            if (this.thd != null) {
                this.thd.join();
            }
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
            EmbeddedBase.BASE.log(ex.toString());
        }
    }

    @Override
    public void run() {
        this.running = true;
        int[] vers = null;
        try {
            vers = this.base.m_jnioros.getVersion();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            EmbeddedBase.BASE.log(ex.toString());
        }
        while (this.running) {
            try {
                long ioSignature = this.base.m_jnioros.getIoSignature();
                if (ioSignature != this.lastIoSignature) {
                    this.lastIoSignature = ioSignature;
                    this.inputChangeMask = this.getInputsChangeMask();
                    this.outputChangeMask = this.getOutputsChangeMask();
                    if (this.inputChangeMask != 0L || this.outputChangeMask != 0L) {
                        this.fireStateChanges(null);
                    }
                }
                try {
                    Thread.sleep(this._scanRate);
                }
                catch (Exception e) {
                    e.printStackTrace(System.out);
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace(System.out);
            }
        }
        System.out.println("   Stopping state monitor");
    }

    public synchronized long getInputsChangeMask() throws IOException {
        this.savedInputStateMask = this.inputStateMask;
        this.inputStateMask = this.base.m_jnioros.getInputStates();
        this.inputChangeMask = this.savedInputStateMask ^ this.inputStateMask;
        for (int i = 0; i < UnitConfig.InputCount; ++i) {
            int currentCount = this.base.m_jnioros.getInputCounter(i);
            if ((this.inputChangeMask & (long)(1 << i)) == 0L && currentCount != this.savedCounts[i] && currentCount != 0) {
                this.inputChangeMask |= (long)(1 << i);
            }
            this.deltaCounts[i] = currentCount - this.savedCounts[i];
            this.savedCounts[i] = currentCount;
        }
        return this.inputChangeMask;
    }

    public synchronized long getOutputsChangeMask() throws IOException {
        this.savedOutputStateMask = this.outputStateMask;
        this.outputStateMask = this.base.m_jnioros.getOutputStates();
        this.outputChangeMask = this.savedOutputStateMask ^ this.outputStateMask;
        return this.outputChangeMask;
    }

    public synchronized void fireStateChanges(int[] vers) {
        block13: {
            IOStateMessagePumpObject mpo;
            int channelMask;
            int channel;
            int i;
            block12: {
                IOStateMessagePumpObject mpo2;
                int channelMask2;
                int channel2;
                int i2;
                if (vers == null || vers[0] < 4) break block12;
                if (this.inputListeners != null) {
                    for (i2 = 0; i2 < UnitConfig.InputCount; ++i2) {
                        channel2 = i2 + 1;
                        if (this.inputListeners[i2] == null || (this.inputChangeMask & (long)(channelMask2 = 1 << i2)) == 0L) continue;
                        mpo2 = new IOStateMessagePumpObject(this.inputListeners[i2], 0, (byte)channel2, (byte)(this.inputStateMask >> i2 & 1L), this.inputStateMask, this.outputStateMask);
                        this._msgPump.put(mpo2);
                    }
                }
                if (this.outputListeners == null) break block13;
                for (i2 = 0; i2 < 16; ++i2) {
                    channel2 = i2 + 1;
                    if (this.outputListeners[i2] == null || (this.outputChangeMask & (long)(channelMask2 = 1 << i2)) == 0L) continue;
                    mpo2 = new IOStateMessagePumpObject(this.outputListeners[i2], 1, (byte)channel2, (byte)(this.outputStateMask >> i2 & 1L), this.inputStateMask, this.outputStateMask);
                    this._msgPump.put(mpo2);
                }
                break block13;
            }
            if (this.inputListeners != null) {
                for (i = 0; i < UnitConfig.InputCount; ++i) {
                    channel = i + 1;
                    if (this.inputListeners[i] == null || (this.inputChangeMask & (long)(channelMask = 1 << i)) == 0L) continue;
                    if ((this.savedInputStateMask & (long)channelMask) == 0L) {
                        if (this.deltaCounts[i] > 0) {
                            if ((this.inputStateMask & (long)channelMask) == 0L) {
                                mpo = new IOStateMessagePumpObject(this.inputListeners[i], 0, (byte)channel, 1, this.inputStateMask, this.outputStateMask);
                                this._msgPump.put(mpo);
                                mpo = new IOStateMessagePumpObject(this.inputListeners[i], 0, (byte)channel, 0, this.inputStateMask, this.outputStateMask);
                                this._msgPump.put(mpo);
                                continue;
                            }
                            mpo = new IOStateMessagePumpObject(this.inputListeners[i], 0, (byte)channel, 1, this.inputStateMask, this.outputStateMask);
                            this._msgPump.put(mpo);
                            continue;
                        }
                        mpo = new IOStateMessagePumpObject(this.inputListeners[i], 0, (byte)channel, 1, this.inputStateMask, this.outputStateMask);
                        this._msgPump.put(mpo);
                        continue;
                    }
                    if (this.deltaCounts[i] > 0) {
                        if ((this.inputStateMask & (long)channelMask) != 0L) {
                            mpo = new IOStateMessagePumpObject(this.inputListeners[i], 0, (byte)channel, 0, this.inputStateMask, this.outputStateMask);
                            this._msgPump.put(mpo);
                            mpo = new IOStateMessagePumpObject(this.inputListeners[i], 0, (byte)channel, 1, this.inputStateMask, this.outputStateMask);
                            this._msgPump.put(mpo);
                            mpo = new IOStateMessagePumpObject(this.inputListeners[i], 0, (byte)channel, 0, this.inputStateMask, this.outputStateMask);
                            this._msgPump.put(mpo);
                            continue;
                        }
                        mpo = new IOStateMessagePumpObject(this.inputListeners[i], 0, (byte)channel, 0, this.inputStateMask, this.outputStateMask);
                        this._msgPump.put(mpo);
                        mpo = new IOStateMessagePumpObject(this.inputListeners[i], 0, (byte)channel, 1, this.inputStateMask, this.outputStateMask);
                        this._msgPump.put(mpo);
                        continue;
                    }
                    mpo = new IOStateMessagePumpObject(this.inputListeners[i], 0, (byte)channel, 0, this.inputStateMask, this.outputStateMask);
                    this._msgPump.put(mpo);
                }
            }
            if (this.outputListeners != null) {
                for (i = 0; i < 16; ++i) {
                    channel = i + 1;
                    if (this.outputListeners[i] == null || (this.outputChangeMask & (long)(channelMask = 1 << i)) == 0L) continue;
                    mpo = new IOStateMessagePumpObject(this.outputListeners[i], 1, (byte)channel, (byte)(this.outputStateMask >> i & 1L), this.inputStateMask, this.outputStateMask);
                    this._msgPump.put(mpo);
                }
            }
        }
    }

    private void fireWatcherEvent(Vector v, int io, byte channel, byte state, long inputMask, long outputMask) {
        channel = (byte)(channel - 1);
        int size = v.size();
        for (int i = 0; i < size; ++i) {
            try {
                IOStateListener l = (IOStateListener)v.elementAt(i);
                if (l == null) continue;
                l.ioStateChange(io, (byte)(channel + 1), state, inputMask, outputMask);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    class IOStateListenerRunner
    implements Runnable {
        private MessagePump msgPump = null;
        private Thread thd = null;
        private boolean quit = false;

        public IOStateListenerRunner(MessagePump msgPump) {
            this.msgPump = msgPump;
        }

        public void start() {
            this.thd = new Thread((Runnable)this, "IO State Monitor Runner");
            this.thd.setDaemon(true);
            this.thd.start();
        }

        public void stop() {
            try {
                this.quit = true;
                this.msgPump.stop();
                if (this.thd != null) {
                    this.thd.join();
                }
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
                EmbeddedBase.BASE.log(ex.toString());
            }
        }

        @Override
        public void run() {
            this.quit = false;
            while (!this.quit) {
                Object o = this.msgPump.get();
                if (o == null) continue;
                IOStateMessagePumpObject mpo = (IOStateMessagePumpObject)o;
                IOStateMonitor.this.fireWatcherEvent(mpo.listeners, mpo.io, mpo.channel, mpo.state, mpo.inputMask, mpo.outputMask);
            }
        }
    }
}

