/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.threading.timers;

public abstract class TimerTask
implements Comparable,
Runnable {
    private final String _name;
    private long _lastCheckTime = 0L;
    protected long _nextExecutionTime = Long.MAX_VALUE;
    protected boolean _cancelled = false;

    protected TimerTask(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public long getNextExecutionTime() {
        return this._nextExecutionTime;
    }

    public boolean shouldTrigger() {
        long now = System.currentTimeMillis();
        boolean shouldTrigger = this._lastCheckTime < this._nextExecutionTime && now > this._nextExecutionTime;
        this._lastCheckTime = now;
        return shouldTrigger;
    }

    public void cancel() {
        System.out.println("Cancel " + this._name + " timer");
        this._cancelled = true;
    }

    @Override
    public void run() {
        throw new RuntimeException("Timer Run method not overriden");
    }

    public int compareTo(Object obj) {
        TimerTask otherTimerTask = (TimerTask)obj;
        if (this._nextExecutionTime < otherTimerTask._nextExecutionTime) {
            return -1;
        }
        if (this._nextExecutionTime > otherTimerTask._nextExecutionTime) {
            return 1;
        }
        return 0;
    }

    public boolean isDone() {
        return true;
    }

    public abstract void updateExecutionTime();

    public String toString() {
        return this._name + " - Next Execution Time " + this._nextExecutionTime;
    }
}

