/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.logging;

import com.integpg.janoslib.logging.Logger;
import com.integpg.janoslib.text.QuickDateFormat;

public class AppLog {
    private static Logger LOG = null;
    private static Logger ERROR_LOG = null;
    private static Logger DEBUG_LOG = null;

    private static void throwAppLogNotDefinedException() {
        AppLog.fatal("AppLog has not been defined.  Please use AppLog.init()");
    }

    public static void init(String applicationName) {
        LOG = Logger.getLogger(applicationName.toLowerCase() + ".log");
        ERROR_LOG = Logger.getLogger(applicationName.toLowerCase() + "_errors.log");
        DEBUG_LOG = Logger.getLogger("/temp/" + applicationName.toLowerCase() + "_debug.log");
    }

    public static void printf(String format, Object ... params) {
        LOG.printf(format, params);
    }

    public static void vital(Object object) {
        if (null == LOG) {
            AppLog.throwAppLogNotDefinedException();
        }
        LOG.vital(object);
    }

    public static void debug(Object object) {
        if (null == DEBUG_LOG) {
            AppLog.throwAppLogNotDefinedException();
        }
        DEBUG_LOG.debug(object);
    }

    public static void info(Object object) {
        if (null == LOG) {
            AppLog.throwAppLogNotDefinedException();
        }
        LOG.info(object);
    }

    public static void warn(Object object) {
        if (null == LOG) {
            AppLog.throwAppLogNotDefinedException();
        }
        LOG.warn(object);
    }

    public static void error(Object object) {
        if (null == LOG) {
            AppLog.throwAppLogNotDefinedException();
        }
        LOG.error(object);
    }

    public static void error(Exception ex) {
        if (null == LOG) {
            AppLog.throwAppLogNotDefinedException();
        }
        if (null != ex.getMessage() && !"".equals(ex.getMessage())) {
            LOG.error(String.format("%s - check %s for more details", ex.getMessage(), ERROR_LOG.getFilename()));
        }
        ERROR_LOG.error(ex);
    }

    public static void error(Object object, Throwable ex) {
        if (null == LOG) {
            AppLog.throwAppLogNotDefinedException();
        }
        if (null != ex.getMessage() && !"".equals(ex.getMessage())) {
            LOG.error(String.format("%s - check %s for more details", ex.getMessage(), ERROR_LOG.getFilename()));
        }
        ERROR_LOG.error(object, ex);
    }

    public static void fatal(Object object) {
        AppLog.fatal(new RuntimeException(object.toString()));
    }

    public static void fatal(Exception ex) {
        String stackTrace = Logger.getStackTrace(ex);
        System.err.println(String.format("%s: %s", QuickDateFormat.getDefault().format(), stackTrace));
        System.exit(-1);
    }
}

