/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.messaging.websocket;

import com.integpg.janoslib.io.AppLog;
import com.integpg.system.ArrayUtils;

public class WebsocketClientInformation {
    public static WebsocketClientInformation NO_SENDER = new WebsocketClientInformation(new byte[6]);
    private byte[] _sender;

    public WebsocketClientInformation(byte[] sender) {
        this._sender = sender;
    }

    public byte[] getSender() {
        return this._sender;
    }

    public String getClientString() {
        return WebsocketClientInformation.getClientString(this._sender);
    }

    public static String getClientString(byte[] sender) {
        try {
            String ipAddress = (sender[0] & 0xFF) + "." + (sender[1] & 0xFF) + "." + (sender[2] & 0xFF) + "." + (sender[3] & 0xFF);
            int port = ArrayUtils.getShort((byte[])sender, (int)4) & 0xFFFF;
            return ipAddress + ":" + port;
        }
        catch (Exception ex) {
            AppLog.error("Error getting client string", ex);
            return "";
        }
    }
}

