/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.logger;

import com.integpg.janoslib.logger.BakLogOutputStream;
import com.integpg.janoslib.logger.BufferedLineOutputStream;
import com.integpg.janoslib.logger.FileLogService;
import com.integpg.janoslib.logger.Log;
import com.integpg.janoslib.logger.LogOptions;
import com.integpg.janoslib.logger.LogOutputStream;
import com.integpg.janoslib.logger.LogTypes;
import com.integpg.janoslib.logger.RollingLogOutputStream;
import com.integpg.janoslib.logger.SystemOutLog;
import com.integpg.janoslib.system.Application;
import com.integpg.janoslib.text.QuickDateFormat;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.Hashtable;

public class FileLog
extends Log {
    private final QuickDateFormat _quickDateFormat = new QuickDateFormat("MM/dd/yy HH:mm:ss.fff zzz");
    private final LogOptions _logOptions;
    private final String _firstEntry = String.format("%s, %s", this._quickDateFormat.format(System.currentTimeMillis()), "--------------------------------------------------");
    private long _nextFlushTime = Long.MAX_VALUE;
    private boolean _firstWrite = true;
    private boolean _isBackground;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Log getLog(LogOptions logOptions) {
        try {
            Hashtable<String, Log> hashtable = FileLogService.LOGS_CACHE;
            synchronized (hashtable) {
                String filename = logOptions.getFilePath().toLowerCase();
                if (!FileLogService.LOGS_CACHE.containsKey(filename)) {
                    System.out.println("log file: " + filename + " with max size of " + logOptions.getMaxFileSize());
                    FileLog fileLog = new FileLog(logOptions);
                    FileLogService.LOGS_CACHE.put(filename, fileLog);
                }
                return FileLogService.LOGS_CACHE.get(filename);
            }
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace(System.out);
            return new SystemOutLog();
        }
    }

    private FileLog(LogOptions logOptions) throws FileNotFoundException {
        this._logOptions = logOptions;
        LogOutputStream logOutputStream = null;
        if (LogTypes.Rolling == this._logOptions.getLogType()) {
            logOutputStream = new RollingLogOutputStream(logOptions);
        } else if (LogTypes.SingleBak == this._logOptions.getLogType()) {
            logOutputStream = new BakLogOutputStream(logOptions);
        }
        if (null != logOutputStream) {
            super.setPrintStream(new PrintStream(new BufferedLineOutputStream(logOutputStream, 1024)));
        }
        this._isBackground = Application.isBackground();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void println(String s) {
        FileLog fileLog = this;
        synchronized (fileLog) {
            if (this._firstWrite) {
                super.println(this._firstEntry);
                this._firstWrite = false;
            }
            if (!this._isBackground) {
                System.out.println(s);
            }
            super.print(String.format("%s, %s\r\n", this._quickDateFormat.format(System.currentTimeMillis()), s));
            this._nextFlushTime = System.currentTimeMillis() + 5000L;
            if (this._finalized) {
                this._nextFlushTime = System.currentTimeMillis();
                this.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        FileLog fileLog = this;
        synchronized (fileLog) {
            if (System.currentTimeMillis() >= this._nextFlushTime) {
                System.out.println(String.format("%s flushed", this._logOptions.getFilePath()));
                this._printStream.flush();
                this._nextFlushTime = Long.MAX_VALUE;
            }
        }
    }

    public void finalize() {
        if (null != this._logOptions) {
            System.out.println(String.format("%s finalize", this._logOptions.getFilePath()));
            this._nextFlushTime = System.currentTimeMillis();
            this.flush();
            this._finalized = true;
        }
    }
}

