var JnrWebsocket = new JnrWebsocket();


var TaskerApp = angular.module("TaskerApp", ['moment-picker']);

TaskerApp.directive('spinner', function ($compile) {
    return {
        restrict: 'A', // attribute
        scope: {
            value: '=',
            min: '@',
            max: '@',
            init: '@',
            roll: '@',
            width: '@'
        },
        link: function ($scope, element, attrs) {
            var spinnerGuid = guid();
            var spinnerId = 'spinner-' + spinnerGuid;
            $scope.init = $scope.init || 0;
            $scope.value = $scope.value || $scope.init;
            $scope.min = $scope.min || 0;
            $scope.roll = $scope.roll || false;

            var html = '<div class="input-group spinner" id="' + spinnerId + '" style="width:{{width}}px;">' +
                '  <input type="number" class="form-control" ng-model=value >' +
                '  <div class="input-group-btn-vertical">' +
                '    <button class="btn btn-default" type="button"><i class="fa fa-caret-up"></i></button>' +
                '    <button class="btn btn-default" type="button"><i class="fa fa-caret-down"></i></button>' +
                '  </div>' +
                '</div>';

            element.html(html).show();
            $compile(element.contents())($scope);

            $('#' + spinnerId + ' .btn:first-of-type').on('click', function () {
                var value = parseInt($('#' + spinnerId + ' input').val());
                if (undefined != $scope.max && $scope.max == value) {
                    if (undefined != $scope.roll && $scope.roll) value = $scope.min;
                } else {
                    value++;
                }
                // if ($scope.max < value) value = $scope.min;
                $('#' + spinnerId + ' input').val(value).trigger('input');
            });
            $('#' + spinnerId + ' .btn:last-of-type').on('click', function () {
                var value = parseInt($('#' + spinnerId + ' input').val());
                if (undefined != $scope.min && $scope.min == value) {
                    if (undefined != $scope.roll && $scope.roll) value = $scope.max;
                } else {
                    value--;
                }
                // if ($scope.min > value) value = $scope.max;
                $('#' + spinnerId + ' input').val(value).trigger('input');
            });

            $('[data-toggle="tooltip"]').tooltip();
        }
    };
});



TaskerApp.directive('textSelect', function ($compile) {
    return {
        restrict: 'A', // attribute
        scope: {
            value: '=',
            index: '@',
            choices: '='
        },
        link: function ($scope, element, attrs) {
            var id = 'displayValue-' + $scope.index;

            var html = ' <div style="position:relative;margin-top:-16px;">\r\n' +
                '    <select class="form-control"\r\n' +
                '        style="position:absolute;top:0px;left:0px;margin:0;padding:0;"\r\n' +
                '        onchange="document.getElementById(\'' + id + '\').value=this.options[this.selectedIndex].text; document.getElementById(\'' + id + '\').value=this.options[this.selectedIndex].value;"\r\n' +
                '        ng-model="value"\r\n' +
                '        ng-options="c.Name as c.Name for c in choices"\r\n' +
                '        data-toggle="tooltip" title="Select a Task that will be executed"\r\n' +
                '        name="schedule-select-taskname-{{index}}" required>\r\n' +
                '    </select>\r\n' +
                '    <input type="text" id="' + id + '" class="form-control"\r\n' +
                '        ng-model="value" placeholder="add/select a value"\r\n' +
                '        onfocus="this.select()"\r\n' +
                '        style="position:absolute;top:0px;left:0px;width:calc(100% - 20px);border-right:0;border-radius:4px 0 0 4px;"\r\n' +
                '        name="schedule-taskname-{{index}}" required>\r\n' +
                '    <input name="idValue" id="idValue" type="hidden">\r\n' +
                '</div>';

            element.html(html).show();
            $compile(element.contents())($scope);

            $('[data-toggle="tooltip"]').tooltip();
        }
    };
});



toastr.options.positionClass = 'toast-bottom-full-width';
toastr.options.tapToDismiss = false;



function guid() {
    function s4() {
        return Math.floor((1 + Math.random()) * 0x10000)
            .toString(16)
            .substring(1);
    }
    return s4() + s4() + '-' + s4() + '-' + s4() + '-' +
        s4() + '-' + s4() + s4() + s4();
};



function preventSpaces() {
    $(".prevent-spaces").on({
        keydown: function (e) {
            if (e.which === 32)
                return false;
        },
        change: function () {
            this.value = this.value.replace(/\s/g, "_");
        }
    });
}



var validate_alphanumeric = function ($elem) {
    $elem.keypress(function (evt) {
        var char = String.fromCharCode(evt.which);

        // replace a space with and underscore
        var newChar = char.replace(/ /g, '_');

        // remove digits at the beginning of the name
        if (0 == this.selectionStart) {
            newChar = newChar.replace(/\d/, '');
        }

        // remove all non alphanumeric characters
        newChar = newChar.replace(/([^a-zA-Z0-9_\.])/, '');

        // if the character was nullified then return.  else replace 
        //  the character in the selection range
        if ('' == newChar) return false;
        if (newChar != char) {
            this.setRangeText(newChar, this.selectionStart, this.selectionEnd, "end");
            return false;
        }
    });
}



var submit_on_enter = function ($elem) {
    $elem.keyup(function (e) {
        if (e.which == 13) {
            e.preventDefault();
            $(".bootbox .btn-submit").click();
        }
    });
}



class TaskerObject {
    constructor() {
        // placing this in the constructor will ensure that every object gets a GUID.  if we 
        // preserving the GUID correctly then we will overwrite this one. if the object was
        // previously assigned one.
        this.GUID = guid();
        this.Params = {};
    }
}




var draggedScope;
var draggedElement;
var dropScope;
var dropTarget;
var _lastDropTarget = null;
var _dragEnabled = false;


var getClosest = function (elem, selector) {
    for (; elem && elem !== document; elem = elem.parentNode) {
        if (elem.matches(selector)) return elem;
    }
    return null;
};



var isDropTargetAChildOfDraggedTarget = function (draggedElement, dropElement) {
    // validate the draggedElement and dropElement
    if (!draggedElement || !dropElement) return false;

    if (draggedElement == dropElement) return true;

    var draggedElementScope = draggedElement.scope();
    var dropElementScope = dropElement.scope();

    if (draggedElementScope.childAction == dropElementScope.action) return true;
    if (draggedElementScope.childAction.actions) {
        draggedElementScope.childAction.actions.forEach(function (childAction) {

        });
    }
};



TaskerApp.directive('draggable', function () {
    return {
        restrict: 'A', // attribute
        scope: {
            action: '=',
            index: '='
        },
        link: function (scope, element, attrs) {
            element.attr('draggable', true);
            element.attr('index', scope.index);
            element.addClass('draggable');

            element[0].addEventListener("mousedown", function (event) {
                var clickedElement = event.target;
                var classList = clickedElement.classList;
                _dragEnabled = (classList.contains("fa-bars"));

                var draggableElement = getClosest(clickedElement, '.draggable');
                if (_dragEnabled) {
                    draggableElement.setAttribute('draggable', _dragEnabled);
                } else {
                    draggableElement.removeAttribute('draggable');
                }
            });

            element[0].addEventListener("dragstart", function (event) {
                var currentTarget = event.currentTarget;
                var draggableElement = getClosest(currentTarget, '.draggable');
                var draggable = draggableElement.getAttribute('draggable');

                if (draggable && !draggedScope) {
                    draggedScope = scope;
                    draggedElement = angular.element(currentTarget);

                    // make it half transparent
                    event.target.style.opacity = .5;

                    // get the object we are dropping
                    var draggedAction = event.dataTransfer.getData("action");
                    if (!draggedAction) {
                        event.dataTransfer.setData("action", scope.action);
                        event.dataTransfer.dropEffect = 'move';
                    }
                }
            }, false);

            element[0].addEventListener("dragenter", function (event) {
                // prevent default action
                event.preventDefault();
                event.stopPropagation();

                dropScope = scope;

                dropTarget = event.currentTarget;
                if (dropTarget && null != dropTarget && dropElement && null != dropElement) {
                    if (dropElement && isDropTargetAChildOfDraggedTarget(draggedElement, dropElement)) {
                        if (_lastDropTarget) {
                            _lastDropTarget.style['border-top'] = "";
                            _lastDropTarget.style['border-bottom'] = "";
                            _lastDropTarget.style['background'] = "";
                        }
                        return;
                    }

                    // var dropElement = angular.element(event.currentTarget);
                    // dropTarget.style['background'] = "#fff9e5";
                }

            });

            element[0].addEventListener("dragover", function (event) {
                // prevent default action
                event.preventDefault();
                event.stopPropagation();

                dropTarget = event.currentTarget;
                if (null != dropTarget) {
                    var dropElement = angular.element(event.currentTarget);

                    if (isDropTargetAChildOfDraggedTarget(draggedElement, dropElement)) {
                        if (_lastDropTarget) {
                            _lastDropTarget.style['border-top'] = "";
                            _lastDropTarget.style['border-bottom'] = "";
                            _lastDropTarget.style['background'] = "";
                        }
                        return;
                    }




                    var clickedElement = event.target;
                    var classList = clickedElement.classList;
                    var addActionElement = (classList.contains("add-action"));

                    // if (dropTarget != _lastDropTarget) {

                    //     if (null != _lastDropTarget) {
                    //         _lastDropTarget.style['border-top'] = "";
                    //         _lastDropTarget.style['border-bottom'] = "";
                    //         _lastDropTarget.style['background'] = "";
                    //     }

                    //     _lastDropTarget = dropTarget;
                    // }

                    if (draggedScope && draggedScope.action != dropScope.action) {
                        var y = event.offsetY;
                        if (y < event.currentTarget.clientHeight / 2) {
                            dropTarget.above = true;
                            dropTarget.below = false;

                            dropTarget.style['border-top'] = "3px solid";
                            dropTarget.style['border-bottom'] = "";

                        } else if (!addActionElement && y >= event.currentTarget.clientHeight / 2) {
                            dropTarget.above = false;
                            dropTarget.below = true;

                            dropTarget.style['border-top'] = "";
                            dropTarget.style['border-bottom'] = "3px solid";

                        }
                    } else {
                        dropTarget.style['border-top'] = "";
                        dropTarget.style['border-bottom'] = "";
                    }
                }

            });

            element[0].addEventListener("dragleave", function (event) {
                // prevent default action
                event.preventDefault();

                var currentTarget = event.currentTarget;
                // console.log('dragleave currentTarget: ' + currentTarget.innerHTML);
                if (currentTarget && currentTarget != dropTarget) {
                    currentTarget.style['border-top'] = "";
                    currentTarget.style['border-bottom'] = "";
                    currentTarget.style['background'] = "#fff";
                }
            });

            element[0].addEventListener("dragend", function (event) {

                if (null != dropTarget) {
                    dropTarget.style['border-top'] = "";
                    dropTarget.style['border-bottom'] = "";
                    dropTarget.style['background'] = "";
                }

                _lastDropTarget = null;

                // restore transparency
                if (event.target.style) {
                    event.target.style.opacity = 1;
                }
            });
        }
    };
});



TaskerApp.directive('droppable', function () {
    return {
        restrict: 'A', // attribute
        scope: {
            action: '='
        },
        link: function (scope, element, attrs) {

            element[0].ondragover = function (event) {
                // prevent default action
                event.preventDefault();
            };


            element[0].onleave = function (event) {
                // prevent default action
                event.preventDefault();

                event.dataTransfer.dropEffect = 'none';
                draggedScope = null;
                dropScope = null;
            };


            element[0].ondrop = function (event) {
                // prevent default action
                event.preventDefault();

                if (draggedScope) {
                    // console.log('dropping ' + draggedScope + ' to ' + event.currentTarget.innerText);

                    var draggedElementScope = draggedElement.scope();
                    var draggedActionsList = draggedElementScope.actions;

                    var dropElement = angular.element(event.currentTarget);
                    var dropElementScope = dropElement.scope();
                    var dropActionsList = dropElementScope.actions;

                    var sameTarget = (draggedActionsList == dropActionsList);

                    if (!isDropTargetAChildOfDraggedTarget(draggedElement, dropElement)) {

                        // remove from current position
                        draggedActionsList.splice(draggedScope.index, 1);

                        if (sameTarget) {
                            // add to new position
                            if (dropScope.index < draggedScope.index) {
                                if (dropTarget.above) {
                                    dropActionsList.splice(dropScope.index, 0, draggedScope.action);
                                } else {
                                    dropActionsList.splice(dropScope.index + 1, 0, draggedScope.action);
                                }
                            } else {
                                if (dropTarget.above) {
                                    dropActionsList.splice(dropScope.index - 1, 0, draggedScope.action);
                                } else {
                                    dropActionsList.splice(dropScope.index, 0, draggedScope.action);
                                }
                            }
                        } else {
                            var index = dropScope.index;
                            if (dropTarget.below) index += 1;
                            console.log('dropping ' + draggedScope.action + ' at index ' + index + ", " + dropTarget.below);
                            dropActionsList.splice(index, 0, draggedScope.action);
                        }
                    }

                    if (null != event.dataTransfer) {
                        event.dataTransfer.dropEffect = 'none';
                    }
                    draggedScope = null;
                    dropScope = null;

                    scope.$apply();
                }
            };
        }
    };
});
