/* global bootbox, Tasker */

TaskerApp.controller('LoggerController', function ($scope, $compile, LoggerService) {
    var _this = this;



    _this.areLoggersLoaded = function () {
        return LoggerService.LoggersLoaded;
    };



    _this.getLoggers = function () {
        return LoggerService.LoggersList;
    };



    _this.addLoggerProfile = function () {
        bootbox.prompt({
            className: 'bb-success',
            title: "What is the name of the new Logger?",
            buttons: {
                cancel: {
                    label: 'Cancel',
                    className: 'btn-default'
                },
                confirm: {
                    label: 'Add',
                    className: 'btn-success'
                }
            },
            callback: function (result) {
                if (result) {
                    if (undefined == LoggerService.LoggersList) LoggerService.LoggersList = [];

                    // make sure there isnt already one with the same name
                    if (LoggerService.LoggersList) {
                        for (var i = 0; i < LoggerService.LoggersList.length; i++) {
                            if (LoggerService.LoggersList[i].Name === result) {
                                bootbox.alert({
                                    className: 'bb-danger',
                                    title: "Duplicate Logger Name",
                                    message: "Logger already exists with the name: <b>" + result + '</b>'
                                });
                                return false;
                            }
                        }
                    }

                    LoggerService.LoggersList.push({ Name: result, Params: { Enabled: true, FileName: '/flash/tasker/logging', FilesToRetain: 30 }, GUID: guid() });
                    $scope.$apply();
                }
            }
        }).init(function () {
            validate_alphanumeric($(".bootbox-input"));
            submit_on_enter($(".bootbox-input"));
        });
    };



    _this.editLoggerName = function (logger) {
        bootbox.prompt({
            title: "Edit the name of the Logger?",
            message: '<p class="alert alert-warning"><b>Careful!</b>  Changing the name of the' +
                ' Logger can have negative consequences if it it referenced elsewhere in Tasker. ' +
                ' Please make sure to change the name used in the references.</p>',
            buttons: {
                cancel: {
                    label: 'Cancel',
                    className: 'btn-default'
                },
                confirm: {
                    label: 'Update',
                    className: 'btn-success'
                }
            },
            value: logger.Name,
            callback: function (result) {
                if (result) {
                    logger.Name = result;
                    $scope.$apply();
                }
            }
        }).init(function () {
            validate_alphanumeric($(".bootbox-input"));
            submit_on_enter($(".bootbox-input"));

            $(".modal-header").css("background-color", "#5cb85c");
            $(".modal-header").css("color", "#fff");
        });
    };



    _this.removeLoggerProfile = function (loggerProfile) {
        _this.SaveDialog = bootbox.confirm({
            className: 'bb-warning',
            title: "Are you sure you want to remove the " + loggerProfile.Name + " logger profile?",
            message: "Are you sure you want to remove the <b>" + loggerProfile.Name + "</b> logger profile?",
            buttons: {
                cancel: {
                    label: 'Cancel',
                    className: 'btn-default'
                },
                confirm: {
                    label: 'Remove',
                    className: 'btn-warning'
                }
            },
            callback: function (result) {
                if (result) {
                    for (var i = LoggerService.LoggersList.length - 1; i >= 0; i--) {
                        if (LoggerService.LoggersList[i] === loggerProfile) {
                            LoggerService.LoggersList.splice(i, 1);
                            $scope.$apply();
                            return;
                        }
                    }
                }
            }
        });
        _this.SaveDialog.init(function () {
            $("#bootbox-confirm-btn").prop('disabled', false);
            $("#bootbox-cancel-btn").prop('disabled', false);
        });
    };

});



/*
   SERVICE
*/
TaskerApp.service('LoggerService', function ($rootScope) {
    var _this = this;
    _this.LoggersList = [];
    _this.SelectedLogger = null;
    _this.LoggersLoaded = false;



    _this.load = function (loggerListJson) {
        if (undefined == loggerListJson) return;

        try {
            parseLoggerList(loggerListJson);
        } catch (err) {
            console.error(err);
        }

        _this.SelectedLogger = null;
        _this.LoggersLoaded = true;

        return _this.LoggersList;
    };



    function parseLoggerList(loggerArray) {
        // empty our array of schedules
        _this.LoggersList = [];

        loggerArray.forEach(function (loggerJson) {
            _this.LoggersList.push(loggerJson);
        });
    };



    _this.validate = function () {
        var form = $("#loggers-form");
        form.validate({ errorPlacement: function (error, element) { } });
        return form.valid();
    };
});